/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.common.Closeable;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.connection.IConnectionRegistry;
import org.apache.qpid.server.protocol.AMQConnectionModel;
import org.apache.qpid.transport.TransportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionRegistry
implements IConnectionRegistry,
Closeable {
    private List<AMQConnectionModel> _registry = new CopyOnWriteArrayList<AMQConnectionModel>();
    private Logger _logger = Logger.getLogger(ConnectionRegistry.class);

    @Override
    public void initialise() {
    }

    @Override
    public void close() {
        this._logger.debug((Object)("Closing connection registry :" + this._registry.size() + " connections."));
        while (!this._registry.isEmpty()) {
            AMQConnectionModel connection = this._registry.get(0);
            this.closeConnection(connection, AMQConstant.CONNECTION_FORCED, "Broker is shutting down");
        }
    }

    @Override
    public void closeConnection(AMQConnectionModel connection, AMQConstant cause, String message) {
        try {
            connection.close(cause, message);
        }
        catch (TransportException e) {
            this._logger.warn((Object)("Error closing connection:" + e.getMessage()));
        }
        catch (AMQException e) {
            this._logger.warn((Object)("Error closing connection:" + e.getMessage()));
        }
    }

    @Override
    public void registerConnection(AMQConnectionModel connnection) {
        this._registry.add(connnection);
    }

    @Override
    public void deregisterConnection(AMQConnectionModel connnection) {
        this._registry.remove(connnection);
    }

    @Override
    public List<AMQConnectionModel> getConnections() {
        return new ArrayList<AMQConnectionModel>(this._registry);
    }
}

