/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.Collections;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.management.common.mbeans.ManagedExchange;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.ManagementActor;
import org.apache.qpid.server.management.AMQManagedObject;
import org.apache.qpid.server.management.ManagedObject;
import org.apache.qpid.server.management.ManagedObjectRegistry;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExchangeMBean<T extends AbstractExchange>
extends AMQManagedObject
implements ManagedExchange {
    protected OpenType[] _bindingItemTypes;
    protected CompositeType _bindingDataType;
    protected TabularType _bindinglistDataType;
    private T _exchange;

    public AbstractExchangeMBean(T abstractExchange) throws NotCompliantMBeanException {
        super(ManagedExchange.class, "Exchange");
        this._exchange = abstractExchange;
    }

    protected void init() throws OpenDataException {
        this._bindingItemTypes = new OpenType[2];
        this._bindingItemTypes[0] = SimpleType.STRING;
        this._bindingItemTypes[1] = new ArrayType(1, SimpleType.STRING);
        this._bindingDataType = new CompositeType("Exchange Binding", "Binding key and Queue names", COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), COMPOSITE_ITEM_DESCRIPTIONS.toArray(new String[COMPOSITE_ITEM_DESCRIPTIONS.size()]), this._bindingItemTypes);
        this._bindinglistDataType = new TabularType("Exchange Bindings", "Exchange Bindings for " + this.getName(), this._bindingDataType, TABULAR_UNIQUE_INDEX.toArray(new String[TABULAR_UNIQUE_INDEX.size()]));
    }

    @Override
    public ManagedObject getParentObject() {
        return ((AbstractExchange)this._exchange).getVirtualHost().getManagedObject();
    }

    public T getExchange() {
        return this._exchange;
    }

    @Override
    public String getObjectInstanceName() {
        return ObjectName.quote(((AbstractExchange)this._exchange).getName());
    }

    public String getName() {
        return ((AbstractExchange)this._exchange).getName();
    }

    public String getExchangeType() {
        return ((AbstractExchange)this._exchange).getTypeShortString().toString();
    }

    public Integer getTicketNo() {
        return ((AbstractExchange)this._exchange)._ticket;
    }

    public boolean isDurable() {
        return ((AbstractExchange)this._exchange)._durable;
    }

    public boolean isAutoDelete() {
        return ((AbstractExchange)this._exchange)._autoDelete;
    }

    @Override
    public ObjectName getObjectName() throws MalformedObjectNameException {
        String objNameString = super.getObjectName().toString();
        objNameString = objNameString + ",ExchangeType=" + this.getExchangeType();
        return new ObjectName(objNameString);
    }

    protected ManagedObjectRegistry getManagedObjectRegistry() {
        return ApplicationRegistry.getInstance().getManagedObjectRegistry();
    }

    public void createNewBinding(String queueName, String binding) throws JMException {
        VirtualHost vhost = ((AbstractExchange)this.getExchange()).getVirtualHost();
        AMQQueue queue = vhost.getQueueRegistry().getQueue(new AMQShortString(queueName));
        if (queue == null) {
            throw new JMException("Queue \"" + queueName + "\" is not registered with the virtualhost.");
        }
        CurrentActor.set(new ManagementActor(this._logActor.getRootMessageLogger()));
        try {
            vhost.getBindingFactory().addBinding(binding, queue, (Exchange)this.getExchange(), null);
        }
        catch (AMQException ex) {
            JMException jme = new JMException(ex.toString());
            throw new MBeanException(jme, "Error creating new binding " + binding);
        }
        CurrentActor.remove();
    }

    public void removeBinding(String queueName, String binding) throws JMException {
        VirtualHost vhost = ((AbstractExchange)this.getExchange()).getVirtualHost();
        AMQQueue queue = vhost.getQueueRegistry().getQueue(new AMQShortString(queueName));
        if (queue == null) {
            throw new JMException("Queue \"" + queueName + "\" is not registered with the virtualhost.");
        }
        CurrentActor.set(new ManagementActor(this._logActor.getRootMessageLogger()));
        try {
            vhost.getBindingFactory().removeBinding(binding, queue, (Exchange)this._exchange, Collections.<String, Object>emptyMap());
        }
        catch (AMQException ex) {
            JMException jme = new JMException(ex.toString());
            throw new MBeanException(jme, "Error removing binding " + binding);
        }
        CurrentActor.remove();
    }
}

