/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.qpid.framing.AMQTypedValue;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.message.AMQMessageHeader;

class HeadersBinding {
    private static final Logger _logger = Logger.getLogger(HeadersBinding.class);
    private final FieldTable _mappings;
    private final Binding _binding;
    private final Set<String> required = new HashSet<String>();
    private final Map<String, Object> matches = new HashMap<String, Object>();
    private boolean matchAny;

    public HeadersBinding(Binding binding) {
        this._binding = binding;
        if (this._binding != null) {
            this._mappings = FieldTable.convertToFieldTable(this._binding.getArguments());
            this.initMappings();
        } else {
            this._mappings = null;
        }
    }

    private void initMappings() {
        this._mappings.processOverElements(new FieldTable.FieldTableElementProcessor(){

            public boolean processElement(String propertyName, AMQTypedValue value) {
                if (HeadersBinding.isSpecial(propertyName)) {
                    HeadersBinding.this.processSpecial(propertyName, value.getValue());
                } else if (value.getValue() == null || value.getValue().equals("")) {
                    HeadersBinding.this.required.add(propertyName);
                } else {
                    HeadersBinding.this.matches.put(propertyName, value.getValue());
                }
                return true;
            }

            public Object getResult() {
                return null;
            }
        });
    }

    protected FieldTable getMappings() {
        return this._mappings;
    }

    public Binding getBinding() {
        return this._binding;
    }

    public boolean matches(AMQMessageHeader headers) {
        if (headers == null) {
            return this.required.isEmpty() && this.matches.isEmpty();
        }
        return this.matchAny ? this.or(headers) : this.and(headers);
    }

    private boolean and(AMQMessageHeader headers) {
        if (headers.containsHeaders(this.required)) {
            for (Map.Entry<String, Object> e : this.matches.entrySet()) {
                if (e.getValue().equals(headers.getHeader(e.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean or(AMQMessageHeader headers) {
        if (this.required.isEmpty()) {
            return this.matches.isEmpty() || this.passesMatchesOr(headers);
        }
        if (!this.passesRequiredOr(headers)) {
            return !this.matches.isEmpty() && this.passesMatchesOr(headers);
        }
        return true;
    }

    private boolean passesMatchesOr(AMQMessageHeader headers) {
        for (Map.Entry<String, Object> entry : this.matches.entrySet()) {
            if (!headers.containsHeader(entry.getKey()) || (entry.getValue() != null || headers.getHeader(entry.getKey()) != null) && !entry.getValue().equals(headers.getHeader(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    private boolean passesRequiredOr(AMQMessageHeader headers) {
        for (String name : this.required) {
            if (!headers.containsHeader(name)) continue;
            return true;
        }
        return false;
    }

    private void processSpecial(String key, Object value) {
        if ("X-match".equalsIgnoreCase(key)) {
            this.matchAny = this.isAny(value);
        } else {
            _logger.warn((Object)("Ignoring special header: " + key));
        }
    }

    private boolean isAny(Object value) {
        if (value instanceof String) {
            if ("any".equalsIgnoreCase((String)value)) {
                return true;
            }
            if ("all".equalsIgnoreCase((String)value)) {
                return false;
            }
        }
        _logger.warn((Object)("Ignoring unrecognised match type: " + value));
        return false;
    }

    static boolean isSpecial(Object key) {
        return key instanceof String && HeadersBinding.isSpecial((String)key);
    }

    static boolean isSpecial(String key) {
        return key.startsWith("X-") || key.startsWith("x-");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof HeadersBinding)) {
            return false;
        }
        HeadersBinding hb = (HeadersBinding)o;
        return !(this._binding == null ? hb.getBinding() != null : !this._binding.equals(hb.getBinding()));
    }
}

