/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange.headers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.AMQType;
import org.apache.qpid.framing.AMQTypedValue;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.exchange.headers.HeaderKey;
import org.apache.qpid.server.exchange.headers.HeaderKeyDictionary;
import org.apache.qpid.server.exchange.headers.HeaderMatcherResult;
import org.apache.qpid.server.exchange.headers.HeadersMatcherDFAState;

public class HeadersParser {
    private final HeaderKeyDictionary _dictionary = new HeaderKeyDictionary();
    private static final AMQShortString MATCHING_TYPE_KEY = new AMQShortString("x-match");
    private static final String ANY_MATCHING = "any";
    private static final AMQShortString RESERVED_KEY_PREFIX = new AMQShortString("x-");

    HeadersMatcherDFAState createStateMachine(FieldTable bindingArguments, HeaderMatcherResult result) {
        String matchingType = bindingArguments.getString(MATCHING_TYPE_KEY);
        boolean matchAny = matchingType.equalsIgnoreCase(ANY_MATCHING);
        if (matchAny) {
            return this.createStateMachineForAnyMatch(bindingArguments, result);
        }
        return this.createStateMachineForAllMatch(bindingArguments, result);
    }

    private HeadersMatcherDFAState createStateMachineForAnyMatch(FieldTable bindingArguments, HeaderMatcherResult result) {
        HeadersMatcherDFAState successState = new HeadersMatcherDFAState(Collections.EMPTY_MAP, Collections.singleton(result), this._dictionary);
        HashMap<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>> nextStateMap = new HashMap<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>>();
        HashSet<AMQShortString> seenKeys = new HashSet<AMQShortString>();
        for (Map.Entry entry : bindingArguments) {
            AMQShortString key = (AMQShortString)entry.getKey();
            AMQTypedValue value = (AMQTypedValue)entry.getValue();
            if (!seenKeys.add(key) || key.startsWith(RESERVED_KEY_PREFIX)) continue;
            AMQType type = value.getType();
            HeaderKey headerKey = this._dictionary.getOrCreate(key);
            Map<Object, HeadersMatcherDFAState> valueMap = type == AMQType.VOID || (type == AMQType.ASCII_STRING || type == AMQType.WIDE_STRING) && ((CharSequence)value.getValue()).length() == 0 ? Collections.singletonMap(null, successState) : Collections.singletonMap(value, successState);
            nextStateMap.put(headerKey, valueMap);
        }
        if (seenKeys.size() == 0) {
            return successState;
        }
        return new HeadersMatcherDFAState(nextStateMap, Collections.EMPTY_SET, this._dictionary);
    }

    private HeadersMatcherDFAState createStateMachineForAllMatch(FieldTable bindingArguments, HeaderMatcherResult result) {
        HashSet<AMQShortString> seenKeys = new HashSet<AMQShortString>();
        ArrayList<KeyValuePair> requiredTerms = new ArrayList<KeyValuePair>(bindingArguments.size());
        for (Map.Entry entry : bindingArguments) {
            AMQShortString key = (AMQShortString)entry.getKey();
            AMQTypedValue value = (AMQTypedValue)entry.getValue();
            if (!seenKeys.add(key) || key.startsWith(RESERVED_KEY_PREFIX)) continue;
            AMQType type = value.getType();
            if (type == AMQType.VOID || (type == AMQType.ASCII_STRING || type == AMQType.WIDE_STRING) && ((CharSequence)value.getValue()).length() == 0) {
                requiredTerms.add(new KeyValuePair(this._dictionary.getOrCreate(key), null));
                continue;
            }
            requiredTerms.add(new KeyValuePair(this._dictionary.getOrCreate(key), value));
        }
        HeadersMatcherDFAState successState = new HeadersMatcherDFAState(Collections.EMPTY_MAP, Collections.singleton(result), this._dictionary);
        HeadersMatcherDFAState failState = new HeadersMatcherDFAState(Collections.EMPTY_MAP, Collections.EMPTY_SET, this._dictionary);
        HashMap<Set, HeadersMatcherDFAState> notSeenTermsToStateMap = new HashMap<Set, HeadersMatcherDFAState>();
        notSeenTermsToStateMap.put(Collections.EMPTY_SET, successState);
        int numberOfTerms = requiredTerms.size();
        for (int numMissingTerms = 1; numMissingTerms <= numberOfTerms; ++numMissingTerms) {
            int[] pos = new int[numMissingTerms];
            for (int i = 0; i < numMissingTerms; ++i) {
                pos[i] = i;
            }
            int maxTermValue = numberOfTerms - (numMissingTerms - 1);
            block3: while (pos[0] < maxTermValue) {
                HashSet stateSet = new HashSet();
                for (int posIndex = 0; posIndex < pos.length; ++posIndex) {
                    stateSet.add(requiredTerms.get(pos[posIndex]));
                }
                HashMap<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>> nextStateMap = new HashMap<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>>();
                for (int posIndex = 0; posIndex < pos.length; ++posIndex) {
                    KeyValuePair nextTerm = (KeyValuePair)requiredTerms.get(pos[posIndex]);
                    HashSet nextStateSet = new HashSet(stateSet);
                    nextStateSet.remove(nextTerm);
                    HashMap valueToStateMap = new HashMap();
                    nextStateMap.put(nextTerm._key, valueToStateMap);
                    valueToStateMap.put(nextTerm._value, notSeenTermsToStateMap.get(nextStateSet));
                    if (nextTerm._value == null) continue;
                    valueToStateMap.put(null, failState);
                }
                HeadersMatcherDFAState newState = new HeadersMatcherDFAState(nextStateMap, Collections.EMPTY_SET, this._dictionary);
                notSeenTermsToStateMap.put(stateSet, newState);
                int i = numMissingTerms;
                while (i-- != 0) {
                    int n = i;
                    pos[n] = pos[n] + 1;
                    if (pos[n] > numberOfTerms - (numMissingTerms - i)) continue;
                    int k = pos[i];
                    for (int j = i + 1; j < numMissingTerms; ++j) {
                        pos[j] = ++k;
                    }
                    continue block3;
                }
            }
        }
        return (HeadersMatcherDFAState)notSeenTermsToStateMap.get(new HashSet(requiredTerms));
    }

    public static final class KeyValuePair {
        public final HeaderKey _key;
        public final AMQTypedValue _value;
        private final int _hashCode;

        public KeyValuePair(HeaderKey key, AMQTypedValue value) {
            this._key = key;
            this._value = value;
            int hash = 1 + 31 * this._key.hashCode();
            if (this._value != null) {
                hash += this._value.hashCode();
            }
            this._hashCode = hash;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object o) {
            assert (o != null);
            assert (o instanceof KeyValuePair);
            KeyValuePair other = (KeyValuePair)o;
            return this._key == other._key && (this._value == null ? other._value == null : this._value.equals((Object)other._value));
        }

        public String toString() {
            return "{" + this._key + " -> " + this._value + "}";
        }
    }
}

