/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange.topic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.topic.TopicMatcherResult;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.queue.AMQQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TopicExchangeResult
implements TopicMatcherResult {
    private final List<Binding> _bindings = new CopyOnWriteArrayList<Binding>();
    private final Map<AMQQueue, Integer> _unfilteredQueues = new ConcurrentHashMap<AMQQueue, Integer>();
    private final ConcurrentHashMap<AMQQueue, Map<MessageFilter, Integer>> _filteredQueues = new ConcurrentHashMap();

    public void addUnfilteredQueue(AMQQueue queue) {
        Integer instances = this._unfilteredQueues.get(queue);
        if (instances == null) {
            this._unfilteredQueues.put(queue, 1);
        } else {
            this._unfilteredQueues.put(queue, instances + 1);
        }
    }

    public void removeUnfilteredQueue(AMQQueue queue) {
        Integer instances = this._unfilteredQueues.get(queue);
        if (instances == 1) {
            this._unfilteredQueues.remove(queue);
        } else {
            this._unfilteredQueues.put(queue, instances - 1);
        }
    }

    public Collection<AMQQueue> getUnfilteredQueues() {
        return this._unfilteredQueues.keySet();
    }

    public void addBinding(Binding binding) {
        this._bindings.add(binding);
    }

    public void removeBinding(Binding binding) {
        this._bindings.remove(binding);
    }

    public List<Binding> getBindings() {
        return new ArrayList<Binding>(this._bindings);
    }

    public void addFilteredQueue(AMQQueue queue, MessageFilter filter) {
        Integer instances;
        Map<MessageFilter, Integer> filters = this._filteredQueues.get(queue);
        if (filters == null) {
            filters = new ConcurrentHashMap<MessageFilter, Integer>();
            this._filteredQueues.put(queue, filters);
        }
        if ((instances = filters.get(filter)) == null) {
            filters.put(filter, 1);
        } else {
            filters.put(filter, instances + 1);
        }
    }

    public void removeFilteredQueue(AMQQueue queue, MessageFilter filter) {
        Integer instances;
        Map<MessageFilter, Integer> filters = this._filteredQueues.get(queue);
        if (filters != null && (instances = filters.get(filter)) != null) {
            if (instances == 1) {
                filters.remove(filter);
                if (filters.isEmpty()) {
                    this._filteredQueues.remove(queue);
                }
            } else {
                filters.put(filter, instances - 1);
            }
        }
    }

    public void replaceQueueFilter(AMQQueue queue, MessageFilter oldFilter, MessageFilter newFilter) {
        Map<MessageFilter, Integer> filters = this._filteredQueues.get(queue);
        ConcurrentHashMap<MessageFilter, Integer> newFilters = new ConcurrentHashMap<MessageFilter, Integer>(filters);
        Integer oldFilterInstances = filters.get(oldFilter);
        if (oldFilterInstances == 1) {
            newFilters.remove(oldFilter);
        } else {
            newFilters.put(oldFilter, oldFilterInstances - 1);
        }
        Integer newFilterInstances = filters.get(newFilter);
        if (newFilterInstances == null) {
            newFilters.put(newFilter, 1);
        } else {
            newFilters.put(newFilter, newFilterInstances + 1);
        }
        this._filteredQueues.put(queue, newFilters);
    }

    public Collection<AMQQueue> processMessage(InboundMessage msg, Collection<AMQQueue> queues) {
        if (queues == null) {
            if (this._filteredQueues.isEmpty()) {
                return new ArrayList<AMQQueue>(this._unfilteredQueues.keySet());
            }
            queues = new HashSet<AMQQueue>();
        } else if (!(queues instanceof Set)) {
            queues = new HashSet<AMQQueue>(queues);
        }
        queues.addAll(this._unfilteredQueues.keySet());
        if (!this._filteredQueues.isEmpty()) {
            for (Map.Entry<AMQQueue, Map<MessageFilter, Integer>> entry : this._filteredQueues.entrySet()) {
                if (queues.contains(entry.getKey())) continue;
                for (MessageFilter filter : entry.getValue().keySet()) {
                    if (!filter.matches(msg)) continue;
                    queues.add(entry.getKey());
                }
            }
        }
        return queues;
    }
}

