/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.qpid.server.filter.BinaryExpression;
import org.apache.qpid.server.filter.BooleanExpression;
import org.apache.qpid.server.filter.ConstantExpression;
import org.apache.qpid.server.filter.Expression;
import org.apache.qpid.server.filter.LogicExpression;
import org.apache.qpid.server.filter.PropertyExpression;
import org.apache.qpid.server.filter.UnaryExpression;
import org.apache.qpid.server.queue.Filterable;

public abstract class ComparisonExpression
extends BinaryExpression
implements BooleanExpression {
    private static final HashSet<Character> REGEXP_CONTROL_CHARS = new HashSet();

    public static BooleanExpression createBetween(Expression value, Expression left, Expression right) {
        return LogicExpression.createAND(ComparisonExpression.createGreaterThanEqual(value, left), ComparisonExpression.createLessThanEqual(value, right));
    }

    public static BooleanExpression createNotBetween(Expression value, Expression left, Expression right) {
        return LogicExpression.createOR(ComparisonExpression.createLessThan(value, left), ComparisonExpression.createGreaterThan(value, right));
    }

    public static BooleanExpression createLike(Expression left, String right, String escape) {
        if (escape != null && escape.length() != 1) {
            throw new RuntimeException("The ESCAPE string litteral is invalid.  It can only be one character.  Litteral used: " + escape);
        }
        int c = -1;
        if (escape != null) {
            c = 0xFFFF & escape.charAt(0);
        }
        return new LikeExpression(left, right, c);
    }

    public static BooleanExpression createNotLike(Expression left, String right, String escape) {
        return UnaryExpression.createNOT(ComparisonExpression.createLike(left, right, escape));
    }

    public static BooleanExpression createInFilter(Expression left, List elements) {
        if (!(left instanceof PropertyExpression)) {
            throw new RuntimeException("Expected a property for In expression, got: " + left);
        }
        return UnaryExpression.createInExpression((PropertyExpression)left, elements, false);
    }

    public static BooleanExpression createNotInFilter(Expression left, List elements) {
        if (!(left instanceof PropertyExpression)) {
            throw new RuntimeException("Expected a property for In expression, got: " + left);
        }
        return UnaryExpression.createInExpression((PropertyExpression)left, elements, true);
    }

    public static BooleanExpression createIsNull(Expression left) {
        return ComparisonExpression.doCreateEqual(left, ConstantExpression.NULL);
    }

    public static BooleanExpression createIsNotNull(Expression left) {
        return UnaryExpression.createNOT(ComparisonExpression.doCreateEqual(left, ConstantExpression.NULL));
    }

    public static BooleanExpression createNotEqual(Expression left, Expression right) {
        return UnaryExpression.createNOT(ComparisonExpression.createEqual(left, right));
    }

    public static BooleanExpression createEqual(Expression left, Expression right) {
        ComparisonExpression.checkEqualOperand(left);
        ComparisonExpression.checkEqualOperand(right);
        ComparisonExpression.checkEqualOperandCompatability(left, right);
        return ComparisonExpression.doCreateEqual(left, right);
    }

    private static BooleanExpression doCreateEqual(Expression left, Expression right) {
        return new EqualExpression(left, right);
    }

    public static BooleanExpression createGreaterThan(Expression left, Expression right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression(left, right){

            protected boolean asBoolean(int answer) {
                return answer > 0;
            }

            public String getExpressionSymbol() {
                return ">";
            }
        };
    }

    public static BooleanExpression createGreaterThanEqual(Expression left, Expression right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression(left, right){

            protected boolean asBoolean(int answer) {
                return answer >= 0;
            }

            public String getExpressionSymbol() {
                return ">=";
            }
        };
    }

    public static BooleanExpression createLessThan(Expression left, Expression right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression(left, right){

            protected boolean asBoolean(int answer) {
                return answer < 0;
            }

            public String getExpressionSymbol() {
                return "<";
            }
        };
    }

    public static BooleanExpression createLessThanEqual(Expression left, Expression right) {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new ComparisonExpression(left, right){

            protected boolean asBoolean(int answer) {
                return answer <= 0;
            }

            public String getExpressionSymbol() {
                return "<=";
            }
        };
    }

    public static void checkLessThanOperand(Expression expr) {
        if (expr instanceof ConstantExpression) {
            Object value = ((ConstantExpression)expr).getValue();
            if (value instanceof Number) {
                return;
            }
            throw new RuntimeException("Value '" + expr + "' cannot be compared.");
        }
        if (expr instanceof BooleanExpression) {
            throw new RuntimeException("Value '" + expr + "' cannot be compared.");
        }
    }

    public static void checkEqualOperand(Expression expr) {
        Object value;
        if (expr instanceof ConstantExpression && (value = ((ConstantExpression)expr).getValue()) == null) {
            throw new RuntimeException("'" + expr + "' cannot be compared.");
        }
    }

    private static void checkEqualOperandCompatability(Expression left, Expression right) {
        if (left instanceof ConstantExpression && right instanceof ConstantExpression && left instanceof BooleanExpression && !(right instanceof BooleanExpression)) {
            throw new RuntimeException("'" + left + "' cannot be compared with '" + right + "'");
        }
    }

    public ComparisonExpression(Expression left, Expression right) {
        super(left, right);
    }

    public Object evaluate(Filterable message) {
        Comparable lv = (Comparable)this.left.evaluate(message);
        if (lv == null) {
            return null;
        }
        Comparable rv = (Comparable)this.right.evaluate(message);
        if (rv == null) {
            return null;
        }
        return this.compare(lv, rv);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Boolean compare(Comparable lv, Comparable rv) {
        Class<?> rc;
        Class<?> lc = lv.getClass();
        if (lc == (rc = rv.getClass())) return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
        if (lc == Byte.class) {
            if (rc == Short.class) {
                lv = Short.valueOf(((Number)((Object)lv)).shortValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Integer.class) {
                lv = Integer.valueOf(((Number)((Object)lv)).intValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Long.class) {
                lv = Long.valueOf(((Number)((Object)lv)).longValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Float.class) {
                lv = Float.valueOf(((Number)((Object)lv)).floatValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rc != Double.class) return Boolean.FALSE;
                lv = Double.valueOf(((Number)((Object)lv)).doubleValue());
            }
            return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (lc == Short.class) {
            if (rc == Integer.class) {
                lv = Integer.valueOf(((Number)((Object)lv)).intValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Long.class) {
                lv = Long.valueOf(((Number)((Object)lv)).longValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Float.class) {
                lv = Float.valueOf(((Number)((Object)lv)).floatValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rc != Double.class) return Boolean.FALSE;
                lv = Double.valueOf(((Number)((Object)lv)).doubleValue());
            }
            return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (lc == Integer.class) {
            if (rc == Long.class) {
                lv = Long.valueOf(((Number)((Object)lv)).longValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Float.class) {
                lv = Float.valueOf(((Number)((Object)lv)).floatValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rc != Double.class) return Boolean.FALSE;
                lv = Double.valueOf(((Number)((Object)lv)).doubleValue());
            }
            return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (lc == Long.class) {
            if (rc == Integer.class) {
                rv = Long.valueOf(((Number)((Object)rv)).longValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Float.class) {
                lv = Float.valueOf(((Number)((Object)lv)).floatValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rc != Double.class) return Boolean.FALSE;
                lv = Double.valueOf(((Number)((Object)lv)).doubleValue());
            }
            return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (lc == Float.class) {
            if (rc == Integer.class) {
                rv = Float.valueOf(((Number)((Object)rv)).floatValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Long.class) {
                rv = Float.valueOf(((Number)((Object)rv)).floatValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rc != Double.class) return Boolean.FALSE;
                lv = Double.valueOf(((Number)((Object)lv)).doubleValue());
            }
            return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
        } else {
            if (lc != Double.class) return Boolean.FALSE;
            if (rc == Integer.class) {
                rv = Double.valueOf(((Number)((Object)rv)).doubleValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (rc == Long.class) {
                rv = Double.valueOf(((Number)((Object)rv)).doubleValue());
                return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (rc != Float.class) return Boolean.FALSE;
                rv = Double.valueOf(((Number)((Object)rv)).doubleValue());
            }
        }
        return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected abstract boolean asBoolean(int var1);

    public boolean matches(Filterable message) {
        Object object = this.evaluate(message);
        return object != null && object == Boolean.TRUE;
    }

    static {
        REGEXP_CONTROL_CHARS.add(Character.valueOf('.'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('\\'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('['));
        REGEXP_CONTROL_CHARS.add(Character.valueOf(']'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('^'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('$'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('?'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('*'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('+'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('{'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('}'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('|'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('('));
        REGEXP_CONTROL_CHARS.add(Character.valueOf(')'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf(':'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('&'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('<'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('>'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('='));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('!'));
    }

    private static class EqualExpression
    extends ComparisonExpression {
        public EqualExpression(Expression left, Expression right) {
            super(left, right);
        }

        public Object evaluate(Filterable message) {
            Object rv;
            Object lv = this.left.evaluate(message);
            if (lv == null ^ (rv = this.right.evaluate(message)) == null) {
                return Boolean.FALSE;
            }
            if (lv == rv || lv.equals(rv)) {
                return Boolean.TRUE;
            }
            if (lv instanceof Comparable && rv instanceof Comparable) {
                return this.compare((Comparable)lv, (Comparable)rv);
            }
            return Boolean.FALSE;
        }

        protected boolean asBoolean(int answer) {
            return answer == 0;
        }

        public String getExpressionSymbol() {
            return "=";
        }
    }

    static class LikeExpression
    extends UnaryExpression
    implements BooleanExpression {
        Pattern likePattern;

        public LikeExpression(Expression right, String like, int escape) {
            super(right);
            StringBuffer regexp = new StringBuffer(like.length() * 2);
            regexp.append("\\A");
            for (int i = 0; i < like.length(); ++i) {
                char c = like.charAt(i);
                if (escape == (0xFFFF & c)) {
                    if (++i >= like.length()) break;
                    char t = like.charAt(i);
                    regexp.append("\\x");
                    regexp.append(Integer.toHexString(0xFFFF & t));
                    continue;
                }
                if (c == '%') {
                    regexp.append(".*?");
                    continue;
                }
                if (c == '_') {
                    regexp.append(".");
                    continue;
                }
                if (REGEXP_CONTROL_CHARS.contains(Character.valueOf(c))) {
                    regexp.append("\\x");
                    regexp.append(Integer.toHexString(0xFFFF & c));
                    continue;
                }
                regexp.append(c);
            }
            regexp.append("\\z");
            this.likePattern = Pattern.compile(regexp.toString(), 32);
        }

        public String getExpressionSymbol() {
            return "LIKE";
        }

        public Object evaluate(Filterable message) {
            Object rv = this.getRight().evaluate(message);
            if (rv == null) {
                return null;
            }
            if (!(rv instanceof String)) {
                return Boolean.FALSE;
            }
            return this.likePattern.matcher((String)rv).matches() ? Boolean.TRUE : Boolean.FALSE;
        }

        public boolean matches(Filterable message) {
            Object object = this.evaluate(message);
            return object != null && object == Boolean.TRUE;
        }
    }
}

