/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.information.management;

import java.io.IOException;
import javax.management.JMException;
import org.apache.qpid.common.QpidProperties;
import org.apache.qpid.management.common.mbeans.ServerInformation;
import org.apache.qpid.management.common.mbeans.annotations.MBeanDescription;
import org.apache.qpid.server.management.AMQManagedObject;
import org.apache.qpid.server.registry.ApplicationRegistry;

@MBeanDescription(value="Server Information Interface")
public class ServerInformationMBean
extends AMQManagedObject
implements ServerInformation {
    private String buildVersion;
    private String productVersion;
    private ApplicationRegistry registry;

    public ServerInformationMBean(ApplicationRegistry applicationRegistry) throws JMException {
        super(ServerInformation.class, "ServerInformation");
        this.registry = applicationRegistry;
        this.buildVersion = QpidProperties.getBuildVersion();
        this.productVersion = QpidProperties.getReleaseVersion();
    }

    public String getObjectInstanceName() {
        return "ServerInformation";
    }

    public Integer getManagementApiMajorVersion() throws IOException {
        return 2;
    }

    public Integer getManagementApiMinorVersion() throws IOException {
        return 3;
    }

    public String getBuildVersion() throws IOException {
        return this.buildVersion;
    }

    public String getProductVersion() throws IOException {
        return this.productVersion;
    }

    public void resetStatistics() throws Exception {
        this.registry.resetStatistics();
    }

    public double getPeakMessageDeliveryRate() {
        return this.registry.getMessageDeliveryStatistics().getPeak();
    }

    public double getPeakDataDeliveryRate() {
        return this.registry.getDataDeliveryStatistics().getPeak();
    }

    public double getMessageDeliveryRate() {
        return this.registry.getMessageDeliveryStatistics().getRate();
    }

    public double getDataDeliveryRate() {
        return this.registry.getDataDeliveryStatistics().getRate();
    }

    public long getTotalMessagesDelivered() {
        return this.registry.getMessageDeliveryStatistics().getTotal();
    }

    public long getTotalDataDelivered() {
        return this.registry.getDataDeliveryStatistics().getTotal();
    }

    public double getPeakMessageReceiptRate() {
        return this.registry.getMessageReceiptStatistics().getPeak();
    }

    public double getPeakDataReceiptRate() {
        return this.registry.getDataReceiptStatistics().getPeak();
    }

    public double getMessageReceiptRate() {
        return this.registry.getMessageReceiptStatistics().getRate();
    }

    public double getDataReceiptRate() {
        return this.registry.getDataReceiptStatistics().getRate();
    }

    public long getTotalMessagesReceived() {
        return this.registry.getMessageReceiptStatistics().getTotal();
    }

    public long getTotalDataReceived() {
        return this.registry.getDataReceiptStatistics().getTotal();
    }

    public boolean isStatisticsEnabled() {
        return this.registry.isStatisticsEnabled();
    }
}

