/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.ManagementConsoleMessages;
import org.apache.qpid.server.management.MBeanInvocationHandlerImpl;
import org.apache.qpid.server.management.ManagedObject;
import org.apache.qpid.server.management.ManagedObjectRegistry;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.security.auth.rmi.RMIPasswordAuthenticator;

public class JMXManagedObjectRegistry
implements ManagedObjectRegistry {
    private static final Logger _log = Logger.getLogger(JMXManagedObjectRegistry.class);
    private final MBeanServer _mbeanServer;
    private JMXConnectorServer _cs;
    private Registry _rmiRegistry;
    private boolean _useCustomSocketFactory;
    private final int _jmxPortRegistryServer;
    private final int _jmxPortConnectorServer;

    public JMXManagedObjectRegistry() throws AMQException {
        _log.info((Object)"Initialising managed object registry using platform MBean server");
        IApplicationRegistry appRegistry = ApplicationRegistry.getInstance();
        this._useCustomSocketFactory = appRegistry.getConfiguration().getUseCustomRMISocketFactory();
        boolean platformServer = appRegistry.getConfiguration().getPlatformMbeanserver();
        this._mbeanServer = platformServer ? ManagementFactory.getPlatformMBeanServer() : MBeanServerFactory.createMBeanServer("org.apache.qpid");
        this._jmxPortRegistryServer = appRegistry.getConfiguration().getJMXPortRegistryServer();
        this._jmxPortConnectorServer = appRegistry.getConfiguration().getJMXConnectorServerPort();
    }

    public void start() throws IOException, ConfigurationException {
        String localHost;
        SslRMIServerSocketFactory ssf;
        SslRMIClientSocketFactory csf;
        CurrentActor.get().message(ManagementConsoleMessages.STARTUP());
        if (this.areOutOfTheBoxJMXOptionsSet()) {
            CurrentActor.get().message(ManagementConsoleMessages.READY(true));
            return;
        }
        IApplicationRegistry appRegistry = ApplicationRegistry.getInstance();
        boolean sslEnabled = appRegistry.getConfiguration().getManagementSSLEnabled();
        if (sslEnabled) {
            String keyStorePath = System.getProperty("javax.net.ssl.keyStore") != null ? System.getProperty("javax.net.ssl.keyStore") : appRegistry.getConfiguration().getManagementKeyStorePath();
            if (keyStorePath == null) {
                throw new ConfigurationException("JMX management SSL keystore path not defined, unable to start SSL protected JMX ConnectorServer");
            }
            System.setProperty("javax.net.ssl.keyStore", keyStorePath);
            File ksf = new File(keyStorePath);
            if (!ksf.exists()) {
                throw new FileNotFoundException("Cannot find JMX management SSL keystore file " + ksf + "\n" + "Check broker configuration, or see create-example-ssl-stores script" + "in the bin/ directory if you need to generate an example store.");
            }
            if (!ksf.canRead()) {
                throw new FileNotFoundException("Cannot read JMX management SSL keystore file: " + ksf + ". Check permissions.");
            }
            CurrentActor.get().message(ManagementConsoleMessages.SSL_KEYSTORE(ksf.getAbsolutePath()));
            if (System.getProperty("javax.net.ssl.keyStorePassword") == null) {
                if (appRegistry.getConfiguration().getManagementKeyStorePassword() == null) {
                    throw new ConfigurationException("JMX management SSL keystore password not defined, unable to start requested SSL protected JMX server");
                }
                System.setProperty("javax.net.ssl.keyStorePassword", appRegistry.getConfiguration().getManagementKeyStorePassword());
            }
            csf = new SslRMIClientSocketFactory();
            ssf = new SslRMIServerSocketFactory();
        } else {
            csf = null;
            ssf = null;
        }
        RMIPasswordAuthenticator rmipa = new RMIPasswordAuthenticator();
        rmipa.setAuthenticationManager(appRegistry.getAuthenticationManager());
        HashMap<String, RMIPasswordAuthenticator> env = new HashMap<String, RMIPasswordAuthenticator>();
        env.put("jmx.remote.authenticator", rmipa);
        System.setProperty("java.rmi.server.randomIDs", "true");
        this._rmiRegistry = this._useCustomSocketFactory ? LocateRegistry.createRegistry(this._jmxPortRegistryServer, null, new CustomRMIServerSocketFactory()) : LocateRegistry.createRegistry(this._jmxPortRegistryServer, null, null);
        CurrentActor.get().message(ManagementConsoleMessages.LISTENING("RMI Registry", this._jmxPortRegistryServer));
        final RMIJRMPServerImpl rmiConnectorServerStub = new RMIJRMPServerImpl(this._jmxPortConnectorServer, csf, ssf, env);
        try {
            localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            localHost = "127.0.0.1";
        }
        String hostname = localHost;
        final JMXServiceURL externalUrl = new JMXServiceURL("service:jmx:rmi://" + hostname + ":" + this._jmxPortConnectorServer + "/jndi/rmi://" + hostname + ":" + this._jmxPortRegistryServer + "/jmxrmi");
        JMXServiceURL internalUrl = new JMXServiceURL("rmi", hostname, this._jmxPortConnectorServer);
        this._cs = new RMIConnectorServer(internalUrl, env, rmiConnectorServerStub, this._mbeanServer){

            public synchronized void start() throws IOException {
                try {
                    JMXManagedObjectRegistry.this._rmiRegistry.bind("jmxrmi", rmiConnectorServerStub);
                }
                catch (AlreadyBoundException abe) {
                    IOException ioe = new IOException(abe.getMessage());
                    ioe.initCause(abe);
                    throw ioe;
                }
                super.start();
            }

            public synchronized void stop() throws IOException {
                try {
                    if (JMXManagedObjectRegistry.this._rmiRegistry != null) {
                        JMXManagedObjectRegistry.this._rmiRegistry.unbind("jmxrmi");
                    }
                }
                catch (NotBoundException notBoundException) {
                    // empty catch block
                }
                super.stop();
            }

            public JMXServiceURL getAddress() {
                return externalUrl;
            }
        };
        MBeanServerForwarder mbsf = MBeanInvocationHandlerImpl.newProxyInstance();
        this._cs.setMBeanServerForwarder(mbsf);
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("jmx.remote.connection.opened");
        filter.enableType("jmx.remote.connection.closed");
        filter.enableType("jmx.remote.connection.failed");
        this._cs.addNotificationListener((NotificationListener)((Object)Proxy.getInvocationHandler(mbsf)), filter, null);
        this._cs.start();
        String connectorServer = (sslEnabled ? "SSL " : "") + "JMX RMIConnectorServer";
        CurrentActor.get().message(ManagementConsoleMessages.LISTENING(connectorServer, this._jmxPortConnectorServer));
        CurrentActor.get().message(ManagementConsoleMessages.READY(false));
    }

    public void registerObject(ManagedObject managedObject) throws JMException {
        this._mbeanServer.registerMBean(managedObject, managedObject.getObjectName());
    }

    public void unregisterObject(ManagedObject managedObject) throws JMException {
        this._mbeanServer.unregisterMBean(managedObject.getObjectName());
    }

    private boolean areOutOfTheBoxJMXOptionsSet() {
        if (System.getProperty("com.sun.management.jmxremote") != null) {
            return true;
        }
        return System.getProperty("com.sun.management.jmxremote.port") != null;
    }

    public void close() {
        if (this._cs != null) {
            try {
                CurrentActor.get().message(ManagementConsoleMessages.SHUTTING_DOWN("JMX RMIConnectorServer", this._cs.getAddress().getPort()));
                this._cs.stop();
            }
            catch (IOException e) {
                _log.error((Object)("Exception while closing the JMX ConnectorServer: " + e.getMessage()));
            }
        }
        if (this._rmiRegistry != null) {
            CurrentActor.get().message(ManagementConsoleMessages.SHUTTING_DOWN("RMI Registry", this._jmxPortRegistryServer));
            try {
                UnicastRemoteObject.unexportObject(this._rmiRegistry, false);
            }
            catch (NoSuchObjectException e) {
                _log.error((Object)("Exception while closing the RMI Registry: " + e.getMessage()));
            }
        }
        ObjectName mbeanNameQuery = null;
        try {
            mbeanNameQuery = new ObjectName("org.apache.qpid:*");
        }
        catch (Exception e1) {
            _log.warn((Object)"Unable to generate MBean ObjectName query for close operation");
        }
        for (ObjectName name : this._mbeanServer.queryNames(mbeanNameQuery, null)) {
            try {
                this._mbeanServer.unregisterMBean(name);
            }
            catch (JMException e) {
                _log.error((Object)("Exception unregistering MBean '" + name + "': " + e.getMessage()));
            }
        }
        CurrentActor.get().message(ManagementConsoleMessages.STOPPED());
    }

    private static class CustomRMIServerSocketFactory
    implements RMIServerSocketFactory {
        private CustomRMIServerSocketFactory() {
        }

        public ServerSocket createServerSocket(int port) throws IOException {
            return new NoLocalAddressServerSocket(port);
        }

        private static class NoLocalAddressSocket
        extends Socket {
            private NoLocalAddressSocket() {
            }

            public InetAddress getInetAddress() {
                return null;
            }
        }

        private static class NoLocalAddressServerSocket
        extends ServerSocket {
            NoLocalAddressServerSocket(int port) throws IOException {
                super(port);
            }

            public Socket accept() throws IOException {
                NoLocalAddressSocket s = new NoLocalAddressSocket();
                super.implAccept(s);
                return s;
            }
        }
    }
}

