/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.store.StoredMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerMessageImpl
implements ServerMessage {
    private final AtomicInteger _referenceCount = new AtomicInteger(0);
    private final StoredMessage<?> _handle;

    public AbstractServerMessageImpl(StoredMessage<?> handle) {
        this._handle = handle;
    }

    public boolean incrementReference() {
        return this.incrementReference(1);
    }

    public boolean incrementReference(int count) {
        if (this._referenceCount.addAndGet(count) <= 0) {
            this._referenceCount.addAndGet(-count);
            return false;
        }
        return true;
    }

    public void decrementReference() {
        int count = this._referenceCount.decrementAndGet();
        if (count == 0) {
            this._referenceCount.set(-1073741824);
            if (this._handle != null) {
                this._handle.remove();
            }
        } else if (count < 0) {
            throw new RuntimeException("Reference count for message id " + this.debugIdentity() + " has gone below 0.");
        }
    }

    public String debugIdentity() {
        return "(HC:" + System.identityHashCode(this) + " ID:" + this.getMessageNumber() + " Ref:" + this.getReferenceCount() + ")";
    }

    protected int getReferenceCount() {
        return this._referenceCount.get();
    }
}

