/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import org.apache.qpid.server.configuration.SessionConfig;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.AbstractServerMessageImpl;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.message.MessageMetaData_0_10;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.TransferMessageReference;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.transport.ServerSession;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageTransferMessage
extends AbstractServerMessageImpl
implements InboundMessage {
    private StoredMessage<MessageMetaData_0_10> _storeMessage;
    private WeakReference<Session> _sessionRef;

    public MessageTransferMessage(StoredMessage<MessageMetaData_0_10> storeMessage, WeakReference<Session> sessionRef) {
        super(storeMessage);
        this._storeMessage = storeMessage;
        this._sessionRef = sessionRef;
    }

    private MessageMetaData_0_10 getMetaData() {
        return this._storeMessage.getMetaData();
    }

    @Override
    public String getRoutingKey() {
        return this.getMetaData().getRoutingKey();
    }

    @Override
    public AMQMessageHeader getMessageHeader() {
        return this.getMetaData().getMessageHeader();
    }

    @Override
    public boolean isPersistent() {
        return this.getMetaData().isPersistent();
    }

    @Override
    public boolean isRedelivered() {
        return false;
    }

    @Override
    public long getSize() {
        return this.getMetaData().getSize();
    }

    @Override
    public boolean isImmediate() {
        return this.getMetaData().isImmediate();
    }

    @Override
    public long getExpiration() {
        return this.getMetaData().getExpiration();
    }

    @Override
    public MessageReference newReference() {
        return new TransferMessageReference(this);
    }

    @Override
    public Long getMessageNumber() {
        return this._storeMessage.getMessageNumber();
    }

    @Override
    public long getArrivalTime() {
        return this.getMetaData().getArrivalTime();
    }

    @Override
    public int getContent(ByteBuffer buf, int offset) {
        return this._storeMessage.getContent(offset, buf);
    }

    public Header getHeader() {
        return this.getMetaData().getHeader();
    }

    public ByteBuffer getBody() {
        ByteBuffer body = this.getMetaData().getBody();
        if (body == null && this.getSize() != 0L) {
            int size = (int)this.getSize();
            body = ByteBuffer.allocate(size);
            for (int pos = 0; pos < size; pos += this.getContent(body, pos)) {
            }
            body.flip();
            this.getMetaData().setBody(body.duplicate());
        }
        return body;
    }

    public Session getSession() {
        return this._sessionRef == null ? null : (Session)this._sessionRef.get();
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this._sessionRef == null ? null : (ServerSession)this._sessionRef.get();
    }
}

