/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.output.amqp0_9;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.BasicGetOkBody;
import org.apache.qpid.framing.BasicReturnBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.ContentHeaderProperties;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.server.message.AMQMessage;
import org.apache.qpid.server.message.AbstractServerMessageImpl;
import org.apache.qpid.server.message.MessageContentSource;
import org.apache.qpid.server.message.MessageTransferMessage;
import org.apache.qpid.server.output.HeaderPropertiesConverter;
import org.apache.qpid.server.output.ProtocolOutputConverter;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.transport.DeliveryProperties;

public class ProtocolOutputConverterImpl
implements ProtocolOutputConverter {
    private static final MethodRegistry METHOD_REGISTRY = MethodRegistry.getMethodRegistry((ProtocolVersion)ProtocolVersion.v0_9);
    private final AMQProtocolSession _protocolSession;

    public static ProtocolOutputConverter.Factory getInstanceFactory() {
        return new ProtocolOutputConverter.Factory(){

            public ProtocolOutputConverter newInstance(AMQProtocolSession session) {
                return new ProtocolOutputConverterImpl(session);
            }
        };
    }

    private ProtocolOutputConverterImpl(AMQProtocolSession session) {
        this._protocolSession = session;
    }

    public AMQProtocolSession getProtocolSession() {
        return this._protocolSession;
    }

    public void writeDeliver(QueueEntry entry, int channelId, long deliveryTag, AMQShortString consumerTag) throws AMQException {
        AMQBody deliverBody = this.createEncodedDeliverBody(entry, deliveryTag, consumerTag);
        this.writeMessageDelivery(entry, channelId, deliverBody);
    }

    private ContentHeaderBody getContentHeaderBody(QueueEntry entry) throws AMQException {
        if (entry.getMessage() instanceof AMQMessage) {
            return ((AMQMessage)entry.getMessage()).getContentHeaderBody();
        }
        MessageTransferMessage message = (MessageTransferMessage)entry.getMessage();
        BasicContentHeaderProperties props = HeaderPropertiesConverter.convert(message);
        ContentHeaderBody chb = new ContentHeaderBody((ContentHeaderProperties)props, 60);
        chb.bodySize = message.getSize();
        return chb;
    }

    private void writeMessageDelivery(QueueEntry entry, int channelId, AMQBody deliverBody) throws AMQException {
        this.writeMessageDelivery(entry.getMessage(), this.getContentHeaderBody(entry), channelId, deliverBody);
    }

    private void writeMessageDelivery(MessageContentSource message, ContentHeaderBody contentHeaderBody, int channelId, AMQBody deliverBody) throws AMQException {
        int bodySize = (int)message.getSize();
        if (bodySize == 0) {
            SmallCompositeAMQBodyBlock compositeBlock = new SmallCompositeAMQBodyBlock(channelId, deliverBody, (AMQBody)contentHeaderBody);
            this.writeFrame(compositeBlock);
        } else {
            int capacity;
            MessageContentSourceBody firstContentBody = new MessageContentSourceBody(message, 0, capacity);
            CompositeAMQBodyBlock compositeBlock = new CompositeAMQBodyBlock(channelId, deliverBody, (AMQBody)contentHeaderBody, firstContentBody);
            this.writeFrame(compositeBlock);
            for (int writtenSize = capacity = bodySize > (maxBodySize = (int)this.getProtocolSession().getMaxFrameSize() - AMQFrame.getFrameOverhead()) ? maxBodySize : bodySize; writtenSize < bodySize; writtenSize += capacity) {
                int maxBodySize;
                capacity = bodySize - writtenSize > maxBodySize ? maxBodySize : bodySize - writtenSize;
                MessageContentSourceBody body = new MessageContentSourceBody(message, writtenSize, capacity);
                this.writeFrame((AMQDataBlock)new AMQFrame(channelId, (AMQBody)body));
            }
        }
    }

    private AMQDataBlock createContentHeaderBlock(int channelId, ContentHeaderBody contentHeaderBody) {
        AMQFrame contentHeader = ContentHeaderBody.createAMQFrame((int)channelId, (ContentHeaderBody)contentHeaderBody);
        return contentHeader;
    }

    public void writeGetOk(QueueEntry entry, int channelId, long deliveryTag, int queueSize) throws AMQException {
        AMQBody deliver = this.createEncodedGetOkBody(entry, deliveryTag, queueSize);
        this.writeMessageDelivery(entry, channelId, deliver);
    }

    private AMQBody createEncodedDeliverBody(QueueEntry entry, final long deliveryTag, final AMQShortString consumerTag) throws AMQException {
        AMQShortString routingKey;
        AMQShortString exchangeName;
        AbstractServerMessageImpl message;
        if (entry.getMessage() instanceof AMQMessage) {
            message = (AMQMessage)entry.getMessage();
            MessagePublishInfo pb = ((AMQMessage)message).getMessagePublishInfo();
            exchangeName = pb.getExchange();
            routingKey = pb.getRoutingKey();
        } else {
            message = (MessageTransferMessage)entry.getMessage();
            DeliveryProperties delvProps = (DeliveryProperties)((MessageTransferMessage)message).getHeader().get(DeliveryProperties.class);
            exchangeName = delvProps == null || delvProps.getExchange() == null ? null : new AMQShortString(delvProps.getExchange());
            routingKey = delvProps == null || delvProps.getRoutingKey() == null ? null : new AMQShortString(delvProps.getRoutingKey());
        }
        final boolean isRedelivered = entry.isRedelivered();
        AMQBody returnBlock = new AMQBody(){
            public AMQBody _underlyingBody;

            public AMQBody createAMQBody() {
                return METHOD_REGISTRY.createBasicDeliverBody(consumerTag, deliveryTag, isRedelivered, exchangeName, routingKey);
            }

            public byte getFrameType() {
                return 1;
            }

            public int getSize() {
                if (this._underlyingBody == null) {
                    this._underlyingBody = this.createAMQBody();
                }
                return this._underlyingBody.getSize();
            }

            public void writePayload(DataOutputStream buffer) throws IOException {
                if (this._underlyingBody == null) {
                    this._underlyingBody = this.createAMQBody();
                }
                this._underlyingBody.writePayload(buffer);
            }

            public void handle(int channelId, AMQVersionAwareProtocolSession amqMinaProtocolSession) throws AMQException {
                throw new AMQException("This block should never be dispatched!");
            }
        };
        return returnBlock;
    }

    private AMQBody createEncodedGetOkBody(QueueEntry entry, long deliveryTag, int queueSize) throws AMQException {
        AMQShortString routingKey;
        AMQShortString exchangeName;
        AbstractServerMessageImpl message;
        if (entry.getMessage() instanceof AMQMessage) {
            message = (AMQMessage)entry.getMessage();
            MessagePublishInfo pb = ((AMQMessage)message).getMessagePublishInfo();
            exchangeName = pb.getExchange();
            routingKey = pb.getRoutingKey();
        } else {
            message = (MessageTransferMessage)entry.getMessage();
            DeliveryProperties delvProps = (DeliveryProperties)((MessageTransferMessage)message).getHeader().get(DeliveryProperties.class);
            exchangeName = delvProps == null || delvProps.getExchange() == null ? null : new AMQShortString(delvProps.getExchange());
            routingKey = delvProps == null || delvProps.getRoutingKey() == null ? null : new AMQShortString(delvProps.getRoutingKey());
        }
        boolean isRedelivered = entry.isRedelivered();
        BasicGetOkBody getOkBody = METHOD_REGISTRY.createBasicGetOkBody(deliveryTag, isRedelivered, exchangeName, routingKey, (long)queueSize);
        return getOkBody;
    }

    public byte getProtocolMinorVersion() {
        return this.getProtocolSession().getProtocolMinorVersion();
    }

    public byte getProtocolMajorVersion() {
        return this.getProtocolSession().getProtocolMajorVersion();
    }

    private AMQBody createEncodedReturnFrame(MessagePublishInfo messagePublishInfo, int replyCode, AMQShortString replyText) throws AMQException {
        BasicReturnBody basicReturnBody = METHOD_REGISTRY.createBasicReturnBody(replyCode, replyText, messagePublishInfo.getExchange(), messagePublishInfo.getRoutingKey());
        return basicReturnBody;
    }

    public void writeReturn(MessagePublishInfo messagePublishInfo, ContentHeaderBody header, MessageContentSource message, int channelId, int replyCode, AMQShortString replyText) throws AMQException {
        AMQBody returnFrame = this.createEncodedReturnFrame(messagePublishInfo, replyCode, replyText);
        this.writeMessageDelivery(message, header, channelId, returnFrame);
    }

    public void writeFrame(AMQDataBlock block) {
        this.getProtocolSession().writeFrame(block);
    }

    public void confirmConsumerAutoClose(int channelId, AMQShortString consumerTag) {
        BasicCancelOkBody basicCancelOkBody = METHOD_REGISTRY.createBasicCancelOkBody(consumerTag);
        this.writeFrame((AMQDataBlock)basicCancelOkBody.generateFrame(channelId));
    }

    public static final class SmallCompositeAMQBodyBlock
    extends AMQDataBlock {
        public static final int OVERHEAD = 2 * AMQFrame.getFrameOverhead();
        private final AMQBody _methodBody;
        private final AMQBody _headerBody;
        private final int _channel;

        public SmallCompositeAMQBodyBlock(int channel, AMQBody methodBody, AMQBody headerBody) {
            this._channel = channel;
            this._methodBody = methodBody;
            this._headerBody = headerBody;
        }

        public long getSize() {
            return OVERHEAD + this._methodBody.getSize() + this._headerBody.getSize();
        }

        public void writePayload(DataOutputStream buffer) throws IOException {
            AMQFrame.writeFrames((DataOutputStream)buffer, (int)this._channel, (AMQBody)this._methodBody, (AMQBody)this._headerBody);
        }
    }

    public static final class CompositeAMQBodyBlock
    extends AMQDataBlock {
        public static final int OVERHEAD = 3 * AMQFrame.getFrameOverhead();
        private final AMQBody _methodBody;
        private final AMQBody _headerBody;
        private final AMQBody _contentBody;
        private final int _channel;

        public CompositeAMQBodyBlock(int channel, AMQBody methodBody, AMQBody headerBody, AMQBody contentBody) {
            this._channel = channel;
            this._methodBody = methodBody;
            this._headerBody = headerBody;
            this._contentBody = contentBody;
        }

        public long getSize() {
            return OVERHEAD + this._methodBody.getSize() + this._headerBody.getSize() + this._contentBody.getSize();
        }

        public void writePayload(DataOutputStream buffer) throws IOException {
            AMQFrame.writeFrames((DataOutputStream)buffer, (int)this._channel, (AMQBody)this._methodBody, (AMQBody)this._headerBody, (AMQBody)this._contentBody);
        }
    }

    private class MessageContentSourceBody
    implements AMQBody {
        public static final byte TYPE = 3;
        private int _length;
        private MessageContentSource _message;
        private int _offset;

        public MessageContentSourceBody(MessageContentSource message, int offset, int length) {
            this._message = message;
            this._offset = offset;
            this._length = length;
        }

        public byte getFrameType() {
            return 3;
        }

        public int getSize() {
            return this._length;
        }

        public void writePayload(DataOutputStream buffer) throws IOException {
            byte[] data = new byte[this._length];
            this._message.getContent(ByteBuffer.wrap(data), this._offset);
            buffer.write(data);
        }

        public void handle(int channelId, AMQVersionAwareProtocolSession amqProtocolSession) throws AMQException {
            throw new UnsupportedOperationException();
        }
    }
}

