/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.main.AutoProcessor;
import org.apache.log4j.Logger;
import org.apache.qpid.common.Closeable;
import org.apache.qpid.common.QpidProperties;
import org.apache.qpid.server.configuration.TopicConfiguration;
import org.apache.qpid.server.configuration.plugins.ConfigurationPluginFactory;
import org.apache.qpid.server.configuration.plugins.SlowConsumerDetectionConfiguration;
import org.apache.qpid.server.configuration.plugins.SlowConsumerDetectionPolicyConfiguration;
import org.apache.qpid.server.configuration.plugins.SlowConsumerDetectionQueueConfiguration;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.plugins.Activator;
import org.apache.qpid.server.plugins.OsgiSystemPackageUtil;
import org.apache.qpid.server.plugins.Plugin;
import org.apache.qpid.server.plugins.PluginFactory;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.SecurityPluginFactory;
import org.apache.qpid.server.security.access.plugins.AllowAll;
import org.apache.qpid.server.security.access.plugins.DenyAll;
import org.apache.qpid.server.security.access.plugins.LegacyAccess;
import org.apache.qpid.server.security.auth.manager.AuthenticationManagerPluginFactory;
import org.apache.qpid.server.security.auth.manager.PrincipalDatabaseAuthenticationManager;
import org.apache.qpid.server.virtualhost.plugins.SlowConsumerDetection;
import org.apache.qpid.server.virtualhost.plugins.VirtualHostPluginFactory;
import org.apache.qpid.server.virtualhost.plugins.policies.TopicDeletePolicy;
import org.apache.qpid.slowconsumerdetection.policies.SlowConsumerPolicyPluginFactory;
import org.apache.qpid.util.FileUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager
implements Closeable {
    private static final Logger _logger = Logger.getLogger(PluginManager.class);
    private static final int FELIX_STOP_TIMEOUT = 30000;
    private Framework _felix;
    private ServiceTracker _exchangeTracker = null;
    private ServiceTracker _securityTracker = null;
    private ServiceTracker _configTracker = null;
    private ServiceTracker _virtualHostTracker = null;
    private ServiceTracker _policyTracker = null;
    private ServiceTracker _authenticationManagerTracker = null;
    private Activator _activator;
    private final List<ServiceTracker> _trackers = new ArrayList<ServiceTracker>();
    private Map<String, SecurityPluginFactory> _securityPlugins = new HashMap<String, SecurityPluginFactory>();
    private Map<List<String>, ConfigurationPluginFactory> _configPlugins = new IdentityHashMap<List<String>, ConfigurationPluginFactory>();
    private Map<String, VirtualHostPluginFactory> _vhostPlugins = new HashMap<String, VirtualHostPluginFactory>();
    private Map<String, SlowConsumerPolicyPluginFactory> _policyPlugins = new HashMap<String, SlowConsumerPolicyPluginFactory>();
    private Map<String, AuthenticationManagerPluginFactory<? extends Plugin>> _authenticationManagerPlugins = new HashMap<String, AuthenticationManagerPluginFactory<? extends Plugin>>();
    private static final String DEFAULT_RESOURCE_NAME = "org/apache/qpid/server/plugins/OsgiSystemPackages.properties";
    private static final String FILE_PROPERTY = "qpid.osgisystempackages.properties";
    private static final String OSGI_SYSTEM_PACKAGES;

    public PluginManager(String pluginPath, String cachePath, BundleContext bundleContext) throws Exception {
        for (SecurityPluginFactory securityPluginFactory : Arrays.asList(AllowAll.FACTORY, DenyAll.FACTORY, LegacyAccess.FACTORY)) {
            this._securityPlugins.put(securityPluginFactory.getPluginName(), securityPluginFactory);
        }
        for (ConfigurationPluginFactory configurationPluginFactory : Arrays.asList(TopicConfiguration.FACTORY, SecurityManager.SecurityConfiguration.FACTORY, AllowAll.AllowAllConfiguration.FACTORY, DenyAll.DenyAllConfiguration.FACTORY, LegacyAccess.LegacyAccessConfiguration.FACTORY, new SlowConsumerDetectionConfiguration.SlowConsumerDetectionConfigurationFactory(), new SlowConsumerDetectionPolicyConfiguration.SlowConsumerDetectionPolicyConfigurationFactory(), new SlowConsumerDetectionQueueConfiguration.SlowConsumerDetectionQueueConfigurationFactory(), PrincipalDatabaseAuthenticationManager.PrincipalDatabaseAuthenticationManagerConfiguration.FACTORY)) {
            this._configPlugins.put(configurationPluginFactory.getParentPaths(), configurationPluginFactory);
        }
        for (TopicDeletePolicy.TopicDeletePolicyFactory topicDeletePolicyFactory : Arrays.asList(new TopicDeletePolicy.TopicDeletePolicyFactory())) {
            this._policyPlugins.put(topicDeletePolicyFactory.getPluginName(), topicDeletePolicyFactory);
        }
        for (SlowConsumerDetection.SlowConsumerFactory slowConsumerFactory : Arrays.asList(new SlowConsumerDetection.SlowConsumerFactory())) {
            this._vhostPlugins.put(slowConsumerFactory.getClass().getName(), slowConsumerFactory);
        }
        for (AuthenticationManagerPluginFactory authenticationManagerPluginFactory : Arrays.asList(PrincipalDatabaseAuthenticationManager.FACTORY)) {
            this._authenticationManagerPlugins.put(authenticationManagerPluginFactory.getPluginName(), authenticationManagerPluginFactory);
        }
        if (bundleContext == null) {
            if (pluginPath == null) {
                _logger.info((Object)"No plugin path specified, no plugins will be loaded.");
                return;
            }
            File pluginDir = new File(pluginPath);
            if (!pluginDir.exists()) {
                _logger.warn((Object)("Plugin dir : " + pluginDir + " does not exist."));
                return;
            }
            StringMap stringMap = new StringMap(false);
            stringMap.put((Object)"org.osgi.framework.system.packages", (Object)OSGI_SYSTEM_PACKAGES);
            stringMap.put((Object)"felix.shutdown.hook", (Object)"false");
            ArrayList<Activator> activators = new ArrayList<Activator>();
            this._activator = new Activator();
            activators.add(this._activator);
            stringMap.put((Object)"felix.systembundle.activators", activators);
            if (cachePath != null) {
                File cacheDir = new File(cachePath);
                if (!cacheDir.exists() && cacheDir.canWrite()) {
                    _logger.info((Object)("Creating plugin cache directory: " + cachePath));
                    cacheDir.mkdir();
                }
                _logger.info((Object)("Cache bundles in directory " + cachePath));
                stringMap.put((Object)"org.osgi.framework.storage", (Object)cachePath);
            }
            stringMap.put((Object)"org.osgi.framework.storage.clean", (Object)"onFirstInit");
            _logger.info((Object)("Auto deploying bundles from directory " + pluginPath));
            stringMap.put((Object)"felix.auto.deploy.dir", (Object)pluginPath);
            stringMap.put((Object)"felix.auto.deploy.action", (Object)"install,start");
            this._felix = new Felix((Map)stringMap);
            try {
                _logger.info((Object)"Starting plugin manager framework");
                this._felix.init();
                AutoProcessor.process((Map)stringMap, (BundleContext)this._felix.getBundleContext());
                this._felix.start();
                _logger.info((Object)"Started plugin manager framework");
            }
            catch (BundleException e) {
                throw new ConfigurationException("Could not start plugin manager: " + e.getMessage(), (Throwable)e);
            }
            bundleContext = this._activator.getContext();
        } else {
            _logger.info((Object)"Using the specified external BundleContext");
        }
        this._exchangeTracker = new ServiceTracker(bundleContext, ExchangeType.class.getName(), null);
        this._exchangeTracker.open();
        this._trackers.add(this._exchangeTracker);
        this._securityTracker = new ServiceTracker(bundleContext, SecurityPluginFactory.class.getName(), null);
        this._securityTracker.open();
        this._trackers.add(this._securityTracker);
        this._configTracker = new ServiceTracker(bundleContext, ConfigurationPluginFactory.class.getName(), null);
        this._configTracker.open();
        this._trackers.add(this._configTracker);
        this._virtualHostTracker = new ServiceTracker(bundleContext, VirtualHostPluginFactory.class.getName(), null);
        this._virtualHostTracker.open();
        this._trackers.add(this._virtualHostTracker);
        this._policyTracker = new ServiceTracker(bundleContext, SlowConsumerPolicyPluginFactory.class.getName(), null);
        this._policyTracker.open();
        this._trackers.add(this._policyTracker);
        this._authenticationManagerTracker = new ServiceTracker(bundleContext, AuthenticationManagerPluginFactory.class.getName(), null);
        this._authenticationManagerTracker.open();
        this._trackers.add(this._authenticationManagerTracker);
        _logger.info((Object)"Opened service trackers");
    }

    private static <T> Map<String, T> getServices(ServiceTracker tracker) {
        HashMap<String, Object> services = new HashMap<String, Object>();
        if (tracker != null && tracker.getServices() != null) {
            for (Object service : tracker.getServices()) {
                if (service instanceof PluginFactory) {
                    services.put(((PluginFactory)service).getPluginName(), service);
                    continue;
                }
                services.put(service.getClass().getName(), service);
            }
        }
        return services;
    }

    public static <T> Map<String, T> getServices(ServiceTracker tracker, Map<String, T> plugins) {
        Map<String, T> services = PluginManager.getServices(tracker);
        services.putAll(plugins);
        return services;
    }

    public Map<List<String>, ConfigurationPluginFactory> getConfigurationPlugins() {
        IdentityHashMap<List<String>, ConfigurationPluginFactory> services = new IdentityHashMap<List<String>, ConfigurationPluginFactory>();
        if (this._configTracker != null && this._configTracker.getServices() != null) {
            for (Object service : this._configTracker.getServices()) {
                ConfigurationPluginFactory factory = (ConfigurationPluginFactory)service;
                services.put(factory.getParentPaths(), factory);
            }
        }
        services.putAll(this._configPlugins);
        return services;
    }

    public Map<String, VirtualHostPluginFactory> getVirtualHostPlugins() {
        return PluginManager.getServices(this._virtualHostTracker, this._vhostPlugins);
    }

    public Map<String, SlowConsumerPolicyPluginFactory> getSlowConsumerPlugins() {
        return PluginManager.getServices(this._policyTracker, this._policyPlugins);
    }

    public Map<String, ExchangeType<?>> getExchanges() {
        return PluginManager.getServices(this._exchangeTracker);
    }

    public Map<String, SecurityPluginFactory> getSecurityPlugins() {
        return PluginManager.getServices(this._securityTracker, this._securityPlugins);
    }

    public Map<String, AuthenticationManagerPluginFactory<? extends Plugin>> getAuthenticationManagerPlugins() {
        return PluginManager.getServices(this._authenticationManagerTracker, this._authenticationManagerPlugins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            for (ServiceTracker tracker : this._trackers) {
                tracker.close();
            }
        }
        finally {
            if (this._felix != null) {
                _logger.info((Object)"Stopping plugin manager framework");
                try {
                    this._felix.stop();
                }
                catch (BundleException e) {}
                try {
                    this._felix.waitForStop(30000L);
                }
                catch (InterruptedException interruptedException) {}
                _logger.info((Object)"Stopped plugin manager framework");
            } else {
                _logger.info((Object)"Plugin manager was started with an external BundleContext, skipping remaining shutdown tasks");
            }
        }
    }

    static {
        String filename = System.getProperty(FILE_PROPERTY);
        InputStream is = FileUtils.openFileOrDefaultResource((String)filename, (String)DEFAULT_RESOURCE_NAME, (ClassLoader)PluginManager.class.getClassLoader());
        try {
            Version qpidReleaseVersion;
            try {
                qpidReleaseVersion = Version.parseVersion((String)QpidProperties.getReleaseVersion());
            }
            catch (IllegalArgumentException iae) {
                qpidReleaseVersion = null;
            }
            Properties p = new Properties();
            p.load(is);
            OsgiSystemPackageUtil osgiSystemPackageUtil = new OsgiSystemPackageUtil(qpidReleaseVersion, p);
            OSGI_SYSTEM_PACKAGES = osgiSystemPackageUtil.getFormattedSystemPackageString();
            _logger.debug((Object)("List of OSGi system packages to be added: " + OSGI_SYSTEM_PACKAGES));
        }
        catch (IOException e) {
            _logger.error((Object)"Error reading OSGI system package list", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
    }
}

