/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.protocol.ProtocolEngineFactory;
import org.apache.qpid.protocol.ServerProtocolEngine;
import org.apache.qpid.server.protocol.AmqpProtocolVersion;
import org.apache.qpid.server.protocol.MultiVersionProtocolEngine;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.transport.network.NetworkConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiVersionProtocolEngineFactory
implements ProtocolEngineFactory {
    private static final AtomicLong ID_GENERATOR = new AtomicLong(0L);
    private final IApplicationRegistry _appRegistry = ApplicationRegistry.getInstance();
    private final String _fqdn;
    private final Set<AmqpProtocolVersion> _supported;

    public MultiVersionProtocolEngineFactory(String fqdn, Set<AmqpProtocolVersion> supportedVersions) {
        this._fqdn = fqdn;
        this._supported = supportedVersions;
    }

    public ServerProtocolEngine newProtocolEngine(NetworkConnection network) {
        return new MultiVersionProtocolEngine(this._appRegistry, this._fqdn, this._supported, network, ID_GENERATOR.getAndIncrement());
    }

    public ServerProtocolEngine newProtocolEngine() {
        return new MultiVersionProtocolEngine(this._appRegistry, this._fqdn, this._supported, ID_GENERATOR.getAndIncrement());
    }
}

