/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.registry;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.common.Closeable;
import org.apache.qpid.common.QpidProperties;
import org.apache.qpid.qmf.QMFService;
import org.apache.qpid.server.configuration.BrokerConfig;
import org.apache.qpid.server.configuration.ConfigStore;
import org.apache.qpid.server.configuration.ConfigurationManager;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.configuration.SystemConfig;
import org.apache.qpid.server.configuration.SystemConfigImpl;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.logging.CompositeStartupMessageLogger;
import org.apache.qpid.server.logging.Log4jMessageLogger;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.logging.SystemOutMessageLogger;
import org.apache.qpid.server.logging.actors.AbstractActor;
import org.apache.qpid.server.logging.actors.BrokerActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.logging.messages.VirtualHostMessages;
import org.apache.qpid.server.management.ManagedObjectRegistry;
import org.apache.qpid.server.management.NoopManagedObjectRegistry;
import org.apache.qpid.server.plugins.Plugin;
import org.apache.qpid.server.plugins.PluginManager;
import org.apache.qpid.server.registry.BrokerConfigAdapter;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationManagerPluginFactory;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.transport.QpidAcceptor;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;
import org.osgi.framework.BundleContext;

public abstract class ApplicationRegistry
implements IApplicationRegistry {
    protected static final Logger _logger = Logger.getLogger(ApplicationRegistry.class);
    private static AtomicReference<IApplicationRegistry> _instance = new AtomicReference<Object>(null);
    protected final ServerConfiguration _configuration;
    protected final Map<InetSocketAddress, QpidAcceptor> _acceptors = new HashMap<InetSocketAddress, QpidAcceptor>();
    protected ManagedObjectRegistry _managedObjectRegistry;
    protected AuthenticationManager _authenticationManager;
    protected VirtualHostRegistry _virtualHostRegistry;
    protected SecurityManager _securityManager;
    protected PluginManager _pluginManager;
    protected ConfigurationManager _configurationManager;
    protected RootMessageLogger _rootMessageLogger;
    protected CompositeStartupMessageLogger _startupMessageLogger;
    protected UUID _brokerId = UUID.randomUUID();
    protected QMFService _qmfService;
    private BrokerConfig _broker;
    private ConfigStore _configStore;
    private Timer _reportingTimer;
    private boolean _statisticsEnabled = false;
    private StatisticsCounter _messagesDelivered;
    private StatisticsCounter _dataDelivered;
    private StatisticsCounter _messagesReceived;
    private StatisticsCounter _dataReceived;
    private BundleContext _bundleContext;

    public static void initialise(IApplicationRegistry instance) throws Exception {
        if (instance == null) {
            throw new IllegalArgumentException("ApplicationRegistry instance must not be null");
        }
        if (!_instance.compareAndSet(null, instance)) {
            throw new IllegalStateException("An ApplicationRegistry is already initialised");
        }
        _logger.info((Object)("Initialising Application Registry(" + instance + ")"));
        ConfigStore store = ConfigStore.newInstance();
        store.setRoot(new SystemConfigImpl(store));
        instance.setConfigStore(store);
        BrokerConfigAdapter broker = new BrokerConfigAdapter(instance);
        SystemConfig system = store.getRoot();
        system.addBroker(broker);
        instance.setBroker(broker);
        try {
            instance.initialise();
        }
        catch (Exception e) {
            _instance.set(null);
            try {
                system.removeBroker(broker);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
    }

    public ConfigStore getConfigStore() {
        return this._configStore;
    }

    public void setConfigStore(ConfigStore configStore) {
        this._configStore = configStore;
    }

    public static boolean isConfigured() {
        return _instance.get() != null;
    }

    public static void remove() {
        IApplicationRegistry instance = _instance.getAndSet(null);
        try {
            if (instance != null) {
                if (_logger.isInfoEnabled()) {
                    _logger.info((Object)("Shutting down ApplicationRegistry(" + instance + ")"));
                }
                instance.close();
                instance.getBroker().getSystem().removeBroker(instance.getBroker());
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error shutting down Application Registry(" + instance + "): " + e), (Throwable)e);
        }
    }

    protected ApplicationRegistry(ServerConfiguration configuration) {
        this(configuration, null);
    }

    protected ApplicationRegistry(ServerConfiguration configuration, BundleContext bundleContext) {
        this._configuration = configuration;
        this._bundleContext = bundleContext;
    }

    public void configure() throws ConfigurationException {
        this._configurationManager = new ConfigurationManager();
        try {
            this._pluginManager = new PluginManager(this._configuration.getPluginDirectory(), this._configuration.getCacheDirectory(), this._bundleContext);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        this._configuration.initialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() throws Exception {
        this._rootMessageLogger = new Log4jMessageLogger(this._configuration);
        RootMessageLogger[] messageLoggers = new RootMessageLogger[]{new SystemOutMessageLogger(), this._rootMessageLogger};
        this._startupMessageLogger = new CompositeStartupMessageLogger(messageLoggers);
        CurrentActor.set(new BrokerActor(this._startupMessageLogger));
        try {
            this.configure();
            this._qmfService = new QMFService(this.getConfigStore(), this);
            CurrentActor.get().message(BrokerMessages.STARTUP(QpidProperties.getReleaseVersion(), QpidProperties.getBuildVersion()));
            this.initialiseManagedObjectRegistry();
            this._virtualHostRegistry = new VirtualHostRegistry(this);
            this._securityManager = new SecurityManager(this._configuration, this._pluginManager);
            this._authenticationManager = this.createAuthenticationManager();
            this._managedObjectRegistry.start();
        }
        finally {
            CurrentActor.remove();
        }
        CurrentActor.set(new BrokerActor(this._rootMessageLogger));
        try {
            this.initialiseVirtualHosts();
            this.initialiseStatistics();
            this.initialiseStatisticsReporting();
        }
        finally {
            CurrentActor.remove();
        }
    }

    protected AuthenticationManager createAuthenticationManager() throws ConfigurationException {
        SecurityManager.SecurityConfiguration securityConfiguration = (SecurityManager.SecurityConfiguration)this._configuration.getConfiguration(SecurityManager.SecurityConfiguration.class.getName());
        Collection<AuthenticationManagerPluginFactory<? extends Plugin>> factories = this._pluginManager.getAuthenticationManagerPlugins().values();
        if (factories.size() == 0) {
            throw new ConfigurationException("No authentication manager factory plugins found.  Check the desired authenticationmanager plugin has been placed in the plugins directory.");
        }
        AuthenticationManager authMgr = null;
        for (AuthenticationManagerPluginFactory<? extends Plugin> factory : factories) {
            AuthenticationManager tmp = (AuthenticationManager)factory.newInstance(securityConfiguration);
            if (tmp == null) continue;
            if (authMgr != null) {
                throw new ConfigurationException("Cannot configure more than one authentication manager. Both " + tmp.getClass() + " and " + authMgr.getClass() + " are configured." + " Remove configuration for one of the authentication manager, or remove the plugin JAR" + " from the classpath.");
            }
            authMgr = tmp;
        }
        if (authMgr == null) {
            throw new ConfigurationException("No authentication managers configured within the configure file.");
        }
        return authMgr;
    }

    protected void initialiseVirtualHosts() throws Exception {
        for (String name : this._configuration.getVirtualHosts()) {
            this.createVirtualHost(this._configuration.getVirtualHostConfig(name));
        }
        this.getVirtualHostRegistry().setDefaultVirtualHostName(this._configuration.getDefaultVirtualHost());
    }

    protected void initialiseManagedObjectRegistry() throws AMQException {
        this._managedObjectRegistry = new NoopManagedObjectRegistry();
    }

    public void initialiseStatisticsReporting() {
        long report = this._configuration.getStatisticsReportingPeriod() * 1000L;
        final boolean broker = this._configuration.isStatisticsGenerationBrokerEnabled();
        final boolean virtualhost = this._configuration.isStatisticsGenerationVirtualhostsEnabled();
        final boolean reset = this._configuration.isStatisticsReportResetEnabled();
        if (report > 0L && (broker || virtualhost)) {
            this._reportingTimer = new Timer("Statistics-Reporting", true);
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class StatisticsReportingTask
            extends TimerTask {
                private final int DELIVERED = 0;
                private final int RECEIVED = 1;

                StatisticsReportingTask() {
                }

                @Override
                public void run() {
                    CurrentActor.set(new AbstractActor(ApplicationRegistry.getInstance().getRootMessageLogger()){

                        public String getLogMessage() {
                            return "[" + Thread.currentThread().getName() + "] ";
                        }
                    });
                    if (broker) {
                        CurrentActor.get().message(BrokerMessages.STATS_DATA(0, ApplicationRegistry.this._dataDelivered.getPeak() / 1024.0, ApplicationRegistry.this._dataDelivered.getTotal()));
                        CurrentActor.get().message(BrokerMessages.STATS_MSGS(0, ApplicationRegistry.this._messagesDelivered.getPeak(), ApplicationRegistry.this._messagesDelivered.getTotal()));
                        CurrentActor.get().message(BrokerMessages.STATS_DATA(1, ApplicationRegistry.this._dataReceived.getPeak() / 1024.0, ApplicationRegistry.this._dataReceived.getTotal()));
                        CurrentActor.get().message(BrokerMessages.STATS_MSGS(1, ApplicationRegistry.this._messagesReceived.getPeak(), ApplicationRegistry.this._messagesReceived.getTotal()));
                    }
                    if (virtualhost) {
                        for (VirtualHost vhost : ApplicationRegistry.this.getVirtualHostRegistry().getVirtualHosts()) {
                            String name = vhost.getName();
                            StatisticsCounter dataDelivered = vhost.getDataDeliveryStatistics();
                            StatisticsCounter messagesDelivered = vhost.getMessageDeliveryStatistics();
                            StatisticsCounter dataReceived = vhost.getDataReceiptStatistics();
                            StatisticsCounter messagesReceived = vhost.getMessageReceiptStatistics();
                            CurrentActor.get().message(VirtualHostMessages.STATS_DATA(name, 0, dataDelivered.getPeak() / 1024.0, dataDelivered.getTotal()));
                            CurrentActor.get().message(VirtualHostMessages.STATS_MSGS(name, 0, messagesDelivered.getPeak(), messagesDelivered.getTotal()));
                            CurrentActor.get().message(VirtualHostMessages.STATS_DATA(name, 1, dataReceived.getPeak() / 1024.0, dataReceived.getTotal()));
                            CurrentActor.get().message(VirtualHostMessages.STATS_MSGS(name, 1, messagesReceived.getPeak(), messagesReceived.getTotal()));
                        }
                    }
                    if (reset) {
                        ApplicationRegistry.this.resetStatistics();
                    }
                    CurrentActor.remove();
                }
            }
            this._reportingTimer.scheduleAtFixedRate((TimerTask)new StatisticsReportingTask(), report / 2L, report);
        }
    }

    public static IApplicationRegistry getInstance() throws IllegalStateException {
        IApplicationRegistry iApplicationRegistry = _instance.get();
        if (iApplicationRegistry == null) {
            throw new IllegalStateException("No ApplicationRegistry has been initialised");
        }
        return iApplicationRegistry;
    }

    private void close(Closeable close) {
        try {
            if (close != null) {
                close.close();
            }
        }
        catch (Throwable e) {
            _logger.error((Object)("Error thrown whilst closing " + close.getClass().getSimpleName()), e);
        }
    }

    public void close() {
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Shutting down ApplicationRegistry:" + this));
        }
        if (this._reportingTimer != null) {
            this._reportingTimer.cancel();
        }
        this.unbind();
        this.close(this._virtualHostRegistry);
        this.close(this._authenticationManager);
        this.close(this._managedObjectRegistry);
        this.close(this._qmfService);
        this.close(this._pluginManager);
        CurrentActor.get().message(BrokerMessages.STOPPED());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind() {
        Map<InetSocketAddress, QpidAcceptor> map = this._acceptors;
        synchronized (map) {
            for (InetSocketAddress bindAddress : this._acceptors.keySet()) {
                QpidAcceptor acceptor = this._acceptors.get(bindAddress);
                try {
                    acceptor.getNetworkTransport().close();
                }
                catch (Throwable e) {
                    _logger.error((Object)("Unable to close network driver due to:" + e.getMessage()));
                }
                CurrentActor.get().message(BrokerMessages.SHUTTING_DOWN(acceptor.toString(), bindAddress.getPort()));
            }
        }
    }

    public ServerConfiguration getConfiguration() {
        return this._configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAcceptor(InetSocketAddress bindAddress, QpidAcceptor acceptor) {
        Map<InetSocketAddress, QpidAcceptor> map = this._acceptors;
        synchronized (map) {
            this._acceptors.put(bindAddress, acceptor);
        }
    }

    public VirtualHostRegistry getVirtualHostRegistry() {
        return this._virtualHostRegistry;
    }

    public SecurityManager getSecurityManager() {
        return this._securityManager;
    }

    public ManagedObjectRegistry getManagedObjectRegistry() {
        return this._managedObjectRegistry;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this._authenticationManager;
    }

    public PluginManager getPluginManager() {
        return this._pluginManager;
    }

    public ConfigurationManager getConfigurationManager() {
        return this._configurationManager;
    }

    public RootMessageLogger getRootMessageLogger() {
        return this._rootMessageLogger;
    }

    public RootMessageLogger getCompositeStartupMessageLogger() {
        return this._startupMessageLogger;
    }

    public UUID getBrokerId() {
        return this._brokerId;
    }

    public QMFService getQMFService() {
        return this._qmfService;
    }

    public BrokerConfig getBroker() {
        return this._broker;
    }

    public void setBroker(BrokerConfig broker) {
        this._broker = broker;
    }

    public VirtualHost createVirtualHost(VirtualHostConfiguration vhostConfig) throws Exception {
        VirtualHostImpl virtualHost = new VirtualHostImpl(this, vhostConfig, null);
        this._virtualHostRegistry.registerVirtualHost(virtualHost);
        this.getBroker().addVirtualHost(virtualHost);
        return virtualHost;
    }

    public void registerMessageDelivered(long messageSize) {
        if (this.isStatisticsEnabled()) {
            this._messagesDelivered.registerEvent(1L);
            this._dataDelivered.registerEvent(messageSize);
        }
    }

    public void registerMessageReceived(long messageSize, long timestamp) {
        if (this.isStatisticsEnabled()) {
            this._messagesReceived.registerEvent(1L, timestamp);
            this._dataReceived.registerEvent(messageSize, timestamp);
        }
    }

    public StatisticsCounter getMessageReceiptStatistics() {
        return this._messagesReceived;
    }

    public StatisticsCounter getDataReceiptStatistics() {
        return this._dataReceived;
    }

    public StatisticsCounter getMessageDeliveryStatistics() {
        return this._messagesDelivered;
    }

    public StatisticsCounter getDataDeliveryStatistics() {
        return this._dataDelivered;
    }

    public void resetStatistics() {
        this._messagesDelivered.reset();
        this._dataDelivered.reset();
        this._messagesReceived.reset();
        this._dataReceived.reset();
        for (VirtualHost vhost : this._virtualHostRegistry.getVirtualHosts()) {
            vhost.resetStatistics();
        }
    }

    public void initialiseStatistics() {
        this.setStatisticsEnabled(!StatisticsCounter.DISABLE_STATISTICS && this.getConfiguration().isStatisticsGenerationBrokerEnabled());
        this._messagesDelivered = new StatisticsCounter("messages-delivered");
        this._dataDelivered = new StatisticsCounter("bytes-delivered");
        this._messagesReceived = new StatisticsCounter("messages-received");
        this._dataReceived = new StatisticsCounter("bytes-received");
    }

    public boolean isStatisticsEnabled() {
        return this._statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean enabled) {
        this._statisticsEnabled = enabled;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownService()));
    }

    private static class ShutdownService
    implements Runnable {
        private ShutdownService() {
        }

        public void run() {
            ApplicationRegistry.remove();
        }
    }
}

