/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth;

import javax.security.auth.Subject;

public class AuthenticationResult {
    public final AuthenticationStatus _status;
    public final byte[] _challenge;
    private final Exception _cause;
    private final Subject _subject;

    public AuthenticationResult(AuthenticationStatus status) {
        this(null, status, null);
    }

    public AuthenticationResult(byte[] challenge, AuthenticationStatus status) {
        this(challenge, status, null);
    }

    public AuthenticationResult(AuthenticationStatus error, Exception cause) {
        this(null, error, cause);
    }

    public AuthenticationResult(byte[] challenge, AuthenticationStatus status, Exception cause) {
        this._status = status;
        this._challenge = challenge;
        this._cause = cause;
        this._subject = null;
    }

    public AuthenticationResult(Subject subject) {
        this._status = AuthenticationStatus.SUCCESS;
        this._challenge = null;
        this._cause = null;
        this._subject = subject;
    }

    public Exception getCause() {
        return this._cause;
    }

    public AuthenticationStatus getStatus() {
        return this._status;
    }

    public byte[] getChallenge() {
        return this._challenge;
    }

    public Subject getSubject() {
        return this._subject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthenticationStatus {
        SUCCESS,
        CONTINUE,
        ERROR;

    }
}

