/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.state;

import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.framing.ChannelOpenBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.protocol.AMQMethodEvent;
import org.apache.qpid.protocol.AMQMethodListener;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.state.AMQState;
import org.apache.qpid.server.state.StateListener;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQStateManager
implements AMQMethodListener {
    private static final Logger _logger = Logger.getLogger(AMQStateManager.class);
    private final VirtualHostRegistry _virtualHostRegistry;
    private final AMQProtocolSession _protocolSession;
    private AMQState _currentState;
    private CopyOnWriteArraySet<StateListener> _stateListeners = new CopyOnWriteArraySet();

    public AMQStateManager(VirtualHostRegistry virtualHostRegistry, AMQProtocolSession protocolSession) {
        this._virtualHostRegistry = virtualHostRegistry;
        this._protocolSession = protocolSession;
        this._currentState = AMQState.CONNECTION_NOT_STARTED;
    }

    public AMQState getCurrentState() {
        return this._currentState;
    }

    public void changeState(AMQState newState) throws AMQException {
        _logger.debug((Object)("State changing to " + (Object)((Object)newState) + " from old state " + (Object)((Object)this._currentState)));
        AMQState oldState = this._currentState;
        this._currentState = newState;
        for (StateListener l : this._stateListeners) {
            l.stateChanged(oldState, newState);
        }
    }

    public void error(Exception e) {
        _logger.error((Object)("State manager received error notification[Current State:" + (Object)((Object)this._currentState) + "]: " + e), (Throwable)e);
        for (StateListener l : this._stateListeners) {
            l.error(e);
        }
    }

    public <B extends AMQMethodBody> boolean methodReceived(AMQMethodEvent<B> evt) throws AMQException {
        MethodDispatcher dispatcher = this._protocolSession.getMethodDispatcher();
        int channelId = evt.getChannelId();
        AMQMethodBody body = evt.getMethod();
        if (!(channelId == 0 || this._protocolSession.getChannel(channelId) != null || body instanceof ChannelOpenBody || body instanceof ChannelCloseOkBody || body instanceof ChannelCloseBody)) {
            throw body.getConnectionException(AMQConstant.CHANNEL_ERROR, "channel is closed won't process:" + body);
        }
        return body.execute(dispatcher, channelId);
    }

    private <B extends AMQMethodBody> void checkChannel(AMQMethodEvent<B> evt, AMQProtocolSession protocolSession) throws AMQException {
        if (evt.getChannelId() != 0 && !(evt.getMethod() instanceof ChannelOpenBody) && protocolSession.getChannel(evt.getChannelId()) == null && !protocolSession.channelAwaitingClosure(evt.getChannelId())) {
            throw evt.getMethod().getChannelNotFoundException(evt.getChannelId());
        }
    }

    public void addStateListener(StateListener listener) {
        _logger.debug((Object)"Adding state listener");
        this._stateListeners.add(listener);
    }

    public void removeStateListener(StateListener listener) {
        this._stateListeners.remove(listener);
    }

    public VirtualHostRegistry getVirtualHostRegistry() {
        return this._virtualHostRegistry;
    }

    public AMQProtocolSession getProtocolSession() {
        SecurityManager.setThreadSubject(this._protocolSession.getAuthorizedSubject());
        return this._protocolSession;
    }
}

