/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.subscription;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.common.ClientProperties;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.configuration.ConfigStore;
import org.apache.qpid.server.configuration.ConfiguredObject;
import org.apache.qpid.server.configuration.SessionConfig;
import org.apache.qpid.server.configuration.SubscriptionConfig;
import org.apache.qpid.server.configuration.SubscriptionConfigType;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.FilterManagerFactory;
import org.apache.qpid.server.flow.FlowCreditManager;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.SubscriptionActor;
import org.apache.qpid.server.logging.messages.SubscriptionMessages;
import org.apache.qpid.server.logging.subjects.SubscriptionLogSubject;
import org.apache.qpid.server.message.AMQMessage;
import org.apache.qpid.server.output.ProtocolOutputConverter;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.subscription.ClientDeliveryMethod;
import org.apache.qpid.server.subscription.RecordDeliveryMethod;
import org.apache.qpid.server.subscription.Subscription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubscriptionImpl
implements Subscription,
FlowCreditManager.FlowCreditManagerListener,
SubscriptionConfig {
    private Subscription.StateListener _stateListener = new Subscription.StateListener(){

        public void stateChange(Subscription sub, Subscription.State oldState, Subscription.State newState) {
        }
    };
    private final AtomicReference<Subscription.State> _state = new AtomicReference<Subscription.State>(Subscription.State.ACTIVE);
    private AMQQueue.Context _queueContext;
    private final ClientDeliveryMethod _deliveryMethod;
    private final RecordDeliveryMethod _recordMethod;
    private final QueueEntry.SubscriptionAcquiredState _owningState = new QueueEntry.SubscriptionAcquiredState(this);
    private final QueueEntry.SubscriptionAssignedState _assignedState = new QueueEntry.SubscriptionAssignedState(this);
    private final Map<String, Object> _properties = new ConcurrentHashMap<String, Object>();
    private final Lock _stateChangeLock;
    private final long _subscriptionID;
    private LogSubject _logSubject;
    private LogActor _logActor;
    private UUID _id;
    private final AtomicLong _deliveredCount = new AtomicLong(0L);
    private long _createTime = System.currentTimeMillis();
    private static final Logger _logger = Logger.getLogger(SubscriptionImpl.class);
    private final AMQChannel _channel;
    private final AMQShortString _consumerTag;
    private boolean _noLocal;
    private final FlowCreditManager _creditManager;
    private FilterManager _filters;
    private final Boolean _autoClose;
    private static final String CLIENT_PROPERTIES_INSTANCE = ClientProperties.instance.toString();
    private AMQQueue _queue;
    private final AtomicBoolean _deleted = new AtomicBoolean(false);
    private String id = String.valueOf(System.identityHashCode(this));

    public SubscriptionImpl(AMQChannel channel, AMQProtocolSession protocolSession, AMQShortString consumerTag, FieldTable arguments, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod deliveryMethod, RecordDeliveryMethod recordMethod, long subscriptionID) throws AMQException {
        Object autoClose;
        this._subscriptionID = subscriptionID;
        this._channel = channel;
        this._consumerTag = consumerTag;
        this._creditManager = creditManager;
        creditManager.addStateListener(this);
        this._noLocal = noLocal;
        this._filters = FilterManagerFactory.createManager(arguments);
        this._deliveryMethod = deliveryMethod;
        this._recordMethod = recordMethod;
        this._stateChangeLock = new ReentrantLock();
        this._autoClose = arguments != null ? ((autoClose = arguments.get(AMQPFilterTypes.AUTO_CLOSE.getValue())) != null ? (Boolean)autoClose : Boolean.valueOf(false)) : Boolean.valueOf(false);
    }

    public ConfigStore getConfigStore() {
        return this.getQueue().getConfigStore();
    }

    @Override
    public Long getDelivered() {
        return this._deliveredCount.get();
    }

    @Override
    public synchronized void setQueue(AMQQueue queue, boolean exclusive) {
        if (this.getQueue() != null) {
            throw new IllegalStateException("Attempt to set queue for subscription " + this + " to " + queue + "when already set to " + this.getQueue());
        }
        this._queue = queue;
        this._id = this.getConfigStore().createId();
        this.getConfigStore().addConfiguredObject(this);
        this._logSubject = new SubscriptionLogSubject(this);
        this._logActor = new SubscriptionActor(CurrentActor.get().getRootMessageLogger(), this);
        if (CurrentActor.get().getRootMessageLogger().isMessageEnabled(CurrentActor.get(), this._logSubject, "qpid.message.subscription.create")) {
            String filterLogString = null;
            if (this._filters != null && this._filters.hasFilters()) {
                filterLogString = this._filters.toString();
            }
            if (this.isAutoClose()) {
                filterLogString = filterLogString == null ? "" : filterLogString + ",";
                filterLogString = filterLogString + "AutoClose";
            }
            if (this.isBrowser()) {
                filterLogString = filterLogString + ",Browser";
            }
            CurrentActor.get().message(this._logSubject, SubscriptionMessages.CREATE(filterLogString, queue.isDurable() && exclusive, filterLogString != null));
        }
    }

    public String toString() {
        String subscriber = "[channel=" + this._channel + ", consumerTag=" + this._consumerTag + ", session=" + this.getProtocolSession().getKey();
        return subscriber + "]";
    }

    @Override
    public abstract void send(QueueEntry var1) throws AMQException;

    @Override
    public boolean isSuspended() {
        return !this.isActive() || this._channel.isSuspended() || this._deleted.get();
    }

    @Override
    public void queueDeleted(AMQQueue queue) {
        this._deleted.set(true);
    }

    public boolean filtersMessages() {
        return this._filters != null || this._noLocal;
    }

    @Override
    public boolean hasInterest(QueueEntry entry) {
        AMQProtocolSession localInstance;
        AMQMessage message;
        Object publisher;
        if (entry.isRejectedBy(this.getSubscriptionID()) && _logger.isDebugEnabled()) {
            _logger.debug((Object)("Subscription:" + this + " rejected message:" + entry));
        }
        if (this._noLocal && (publisher = (message = (AMQMessage)entry.getMessage()).getPublisherIdentifier()).equals(localInstance = this.getProtocolSession())) {
            return false;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("(" + this + ") checking filters for message (" + entry));
        }
        return this.checkFilters(entry);
    }

    private String debugIdentity() {
        return this.id;
    }

    private boolean checkFilters(QueueEntry msg) {
        return this._filters == null || this._filters.allAllow(msg);
    }

    @Override
    public boolean isAutoClose() {
        return this._autoClose;
    }

    public FlowCreditManager getCreditManager() {
        return this._creditManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean closed = false;
        Subscription.State state = this.getState();
        this._stateChangeLock.lock();
        try {
            while (!closed && state != Subscription.State.CLOSED) {
                closed = this._state.compareAndSet(state, Subscription.State.CLOSED);
                if (!closed) {
                    state = this.getState();
                    continue;
                }
                this._stateListener.stateChange(this, state, Subscription.State.CLOSED);
            }
            this._creditManager.removeListener(this);
        }
        finally {
            this._stateChangeLock.unlock();
        }
        this.getConfigStore().removeConfiguredObject(this);
        CurrentActor.get().message(this._logSubject, SubscriptionMessages.CLOSE());
    }

    @Override
    public boolean isClosed() {
        return this.getState() == Subscription.State.CLOSED;
    }

    @Override
    public boolean wouldSuspend(QueueEntry msg) {
        return !this._creditManager.useCreditForMessage(msg.getMessage().getSize());
    }

    @Override
    public void getSendLock() {
        this._stateChangeLock.lock();
    }

    @Override
    public void releaseSendLock() {
        this._stateChangeLock.unlock();
    }

    public AMQChannel getChannel() {
        return this._channel;
    }

    @Override
    public AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    @Override
    public long getSubscriptionID() {
        return this._subscriptionID;
    }

    public AMQProtocolSession getProtocolSession() {
        return this._channel.getProtocolSession();
    }

    @Override
    public LogActor getLogActor() {
        return this._logActor;
    }

    @Override
    public AMQQueue getQueue() {
        return this._queue;
    }

    @Override
    public void onDequeue(QueueEntry queueEntry) {
        this.restoreCredit(queueEntry);
    }

    @Override
    public void releaseQueueEntry(QueueEntry queueEntry) {
        this.restoreCredit(queueEntry);
    }

    @Override
    public void restoreCredit(QueueEntry queueEntry) {
        this._creditManager.restoreCredit(1L, queueEntry.getSize());
    }

    @Override
    public void creditStateChanged(boolean hasCredit) {
        if (hasCredit) {
            if (this._state.compareAndSet(Subscription.State.SUSPENDED, Subscription.State.ACTIVE)) {
                this._stateListener.stateChange(this, Subscription.State.SUSPENDED, Subscription.State.ACTIVE);
            } else {
                this._stateListener.stateChange(this, Subscription.State.ACTIVE, Subscription.State.ACTIVE);
            }
        } else if (this._state.compareAndSet(Subscription.State.ACTIVE, Subscription.State.SUSPENDED)) {
            this._stateListener.stateChange(this, Subscription.State.ACTIVE, Subscription.State.SUSPENDED);
        }
        CurrentActor.get().message(this._logSubject, SubscriptionMessages.STATE(this._state.get().toString()));
    }

    @Override
    public Subscription.State getState() {
        return this._state.get();
    }

    @Override
    public void setStateListener(Subscription.StateListener listener) {
        this._stateListener = listener;
    }

    @Override
    public AMQQueue.Context getQueueContext() {
        return this._queueContext;
    }

    @Override
    public void setQueueContext(AMQQueue.Context context) {
        this._queueContext = context;
    }

    protected void sendToClient(QueueEntry entry, long deliveryTag) throws AMQException {
        this._deliveryMethod.deliverToClient(this, entry, deliveryTag);
        this._deliveredCount.incrementAndGet();
    }

    protected void recordMessageDelivery(QueueEntry entry, long deliveryTag) {
        this._recordMethod.recordMessageDelivery(this, entry, deliveryTag);
    }

    @Override
    public boolean isActive() {
        return this.getState() == Subscription.State.ACTIVE;
    }

    @Override
    public QueueEntry.SubscriptionAcquiredState getOwningState() {
        return this._owningState;
    }

    @Override
    public QueueEntry.SubscriptionAssignedState getAssignedState() {
        return this._assignedState;
    }

    @Override
    public void confirmAutoClose() {
        ProtocolOutputConverter converter = this.getChannel().getProtocolSession().getProtocolOutputConverter();
        converter.confirmConsumerAutoClose(this.getChannel().getChannelId(), this.getConsumerTag());
    }

    @Override
    public boolean acquires() {
        return !this.isBrowser();
    }

    @Override
    public boolean seesRequeues() {
        return !this.isBrowser();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void set(String key, Object value) {
        this._properties.put(key, value);
    }

    @Override
    public Object get(String key) {
        return this._properties.get(key);
    }

    @Override
    public void setNoLocal(boolean noLocal) {
        this._noLocal = noLocal;
    }

    abstract boolean isBrowser();

    @Override
    public String getCreditMode() {
        return "WINDOW";
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this.getChannel();
    }

    @Override
    public boolean isBrowsing() {
        return this.isBrowser();
    }

    @Override
    public boolean isExplicitAcknowledge() {
        return true;
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public SubscriptionConfigType getConfigType() {
        return SubscriptionConfigType.getInstance();
    }

    @Override
    public boolean isExclusive() {
        return this.getQueue().hasExclusiveSubscriber();
    }

    @Override
    public ConfiguredObject getParent() {
        return this.getSessionConfig();
    }

    @Override
    public String getName() {
        return String.valueOf(this._consumerTag);
    }

    @Override
    public Map<String, Object> getArguments() {
        return null;
    }

    @Override
    public boolean isSessionTransactional() {
        return this._channel.isTransactional();
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    static final class AckSubscription
    extends SubscriptionImpl {
        public AckSubscription(AMQChannel channel, AMQProtocolSession protocolSession, AMQShortString consumerTag, FieldTable filters, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod deliveryMethod, RecordDeliveryMethod recordMethod, long subscriptionID) throws AMQException {
            super(channel, protocolSession, consumerTag, filters, noLocal, creditManager, deliveryMethod, recordMethod, subscriptionID);
        }

        public boolean isBrowser() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(QueueEntry entry) throws AMQException {
            AMQChannel aMQChannel = this.getChannel();
            synchronized (aMQChannel) {
                long deliveryTag = this.getChannel().getNextDeliveryTag();
                this.recordMessageDelivery(entry, deliveryTag);
                this.sendToClient(entry, deliveryTag);
            }
        }
    }

    public static final class GetNoAckSubscription
    extends NoAckSubscription {
        public GetNoAckSubscription(AMQChannel channel, AMQProtocolSession protocolSession, AMQShortString consumerTag, FieldTable filters, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod deliveryMethod, RecordDeliveryMethod recordMethod, long subscriptionID) throws AMQException {
            super(channel, protocolSession, consumerTag, filters, noLocal, creditManager, deliveryMethod, recordMethod, subscriptionID);
        }

        public boolean isTransient() {
            return true;
        }

        public boolean wouldSuspend(QueueEntry msg) {
            return !this.getCreditManager().useCreditForMessage(msg.getMessage().getSize());
        }
    }

    public static class NoAckSubscription
    extends SubscriptionImpl {
        public NoAckSubscription(AMQChannel channel, AMQProtocolSession protocolSession, AMQShortString consumerTag, FieldTable filters, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod deliveryMethod, RecordDeliveryMethod recordMethod, long subscriptionID) throws AMQException {
            super(channel, protocolSession, consumerTag, filters, noLocal, creditManager, deliveryMethod, recordMethod, subscriptionID);
        }

        public boolean isBrowser() {
            return false;
        }

        public boolean isExplicitAcknowledge() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(QueueEntry entry) throws AMQException {
            entry.dequeue();
            AMQChannel aMQChannel = this.getChannel();
            synchronized (aMQChannel) {
                long deliveryTag = this.getChannel().getNextDeliveryTag();
                this.sendToClient(entry, deliveryTag);
            }
            entry.dispose();
        }

        public boolean wouldSuspend(QueueEntry msg) {
            return false;
        }
    }

    static final class BrowserSubscription
    extends SubscriptionImpl {
        public BrowserSubscription(AMQChannel channel, AMQProtocolSession protocolSession, AMQShortString consumerTag, FieldTable filters, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod deliveryMethod, RecordDeliveryMethod recordMethod, long subscriptionID) throws AMQException {
            super(channel, protocolSession, consumerTag, filters, noLocal, creditManager, deliveryMethod, recordMethod, subscriptionID);
        }

        public boolean isBrowser() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(QueueEntry msg) throws AMQException {
            AMQChannel aMQChannel = this.getChannel();
            synchronized (aMQChannel) {
                long deliveryTag = this.getChannel().getNextDeliveryTag();
                this.sendToClient(msg, deliveryTag);
            }
        }

        public boolean wouldSuspend(QueueEntry msg) {
            return false;
        }
    }
}

