/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.protocol.ProtocolEngine;
import org.apache.qpid.server.protocol.AMQConnectionModel;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.subscription.Subscription_0_10;
import org.apache.qpid.server.transport.ServerConnection;
import org.apache.qpid.server.transport.ServerSession;
import org.apache.qpid.server.transport.ServerSessionDelegate;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.Binary;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionClose;
import org.apache.qpid.transport.ConnectionCloseCode;
import org.apache.qpid.transport.ConnectionOpen;
import org.apache.qpid.transport.ConnectionOpenOk;
import org.apache.qpid.transport.ConnectionTuneOk;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ServerDelegate;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionAttach;
import org.apache.qpid.transport.SessionDetach;
import org.apache.qpid.transport.SessionDetachCode;
import org.apache.qpid.transport.SessionDetached;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConnectionDelegate
extends ServerDelegate {
    private String _localFQDN;
    private final IApplicationRegistry _appRegistry;

    public ServerConnectionDelegate(IApplicationRegistry appRegistry, String localFQDN) {
        this(new HashMap<String, Object>(Collections.singletonMap("qpid.federation_tag", appRegistry.getBroker().getFederationTag())), Collections.singletonList("en_US"), appRegistry, localFQDN);
    }

    public ServerConnectionDelegate(Map<String, Object> properties, List<Object> locales, IApplicationRegistry appRegistry, String localFQDN) {
        super(properties, ServerConnectionDelegate.parseToList(appRegistry.getAuthenticationManager().getMechanisms()), locales);
        this._appRegistry = appRegistry;
        this._localFQDN = localFQDN;
    }

    private static List<Object> parseToList(String mechanisms) {
        ArrayList<Object> list = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(mechanisms, " ");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    public ServerSession getSession(Connection conn, SessionAttach atc) {
        ServerSessionDelegate serverSessionDelegate = new ServerSessionDelegate();
        ServerSession ssn = new ServerSession(conn, serverSessionDelegate, new Binary(atc.getName()), 0L);
        return ssn;
    }

    protected SaslServer createSaslServer(String mechanism) throws SaslException {
        return this._appRegistry.getAuthenticationManager().createSaslServer(mechanism, this._localFQDN);
    }

    protected void secure(SaslServer ss, Connection conn, byte[] response) {
        AuthenticationResult authResult = this._appRegistry.getAuthenticationManager().authenticate(ss, response);
        ServerConnection sconn = (ServerConnection)conn;
        if (AuthenticationResult.AuthenticationStatus.SUCCESS.equals((Object)authResult.getStatus())) {
            this.tuneAuthorizedConnection(sconn);
            sconn.setAuthorizedSubject(authResult.getSubject());
        } else if (AuthenticationResult.AuthenticationStatus.CONTINUE.equals((Object)authResult.getStatus())) {
            this.connectionAuthContinue(sconn, authResult.getChallenge());
        } else {
            this.connectionAuthFailed(sconn, authResult.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClose(Connection conn, ConnectionClose close) {
        try {
            ((ServerConnection)conn).logClosed();
        }
        finally {
            super.connectionClose(conn, close);
        }
    }

    public void connectionOpen(Connection conn, ConnectionOpen open) {
        ServerConnection sconn = (ServerConnection)conn;
        String vhostName = open.hasVirtualHost() ? open.getVirtualHost() : "";
        VirtualHost vhost = this._appRegistry.getVirtualHostRegistry().getVirtualHost(vhostName);
        SecurityManager.setThreadSubject(sconn.getAuthorizedSubject());
        if (vhost != null) {
            sconn.setVirtualHost(vhost);
            if (!vhost.getSecurityManager().accessVirtualhost(vhostName, ((ProtocolEngine)sconn.getConfig()).getRemoteAddress())) {
                sconn.invoke((Method)new ConnectionClose(ConnectionCloseCode.CONNECTION_FORCED, "Permission denied '" + vhostName + "'", new Option[0]));
                sconn.setState(Connection.State.CLOSING);
            } else {
                sconn.invoke((Method)new ConnectionOpenOk(Collections.emptyList(), new Option[0]));
                sconn.setState(Connection.State.OPEN);
            }
        } else {
            sconn.invoke((Method)new ConnectionClose(ConnectionCloseCode.INVALID_PATH, "Unknown virtualhost '" + vhostName + "'", new Option[0]));
            sconn.setState(Connection.State.CLOSING);
        }
    }

    public void connectionTuneOk(Connection conn, ConnectionTuneOk ok) {
        ServerConnection sconn = (ServerConnection)conn;
        int okChannelMax = ok.getChannelMax();
        if (okChannelMax > this.getChannelMax()) {
            _logger.error("Connection '" + sconn.getConnectionId() + "' being severed, " + "client connectionTuneOk returned a channelMax (" + okChannelMax + ") above the servers offered limit (" + this.getChannelMax() + ")");
            sconn.getSender().close();
            return;
        }
        this.setConnectionTuneOkChannelMax(sconn, okChannelMax);
    }

    protected int getHeartbeatMax() {
        return 0;
    }

    protected int getChannelMax() {
        return ApplicationRegistry.getInstance().getConfiguration().getMaxChannelCount();
    }

    public void sessionDetach(Connection conn, SessionDetach dtc) {
        this.unregisterAllSubscriptions(conn, dtc);
        super.sessionDetach(conn, dtc);
    }

    private void unregisterAllSubscriptions(Connection conn, SessionDetach dtc) {
        ServerSession ssn = (ServerSession)conn.getSession(dtc.getChannel());
        Collection<Subscription_0_10> subs = ssn.getSubscriptions();
        for (Subscription_0_10 subscription_0_10 : subs) {
            ssn.unregister(subscription_0_10);
        }
    }

    public void sessionAttach(Connection conn, SessionAttach atc) {
        if (this.isSessionNameUnique(atc.getName(), conn)) {
            Session ssn = this.sessionAttachImpl(conn, atc);
            conn.registerSession(ssn);
        } else {
            ServerSession ssn = this.getSession(conn, atc);
            ssn.invoke((Method)new SessionDetached(atc.getName(), SessionDetachCode.SESSION_BUSY, new Option[0]));
            ssn.closed();
        }
    }

    private boolean isSessionNameUnique(byte[] name, Connection conn) {
        ServerConnection sconn = (ServerConnection)conn;
        String userId = sconn.getUserName();
        for (AMQConnectionModel amqConnectionModel : ((ServerConnection)conn).getVirtualHost().getConnectionRegistry().getConnections()) {
            if (!userId.equals(amqConnectionModel.getUserName()) || amqConnectionModel.isSessionNameUnique(name)) continue;
            return false;
        }
        return true;
    }
}

