/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQStoreException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.AMQBrokerManagerMBean;
import org.apache.qpid.server.binding.BindingFactory;
import org.apache.qpid.server.configuration.BrokerConfig;
import org.apache.qpid.server.configuration.ConfigStore;
import org.apache.qpid.server.configuration.ConfiguredObject;
import org.apache.qpid.server.configuration.ExchangeConfiguration;
import org.apache.qpid.server.configuration.QueueConfiguration;
import org.apache.qpid.server.configuration.VirtualHostConfigType;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.connection.ConnectionRegistry;
import org.apache.qpid.server.connection.IConnectionRegistry;
import org.apache.qpid.server.exchange.DefaultExchangeFactory;
import org.apache.qpid.server.exchange.DefaultExchangeRegistry;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeFactory;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.federation.BrokerLink;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.VirtualHostMessages;
import org.apache.qpid.server.logging.subjects.MessageStoreLogSubject;
import org.apache.qpid.server.management.AMQManagedObject;
import org.apache.qpid.server.management.ManagedObject;
import org.apache.qpid.server.protocol.AMQConnectionModel;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.queue.DefaultQueueRegistry;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.store.ConfigurationRecoveryHandler;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.TransactionLog;
import org.apache.qpid.server.virtualhost.HouseKeepingTask;
import org.apache.qpid.server.virtualhost.ManagedVirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostConfigRecoveryHandler;
import org.apache.qpid.server.virtualhost.plugins.VirtualHostHouseKeepingPlugin;
import org.apache.qpid.server.virtualhost.plugins.VirtualHostPluginFactory;

public class VirtualHostImpl
implements VirtualHost {
    private static final Logger _logger = Logger.getLogger(VirtualHostImpl.class);
    private final String _name;
    private ConnectionRegistry _connectionRegistry;
    private QueueRegistry _queueRegistry;
    private ExchangeRegistry _exchangeRegistry;
    private ExchangeFactory _exchangeFactory;
    private MessageStore _messageStore;
    protected VirtualHostMBean _virtualHostMBean;
    private AMQBrokerManagerMBean _brokerMBean;
    private final AuthenticationManager _authenticationManager;
    private SecurityManager _securityManager;
    private final ScheduledThreadPoolExecutor _houseKeepingTasks;
    private final IApplicationRegistry _appRegistry;
    private VirtualHostConfiguration _configuration;
    private DurableConfigurationStore _durableConfigurationStore;
    private BindingFactory _bindingFactory;
    private BrokerConfig _broker;
    private UUID _id;
    private boolean _statisticsEnabled = false;
    private StatisticsCounter _messagesDelivered;
    private StatisticsCounter _dataDelivered;
    private StatisticsCounter _messagesReceived;
    private StatisticsCounter _dataReceived;
    private final long _createTime = System.currentTimeMillis();
    private final ConcurrentHashMap<BrokerLink, BrokerLink> _links = new ConcurrentHashMap();
    private static final int HOUSEKEEPING_SHUTDOWN_TIMEOUT = 5;

    public IConnectionRegistry getConnectionRegistry() {
        return this._connectionRegistry;
    }

    public VirtualHostConfiguration getConfiguration() {
        return this._configuration;
    }

    public UUID getId() {
        return this._id;
    }

    public VirtualHostConfigType getConfigType() {
        return VirtualHostConfigType.getInstance();
    }

    public ConfiguredObject getParent() {
        return this.getBroker();
    }

    public boolean isDurable() {
        return false;
    }

    public VirtualHostImpl(IApplicationRegistry appRegistry, VirtualHostConfiguration hostConfig, MessageStore store) throws Exception {
        if (hostConfig == null) {
            throw new IllegalArgumentException("HostConfig cannot be null");
        }
        this._appRegistry = appRegistry;
        this._broker = this._appRegistry.getBroker();
        this._configuration = hostConfig;
        this._name = this._configuration.getName();
        this._id = this._appRegistry.getConfigStore().createId();
        CurrentActor.get().message(VirtualHostMessages.CREATED(this._name));
        if (this._name == null || this._name.length() == 0) {
            throw new IllegalArgumentException("Illegal name (" + this._name + ") for virtualhost.");
        }
        this._securityManager = new SecurityManager(this._appRegistry.getSecurityManager());
        this._securityManager.configureHostPlugins(this._configuration);
        this._virtualHostMBean = new VirtualHostMBean();
        this._connectionRegistry = new ConnectionRegistry();
        this._houseKeepingTasks = new ScheduledThreadPoolExecutor(this._configuration.getHouseKeepingThreadCount());
        this._queueRegistry = new DefaultQueueRegistry(this);
        this._exchangeFactory = new DefaultExchangeFactory(this);
        this._exchangeFactory.initialise(this._configuration);
        this._exchangeRegistry = new DefaultExchangeRegistry(this);
        StartupRoutingTable configFileRT = new StartupRoutingTable();
        this._durableConfigurationStore = configFileRT;
        this._exchangeRegistry.initialise();
        this._bindingFactory = new BindingFactory(this);
        this.initialiseModel(this._configuration);
        if (store != null) {
            this._messageStore = store;
            this._durableConfigurationStore = store;
        } else {
            this.initialiseMessageStore(hostConfig);
        }
        this._authenticationManager = ApplicationRegistry.getInstance().getAuthenticationManager();
        this._brokerMBean = new AMQBrokerManagerMBean(this._virtualHostMBean);
        this._brokerMBean.register();
        this.initialiseHouseKeeping(hostConfig.getHousekeepingCheckPeriod());
        this.initialiseStatistics();
    }

    private void initialiseHouseKeeping(long period) {
        if (period != 0L) {
            class VirtualHostHouseKeepingTask
            extends HouseKeepingTask {
                public VirtualHostHouseKeepingTask(VirtualHost vhost) {
                    super(vhost);
                }

                public void execute() {
                    for (AMQQueue q : VirtualHostImpl.this._queueRegistry.getQueues()) {
                        this._logger.debug((Object)("Checking message status for queue: " + q.getName()));
                        try {
                            q.checkMessageStatus();
                        }
                        catch (Exception e) {
                            this._logger.error((Object)("Exception in housekeeping for queue: " + q.getNameShortString().toString()), (Throwable)e);
                        }
                    }
                    for (AMQConnectionModel connection : VirtualHostImpl.this.getConnectionRegistry().getConnections()) {
                        this._logger.debug((Object)("Checking for long running open transactions on connection " + connection));
                        for (AMQSessionModel session : connection.getSessionModels()) {
                            this._logger.debug((Object)("Checking for long running open transactions on session " + session));
                            try {
                                session.checkTransactionStatus(VirtualHostImpl.this._configuration.getTransactionTimeoutOpenWarn(), VirtualHostImpl.this._configuration.getTransactionTimeoutOpenClose(), VirtualHostImpl.this._configuration.getTransactionTimeoutIdleWarn(), VirtualHostImpl.this._configuration.getTransactionTimeoutIdleClose());
                            }
                            catch (Exception e) {
                                this._logger.error((Object)("Exception in housekeeping for connection: " + connection.toString()), (Throwable)e);
                            }
                        }
                    }
                }
            }
            this.scheduleHouseKeepingTask(period, new VirtualHostHouseKeepingTask(this));
            Map<String, VirtualHostPluginFactory> plugins = ApplicationRegistry.getInstance().getPluginManager().getVirtualHostPlugins();
            if (plugins != null) {
                for (Map.Entry<String, VirtualHostPluginFactory> entry : plugins.entrySet()) {
                    String pluginName = entry.getKey();
                    VirtualHostPluginFactory factory = entry.getValue();
                    try {
                        VirtualHostHouseKeepingPlugin plugin = factory.newInstance(this);
                        if (plugin == null) continue;
                        this._houseKeepingTasks.scheduleAtFixedRate(plugin, plugin.getDelay() / 2L, plugin.getDelay(), plugin.getTimeUnit());
                        _logger.info((Object)("Loaded VirtualHostPlugin:" + plugin));
                    }
                    catch (RuntimeException e) {
                        _logger.error((Object)("Unable to load VirtualHostPlugin:" + pluginName + " due to:" + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
    }

    public void scheduleHouseKeepingTask(long period, HouseKeepingTask task) {
        this._houseKeepingTasks.scheduleAtFixedRate(task, period / 2L, period, TimeUnit.MILLISECONDS);
    }

    public long getHouseKeepingTaskCount() {
        return this._houseKeepingTasks.getTaskCount();
    }

    public long getHouseKeepingCompletedTaskCount() {
        return this._houseKeepingTasks.getCompletedTaskCount();
    }

    public int getHouseKeepingPoolSize() {
        return this._houseKeepingTasks.getCorePoolSize();
    }

    public void setHouseKeepingPoolSize(int newSize) {
        this._houseKeepingTasks.setCorePoolSize(newSize);
    }

    public int getHouseKeepingActiveCount() {
        return this._houseKeepingTasks.getActiveCount();
    }

    private void initialiseMessageStore(VirtualHostConfiguration hostConfig) throws Exception {
        String messageStoreClass = hostConfig.getMessageStoreClass();
        Class<?> clazz = Class.forName(messageStoreClass);
        Object o = clazz.newInstance();
        if (!(o instanceof MessageStore)) {
            throw new ClassCastException("Message store class must implement " + MessageStore.class + ". Class " + clazz + " does not.");
        }
        MessageStore messageStore = (MessageStore)o;
        VirtualHostConfigRecoveryHandler recoveryHandler = new VirtualHostConfigRecoveryHandler(this);
        MessageStoreLogSubject storeLogSubject = new MessageStoreLogSubject(this, messageStore);
        messageStore.configureConfigStore(this.getName(), recoveryHandler, hostConfig.getStoreConfiguration(), storeLogSubject);
        messageStore.configureMessageStore(this.getName(), recoveryHandler, hostConfig.getStoreConfiguration(), storeLogSubject);
        messageStore.configureTransactionLog(this.getName(), recoveryHandler, hostConfig.getStoreConfiguration(), storeLogSubject);
        this._messageStore = messageStore;
        this._durableConfigurationStore = messageStore;
    }

    private void initialiseModel(VirtualHostConfiguration config) throws ConfigurationException, AMQException {
        String[] queueNames;
        _logger.debug((Object)("Loading configuration for virtualhost: " + config.getName()));
        List exchangeNames = config.getExchanges();
        for (Object exchangeNameObj : exchangeNames) {
            String exchangeName = String.valueOf(exchangeNameObj);
            this.configureExchange(config.getExchangeConfiguration(exchangeName));
        }
        for (String queueNameObj : queueNames = config.getQueueNames()) {
            String queueName = String.valueOf(queueNameObj);
            this.configureQueue(config.getQueueConfiguration(queueName));
        }
    }

    private void configureExchange(ExchangeConfiguration exchangeConfiguration) throws AMQException {
        AMQShortString exchangeName = new AMQShortString(exchangeConfiguration.getName());
        Exchange exchange = this._exchangeRegistry.getExchange(exchangeName);
        if (exchange == null) {
            AMQShortString type = new AMQShortString(exchangeConfiguration.getType());
            boolean durable = exchangeConfiguration.getDurable();
            boolean autodelete = exchangeConfiguration.getAutoDelete();
            Exchange newExchange = this._exchangeFactory.createExchange(exchangeName, type, durable, autodelete, 0);
            this._exchangeRegistry.registerExchange(newExchange);
            if (newExchange.isDurable()) {
                this._durableConfigurationStore.createExchange(newExchange);
            }
        }
    }

    private void configureQueue(QueueConfiguration queueConfiguration) throws AMQException, ConfigurationException {
        String exchangeName;
        Exchange exchange;
        AMQQueue queue = AMQQueueFactory.createAMQQueueImpl(queueConfiguration, this);
        String queueName = queue.getName();
        if (queue.isDurable()) {
            this.getDurableConfigurationStore().createQueue(queue);
        }
        if ((exchange = this._exchangeRegistry.getExchange(exchangeName = queueConfiguration.getExchange())) == null) {
            throw new ConfigurationException("Attempt to bind queue '" + queueName + "' to unknown exchange:" + exchangeName);
        }
        Exchange defaultExchange = this._exchangeRegistry.getDefaultExchange();
        List routingKeys = queueConfiguration.getRoutingKeys();
        for (Object routingKeyNameObj : routingKeys) {
            String routingKey = String.valueOf(routingKeyNameObj);
            if (exchange.equals(defaultExchange) && !queueName.equals(routingKey)) {
                throw new ConfigurationException("Illegal attempt to bind queue '" + queueName + "' to the default exchange with a key other than the queue name: " + routingKey);
            }
            this.configureBinding(queue, exchange, routingKey);
        }
        if (!exchange.equals(defaultExchange)) {
            this.configureBinding(queue, exchange, queueName);
        }
        this.configureBinding(queue, defaultExchange, queueName);
    }

    private void configureBinding(AMQQueue queue, Exchange exchange, String routingKey) throws AMQException {
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Binding queue:" + queue + " with routing key '" + routingKey + "' to exchange:" + exchange.getName()));
        }
        this._bindingFactory.addBinding(routingKey, queue, exchange, null);
    }

    public String getName() {
        return this._name;
    }

    public BrokerConfig getBroker() {
        return this._broker;
    }

    public String getFederationTag() {
        return this._broker.getFederationTag();
    }

    public void setBroker(BrokerConfig broker) {
        this._broker = broker;
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public QueueRegistry getQueueRegistry() {
        return this._queueRegistry;
    }

    public ExchangeRegistry getExchangeRegistry() {
        return this._exchangeRegistry;
    }

    public ExchangeFactory getExchangeFactory() {
        return this._exchangeFactory;
    }

    public MessageStore getMessageStore() {
        return this._messageStore;
    }

    public TransactionLog getTransactionLog() {
        return this._messageStore;
    }

    public DurableConfigurationStore getDurableConfigurationStore() {
        return this._durableConfigurationStore;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this._authenticationManager;
    }

    public SecurityManager getSecurityManager() {
        return this._securityManager;
    }

    public void close() {
        this._connectionRegistry.close();
        if (this._queueRegistry != null) {
            for (AMQQueue queue : this._queueRegistry.getQueues()) {
                queue.stop();
            }
        }
        if (this._houseKeepingTasks != null) {
            this._houseKeepingTasks.shutdown();
            try {
                if (!this._houseKeepingTasks.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this._houseKeepingTasks.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                _logger.warn((Object)("Interrupted during Housekeeping shutdown:" + e.getMessage()));
            }
        }
        if (this._messageStore != null) {
            try {
                this._messageStore.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CurrentActor.get().message(VirtualHostMessages.CLOSED());
    }

    public ManagedObject getBrokerMBean() {
        return this._brokerMBean;
    }

    public ManagedObject getManagedObject() {
        return this._virtualHostMBean;
    }

    public UUID getBrokerId() {
        return this._appRegistry.getBrokerId();
    }

    public IApplicationRegistry getApplicationRegistry() {
        return this._appRegistry;
    }

    public BindingFactory getBindingFactory() {
        return this._bindingFactory;
    }

    public void registerMessageDelivered(long messageSize) {
        if (this.isStatisticsEnabled()) {
            this._messagesDelivered.registerEvent(1L);
            this._dataDelivered.registerEvent(messageSize);
        }
        this._appRegistry.registerMessageDelivered(messageSize);
    }

    public void registerMessageReceived(long messageSize, long timestamp) {
        if (this.isStatisticsEnabled()) {
            this._messagesReceived.registerEvent(1L, timestamp);
            this._dataReceived.registerEvent(messageSize, timestamp);
        }
        this._appRegistry.registerMessageReceived(messageSize, timestamp);
    }

    public StatisticsCounter getMessageReceiptStatistics() {
        return this._messagesReceived;
    }

    public StatisticsCounter getDataReceiptStatistics() {
        return this._dataReceived;
    }

    public StatisticsCounter getMessageDeliveryStatistics() {
        return this._messagesDelivered;
    }

    public StatisticsCounter getDataDeliveryStatistics() {
        return this._dataDelivered;
    }

    public void resetStatistics() {
        this._messagesDelivered.reset();
        this._dataDelivered.reset();
        this._messagesReceived.reset();
        this._dataReceived.reset();
        for (AMQConnectionModel connection : this._connectionRegistry.getConnections()) {
            connection.resetStatistics();
        }
    }

    public void initialiseStatistics() {
        this.setStatisticsEnabled(!StatisticsCounter.DISABLE_STATISTICS && this._appRegistry.getConfiguration().isStatisticsGenerationVirtualhostsEnabled());
        this._messagesDelivered = new StatisticsCounter("messages-delivered-" + this.getName());
        this._dataDelivered = new StatisticsCounter("bytes-delivered-" + this.getName());
        this._messagesReceived = new StatisticsCounter("messages-received-" + this.getName());
        this._dataReceived = new StatisticsCounter("bytes-received-" + this.getName());
    }

    public boolean isStatisticsEnabled() {
        return this._statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean enabled) {
        this._statisticsEnabled = enabled;
    }

    public void createBrokerConnection(String transport, String host, int port, String vhost, boolean durable, String authMechanism, String username, String password) {
        BrokerLink blink = new BrokerLink(this, transport, host, port, vhost, durable, authMechanism, username, password);
        if (this._links.putIfAbsent(blink, blink) != null) {
            this.getConfigStore().addConfiguredObject(blink);
        }
    }

    public void removeBrokerConnection(String transport, String host, int port, String vhost) {
        this.removeBrokerConnection(new BrokerLink(this, transport, host, port, vhost, false, null, null, null));
    }

    public void removeBrokerConnection(BrokerLink blink) {
        if ((blink = this._links.get(blink)) != null) {
            blink.close();
            this.getConfigStore().removeConfiguredObject(blink);
        }
    }

    public ConfigStore getConfigStore() {
        return this.getApplicationRegistry().getConfigStore();
    }

    public String toString() {
        return this._name;
    }

    private static class StartupRoutingTable
    implements DurableConfigurationStore {
        public List<Exchange> exchange = new LinkedList<Exchange>();
        public List<CreateQueueTuple> queue = new LinkedList<CreateQueueTuple>();
        public List<CreateBindingTuple> bindings = new LinkedList<CreateBindingTuple>();

        private StartupRoutingTable() {
        }

        public void configure(VirtualHost virtualHost, String base, VirtualHostConfiguration config) throws Exception {
        }

        public void close() throws Exception {
        }

        public void removeMessage(Long messageId) throws AMQException {
        }

        public void configureConfigStore(String name, ConfigurationRecoveryHandler recoveryHandler, Configuration config, LogSubject logSubject) throws Exception {
        }

        public void createExchange(Exchange exchange) throws AMQStoreException {
            if (exchange.isDurable()) {
                this.exchange.add(exchange);
            }
        }

        public void removeExchange(Exchange exchange) throws AMQStoreException {
        }

        public void bindQueue(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQStoreException {
            if (exchange.isDurable() && queue.isDurable()) {
                this.bindings.add(new CreateBindingTuple(exchange, routingKey, queue, args));
            }
        }

        public void unbindQueue(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQStoreException {
        }

        public void createQueue(AMQQueue queue) throws AMQStoreException {
            this.createQueue(queue, null);
        }

        public void createQueue(AMQQueue queue, FieldTable arguments) throws AMQStoreException {
            if (queue.isDurable()) {
                this.queue.add(new CreateQueueTuple(queue, arguments));
            }
        }

        public void removeQueue(AMQQueue queue) throws AMQStoreException {
        }

        public void updateQueue(AMQQueue queue) throws AMQStoreException {
        }

        private static class CreateBindingTuple {
            public AMQQueue queue;
            public FieldTable arguments;
            public Exchange exchange;
            public AMQShortString routingKey;

            public CreateBindingTuple(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) {
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.queue = queue;
                this.arguments = args;
            }
        }

        private static class CreateQueueTuple {
            public AMQQueue queue;
            public FieldTable arguments;

            public CreateQueueTuple(AMQQueue queue, FieldTable arguments) {
                this.queue = queue;
                this.arguments = arguments;
            }
        }
    }

    public class VirtualHostMBean
    extends AMQManagedObject
    implements ManagedVirtualHost {
        public VirtualHostMBean() throws NotCompliantMBeanException {
            super(ManagedVirtualHost.class, "VirtualHost");
        }

        public String getObjectInstanceName() {
            return ObjectName.quote(VirtualHostImpl.this._name);
        }

        public String getName() {
            return VirtualHostImpl.this._name;
        }

        public VirtualHostImpl getVirtualHost() {
            return VirtualHostImpl.this;
        }
    }
}

