/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.qmf.QMFClass;
import org.apache.qpid.qmf.QMFCommand;
import org.apache.qpid.qmf.QMFCommandCompletionCommand;
import org.apache.qpid.qmf.QMFCommandHeader;
import org.apache.qpid.qmf.QMFMessage;
import org.apache.qpid.qmf.QMFObject;
import org.apache.qpid.qmf.QMFPackage;
import org.apache.qpid.qmf.QMFService;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.codec.BBDecoder;

public class QMFGetQueryCommand
extends QMFCommand {
    private static final Logger _qmfLogger = Logger.getLogger((String)"qpid.qmf");
    private String _className;
    private String _packageName;
    private UUID _objectId;

    public QMFGetQueryCommand(QMFCommandHeader header, BBDecoder decoder) {
        super(header);
        Map _map = decoder.readMap();
        this._className = (String)_map.get("_class");
        this._packageName = (String)_map.get("_package");
        byte[] objectIdBytes = (byte[])_map.get("_objectId");
        if (objectIdBytes != null) {
            int i;
            long msb = 0L;
            long lsb = 0L;
            for (i = 0; i != 8; ++i) {
                msb = msb << 8 | (long)(objectIdBytes[i] & 0xFF);
            }
            for (i = 8; i != 16; ++i) {
                lsb = lsb << 8 | (long)(objectIdBytes[i] & 0xFF);
            }
            this._objectId = new UUID(msb, lsb);
        } else {
            this._objectId = null;
        }
    }

    public void process(VirtualHost virtualHost, ServerMessage message) {
        QMFPackage qmfPackage;
        String exchangeName = message.getMessageHeader().getReplyToExchange();
        String routingKey = message.getMessageHeader().getReplyToRoutingKey();
        IApplicationRegistry appRegistry = virtualHost.getApplicationRegistry();
        QMFService service = appRegistry.getQMFService();
        _qmfLogger.debug((Object)("Execute: " + this));
        ArrayList<QMFCommand> commands = new ArrayList<QMFCommand>();
        long sampleTime = System.currentTimeMillis() * 1000000L;
        Collection<Object> packages = this._packageName != null && this._packageName.length() != 0 ? ((qmfPackage = service.getPackage(this._packageName)) == null ? Collections.EMPTY_LIST : Collections.singleton(qmfPackage)) : service.getSupportedSchemas();
        for (QMFPackage qmfPackage2 : packages) {
            QMFClass qmfClass;
            Collection<Object> qmfClasses = this._className != null && this._className.length() != 0 ? ((qmfClass = qmfPackage2.getQMFClass(this._className)) == null ? Collections.EMPTY_LIST : Collections.singleton(qmfClass)) : qmfPackage2.getClasses();
            for (QMFClass qmfClass2 : qmfClasses) {
                QMFObject qMFObject;
                Collection<Object> objects = this._objectId != null ? ((qMFObject = service.getObjectById(qmfClass2, this._objectId)) == null ? Collections.EMPTY_LIST : Collections.singleton(qMFObject)) : service.getObjects(qmfClass2);
                for (QMFObject object : objects) {
                    commands.add(object.asGetQueryResponseCmd(this, sampleTime));
                }
            }
        }
        commands.add(new QMFCommandCompletionCommand(this));
        for (QMFCommand cmd : commands) {
            _qmfLogger.debug((Object)("Respond: " + cmd));
            QMFMessage responseMessage = new QMFMessage(routingKey, cmd);
            Exchange exchange = virtualHost.getExchangeRegistry().getExchange(exchangeName);
            List<? extends BaseQueue> queues = exchange.route(responseMessage);
            for (BaseQueue baseQueue : queues) {
                try {
                    baseQueue.enqueue(responseMessage);
                }
                catch (AMQException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String toString() {
        return "QMFGetQueryCommand{packageName='" + this._packageName + '\'' + ", className='" + this._className + '\'' + ", objectId=" + this._objectId + '}';
    }
}

