/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.qmf.QMFCommand;
import org.apache.qpid.server.configuration.SessionConfig;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.transport.codec.BBEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QMFMessage
implements ServerMessage,
InboundMessage,
AMQMessageHeader {
    private ByteBuffer _content;
    private String _routingKey;

    public QMFMessage(String routingKey, QMFCommand command) {
        this(routingKey, new QMFCommand[]{command});
    }

    public QMFMessage(String routingKey, QMFCommand[] commands) {
        this._routingKey = routingKey;
        BBEncoder encoder = new BBEncoder(256);
        for (QMFCommand cmd : commands) {
            cmd.encode(encoder);
        }
        this._content = encoder.buffer();
    }

    @Override
    public String getRoutingKey() {
        return this._routingKey;
    }

    @Override
    public AMQShortString getRoutingKeyShortString() {
        return AMQShortString.valueOf((String)this._routingKey);
    }

    @Override
    public AMQMessageHeader getMessageHeader() {
        return this;
    }

    @Override
    public StoredMessage getStoredMessage() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean isRedelivered() {
        return false;
    }

    @Override
    public long getSize() {
        return this._content.limit();
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public String getCorrelationId() {
        return null;
    }

    @Override
    public long getExpiration() {
        return 0L;
    }

    @Override
    public String getUserId() {
        return null;
    }

    @Override
    public String getAppId() {
        return null;
    }

    @Override
    public String getMessageId() {
        return null;
    }

    @Override
    public String getMimeType() {
        return null;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public byte getPriority() {
        return 4;
    }

    @Override
    public long getTimestamp() {
        return 0L;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String getReplyTo() {
        return null;
    }

    @Override
    public String getReplyToExchange() {
        return null;
    }

    @Override
    public String getReplyToRoutingKey() {
        return null;
    }

    @Override
    public Object getHeader(String name) {
        return null;
    }

    @Override
    public boolean containsHeaders(Set<String> names) {
        return false;
    }

    @Override
    public Collection<String> getHeaderNames() {
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean containsHeader(String name) {
        return false;
    }

    @Override
    public MessageReference newReference() {
        return new QMFMessageReference(this);
    }

    @Override
    public long getMessageNumber() {
        return 0L;
    }

    @Override
    public long getArrivalTime() {
        return 0L;
    }

    @Override
    public int getContent(ByteBuffer buf, int offset) {
        ByteBuffer src = this._content.duplicate();
        src.position(offset);
        src = src.slice();
        int len = src.remaining();
        if (len > buf.remaining()) {
            len = buf.remaining();
        }
        buf.put(src);
        return len;
    }

    @Override
    public ByteBuffer getContent(int offset, int size) {
        ByteBuffer src = this._content.duplicate();
        src.position(offset);
        src = src.slice();
        src.limit(size);
        return src;
    }

    public SessionConfig getSessionConfig() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QMFMessageReference
    extends MessageReference<QMFMessage> {
        public QMFMessageReference(QMFMessage message) {
            super(message);
        }

        @Override
        protected void onReference(QMFMessage message) {
        }

        @Override
        protected void onRelease(QMFMessage message) {
        }
    }
}

