/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProtocolExclusion {
    v0_8("exclude-0-8", "--exclude-0-8"),
    v0_9("exclude-0-9", "--exclude-0-9"),
    v0_9_1("exclude-0-9-1", "--exclude-0-9-1"),
    v0_10("exclude-0-10", "--exclude-0-10"),
    v1_0("exclude-1-0", "--exclude-1-0");

    private static final Map<String, ProtocolExclusion> MAP;
    private String _arg;
    private String _excludeName;

    private ProtocolExclusion(String excludeName, String arg) {
        this._excludeName = excludeName;
        this._arg = arg;
    }

    public String getArg() {
        return this._arg;
    }

    public String getExcludeName() {
        return this._excludeName;
    }

    public static ProtocolExclusion lookup(String arg) {
        ProtocolExclusion ex = MAP.get(arg);
        if (ex == null) {
            throw new IllegalArgumentException(arg + " is not a valid protocol exclusion");
        }
        return ex;
    }

    static {
        MAP = new HashMap<String, ProtocolExclusion>();
        for (ProtocolExclusion pe : ProtocolExclusion.values()) {
            MAP.put(pe.getArg(), pe);
        }
    }
}

