/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.configuration.ExchangeConfigurationPlugin;
import org.apache.qpid.server.configuration.TopicConfig;
import org.apache.qpid.server.configuration.plugins.ConfigurationPlugin;
import org.apache.qpid.server.configuration.plugins.ConfigurationPluginFactory;
import org.apache.qpid.server.exchange.TopicExchange;
import org.apache.qpid.server.queue.AMQQueue;

public class TopicConfiguration
extends ConfigurationPlugin
implements ExchangeConfigurationPlugin {
    public static final ConfigurationPluginFactory FACTORY = new TopicConfigurationFactory();
    private static final String VIRTUALHOSTS_VIRTUALHOST_TOPICS = "virtualhosts.virtualhost.topics";
    private Map<String, TopicConfig> _topics = new HashMap<String, TopicConfig>();
    private Map<String, Map<String, TopicConfig>> _subscriptions = new HashMap<String, Map<String, TopicConfig>>();

    public String[] getElementsProcessed() {
        return new String[]{"topic"};
    }

    public void validateConfiguration() throws ConfigurationException {
        Configuration topicSubset;
        if (this.getConfig().isEmpty()) {
            throw new ConfigurationException("Topics section cannot be empty.");
        }
        int topics = this.getConfig().getList("topic.name").size() + this.getConfig().getList("topic.subscriptionName").size();
        for (int index = 0; index < topics && !(topicSubset = this.getConfig().subset("topic(" + index + ")")).isEmpty(); ++index) {
            TopicConfig topic = new TopicConfig();
            topic.setConfiguration("virtualhosts.virtualhost.topics.topic", topicSubset);
            String name = this.getConfig().getString("topic(" + index + ").name");
            String subscriptionName = this.getConfig().getString("topic(" + index + ").subscriptionName");
            if (subscriptionName != null) {
                this.processSubscription(subscriptionName, topic);
                continue;
            }
            if (name == null) continue;
            this.processTopic(name, topic);
        }
    }

    private void processTopic(String name, TopicConfig topic) throws ConfigurationException {
        if (this._topics.containsKey(name)) {
            throw new ConfigurationException("Topics section cannot contain two entries for the same topic.");
        }
        this._topics.put(name, topic);
    }

    private void processSubscription(String name, TopicConfig topic) throws ConfigurationException {
        Map<Object, Object> topics;
        if (this._subscriptions.containsKey(name)) {
            topics = this._subscriptions.get(name);
            if (topics.containsKey(topic.getName())) {
                throw new ConfigurationException("Subcription cannot contain two entries for the same topic.");
            }
        } else {
            topics = new HashMap<String, TopicConfig>();
        }
        topics.put(topic.getName(), topic);
        this._subscriptions.put(name, topics);
    }

    public String formatToString() {
        return "Topics:" + this._topics + ", Subscriptions:" + this._subscriptions;
    }

    public ConfigurationPlugin getConfiguration(AMQQueue queue) {
        String subscriptionName;
        TopicConfig config = new TopicConfig();
        config.addConfiguration(this);
        LinkedList<TopicConfig> boundToTopics = new LinkedList<TopicConfig>();
        for (Binding binding : queue.getBindings()) {
            TopicConfig topicConfig;
            if (!binding.getExchange().getType().equals(TopicExchange.TYPE) || (topicConfig = this.getTopicConfigForRoutingKey(binding.getBindingKey())) == null) continue;
            boundToTopics.add(topicConfig);
        }
        if (boundToTopics.size() == 1) {
            config.addConfiguration((ConfigurationPlugin)boundToTopics.get(0));
        }
        if (this._subscriptions.containsKey(subscriptionName = queue.getName())) {
            Map<String, TopicConfig> topics = this._subscriptions.get(subscriptionName);
            TopicConfig subscriptionSpecificConfig = null;
            for (Binding binding : queue.getBindings()) {
                if (!binding.getExchange().getType().equals(TopicExchange.TYPE) || subscriptionSpecificConfig != null) continue;
                subscriptionSpecificConfig = topics.get(binding.getBindingKey());
            }
            if (subscriptionSpecificConfig == null) {
                subscriptionSpecificConfig = topics.get("#");
            }
            if (subscriptionSpecificConfig != null) {
                config.addConfiguration(subscriptionSpecificConfig);
            }
        }
        return config;
    }

    private TopicConfig getTopicConfigForRoutingKey(String routingkey) {
        return this._topics.get(routingkey);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TopicConfigurationFactory
    implements ConfigurationPluginFactory {
        @Override
        public ConfigurationPlugin newInstance(String path, Configuration config) throws ConfigurationException {
            TopicConfiguration topicsConfig = new TopicConfiguration();
            topicsConfig.setConfiguration(path, config);
            return topicsConfig;
        }

        @Override
        public List<String> getParentPaths() {
            return Arrays.asList(TopicConfiguration.VIRTUALHOSTS_VIRTUALHOST_TOPICS);
        }
    }
}

