/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.BasicQosBody;
import org.apache.qpid.framing.BasicQosOkBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicQosHandler
implements StateAwareMethodListener<BasicQosBody> {
    private static final BasicQosHandler _instance = new BasicQosHandler();

    public static BasicQosHandler getInstance() {
        return _instance;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicQosBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.sync();
        channel.setCredit(body.getPrefetchSize(), body.getPrefetchCount());
        MethodRegistry methodRegistry = session.getMethodRegistry();
        BasicQosOkBody responseBody = methodRegistry.createBasicQosOkBody();
        session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
    }
}

