/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.AMQMessageReference;
import org.apache.qpid.server.message.AbstractServerMessageImpl;
import org.apache.qpid.server.message.MessageMetaData;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.store.StoredMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQMessage
extends AbstractServerMessageImpl<MessageMetaData> {
    private static final Logger _log = Logger.getLogger(AMQMessage.class);
    private static final byte IMMEDIATE = 1;
    private static final byte DELIVERED_TO_CONSUMER = 2;
    private byte _flags = 0;
    private long _expiration;
    private final long _size;
    private Object _connectionIdentifier;
    private static final byte IMMEDIATE_AND_DELIVERED = 3;

    public AMQMessage(StoredMessage<MessageMetaData> handle) {
        this(handle, null);
    }

    public AMQMessage(StoredMessage<MessageMetaData> handle, WeakReference<AMQChannel> channelRef) {
        super(handle);
        MessageMetaData metaData = handle.getMetaData();
        this._size = metaData.getContentSize();
        MessagePublishInfo messagePublishInfo = metaData.getMessagePublishInfo();
        if (messagePublishInfo.isImmediate()) {
            this._flags = (byte)(this._flags | 1);
        }
    }

    public void setExpiration(long expiration) {
        this._expiration = expiration;
    }

    public MessageMetaData getMessageMetaData() {
        return (MessageMetaData)this.getStoredMessage().getMetaData();
    }

    public ContentHeaderBody getContentHeaderBody() throws AMQException {
        return this.getMessageMetaData().getContentHeaderBody();
    }

    public Long getMessageId() {
        return this.getStoredMessage().getMessageNumber();
    }

    public boolean getDeliveredToConsumer() {
        return (this._flags & 2) != 0;
    }

    @Override
    public String getRoutingKey() {
        AMQShortString routingKey;
        MessageMetaData messageMetaData = this.getMessageMetaData();
        if (messageMetaData != null && (routingKey = messageMetaData.getMessagePublishInfo().getRoutingKey()) != null) {
            return routingKey.asString();
        }
        return null;
    }

    @Override
    public AMQMessageHeader getMessageHeader() {
        return this.getMessageMetaData().getMessageHeader();
    }

    @Override
    public boolean isPersistent() {
        return this.getMessageMetaData().isPersistent();
    }

    public boolean immediateAndNotDelivered() {
        return (this._flags & 3) == 1;
    }

    public MessagePublishInfo getMessagePublishInfo() throws AMQException {
        return this.getMessageMetaData().getMessagePublishInfo();
    }

    @Override
    public long getArrivalTime() {
        return this.getMessageMetaData().getArrivalTime();
    }

    public boolean expired(AMQQueue queue) throws AMQException {
        if (this._expiration != 0L) {
            long now = System.currentTimeMillis();
            return now > this._expiration;
        }
        return false;
    }

    public void setDeliveredToConsumer() {
        this._flags = (byte)(this._flags | 2);
    }

    @Override
    public long getSize() {
        return this._size;
    }

    @Override
    public boolean isImmediate() {
        return (this._flags & 1) == 1;
    }

    @Override
    public long getExpiration() {
        return this._expiration;
    }

    @Override
    public MessageReference newReference() {
        return new AMQMessageReference(this);
    }

    @Override
    public long getMessageNumber() {
        return this.getStoredMessage().getMessageNumber();
    }

    public Object getConnectionIdentifier() {
        return this._connectionIdentifier;
    }

    public void setConnectionIdentifier(Object connectionIdentifier) {
        this._connectionIdentifier = connectionIdentifier;
    }

    public String toString() {
        return "Message[" + this.debugIdentity() + "]: " + this.getMessageId() + "; ref count: " + this.getReferenceCount();
    }

    @Override
    public int getContent(ByteBuffer buf, int offset) {
        return this.getStoredMessage().getContent(offset, buf);
    }

    @Override
    public ByteBuffer getContent(int offset, int size) {
        return this.getStoredMessage().getContent(offset, size);
    }
}

