/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerMessageImpl<T extends StorableMessageMetaData>
implements ServerMessage<T> {
    private static final AtomicIntegerFieldUpdater<AbstractServerMessageImpl> _refCountUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractServerMessageImpl.class, "_referenceCount");
    private volatile int _referenceCount = 0;
    private final StoredMessage<T> _handle;

    public AbstractServerMessageImpl(StoredMessage<T> handle) {
        this._handle = handle;
    }

    @Override
    public StoredMessage<T> getStoredMessage() {
        return this._handle;
    }

    public boolean incrementReference() {
        return this.incrementReference(1);
    }

    public boolean incrementReference(int count) {
        if (_refCountUpdater.addAndGet(this, count) <= 0) {
            _refCountUpdater.addAndGet(this, -count);
            return false;
        }
        return true;
    }

    public void decrementReference() {
        int count = _refCountUpdater.decrementAndGet(this);
        if (count == 0) {
            _refCountUpdater.set(this, -1073741824);
            if (this._handle != null) {
                this._handle.remove();
            }
        } else if (count < 0) {
            throw new RuntimeException("Reference count for message id " + this.debugIdentity() + " has gone below 0.");
        }
    }

    public String debugIdentity() {
        return "(HC:" + System.identityHashCode(this) + " ID:" + this.getMessageNumber() + " Ref:" + this.getReferenceCount() + ")";
    }

    protected int getReferenceCount() {
        return this._referenceCount;
    }
}

