/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Publisher;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.User;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostAlias;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model {
    private static final Map<Class<? extends ConfiguredObject>, Collection<Class<? extends ConfiguredObject>>> PARENTS = new HashMap<Class<? extends ConfiguredObject>, Collection<Class<? extends ConfiguredObject>>>();
    private static final Map<Class<? extends ConfiguredObject>, Collection<Class<? extends ConfiguredObject>>> CHILDREN = new HashMap<Class<? extends ConfiguredObject>, Collection<Class<? extends ConfiguredObject>>>();

    static void addRelationship(Class<? extends ConfiguredObject> parent, Class<? extends ConfiguredObject> child) {
        Collection<Class<? extends ConfiguredObject>> parents = PARENTS.get(child);
        if (parents == null) {
            parents = new ArrayList<Class<? extends ConfiguredObject>>();
            PARENTS.put(child, parents);
        }
        parents.add(parent);
        Collection<Class<? extends ConfiguredObject>> children = CHILDREN.get(parent);
        if (children == null) {
            children = new ArrayList<Class<? extends ConfiguredObject>>();
            CHILDREN.put(parent, children);
        }
        children.add(child);
    }

    public static Collection<Class<? extends ConfiguredObject>> getParentTypes(Class<? extends ConfiguredObject> child) {
        Collection<Class<? extends ConfiguredObject>> parentTypes = PARENTS.get(child);
        return parentTypes == null ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(parentTypes);
    }

    public static Collection<Class<? extends ConfiguredObject>> getChildTypes(Class<? extends ConfiguredObject> parent) {
        Collection<Class<? extends ConfiguredObject>> childTypes = CHILDREN.get(parent);
        return childTypes == null ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(childTypes);
    }

    static {
        Model.addRelationship(Broker.class, VirtualHost.class);
        Model.addRelationship(Broker.class, Port.class);
        Model.addRelationship(Broker.class, AuthenticationProvider.class);
        Model.addRelationship(VirtualHost.class, Exchange.class);
        Model.addRelationship(VirtualHost.class, Queue.class);
        Model.addRelationship(VirtualHost.class, Connection.class);
        Model.addRelationship(VirtualHost.class, VirtualHostAlias.class);
        Model.addRelationship(AuthenticationProvider.class, User.class);
        Model.addRelationship(Connection.class, Session.class);
        Model.addRelationship(Exchange.class, Binding.class);
        Model.addRelationship(Exchange.class, Publisher.class);
        Model.addRelationship(Queue.class, Binding.class);
        Model.addRelationship(Queue.class, Consumer.class);
        Model.addRelationship(Session.class, Consumer.class);
        Model.addRelationship(Session.class, Publisher.class);
    }
}

