/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQStoreException;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectFinder;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.QueueNotificationListener;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.BindingAdapter;
import org.apache.qpid.server.model.adapter.ConsumerAdapter;
import org.apache.qpid.server.model.adapter.ExchangeAdapter;
import org.apache.qpid.server.model.adapter.VirtualHostAdapter;
import org.apache.qpid.server.queue.AMQPriorityQueue;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.ConflationQueue;
import org.apache.qpid.server.queue.NotificationCheck;
import org.apache.qpid.server.queue.QueueEntryVisitor;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.queue.SortedQueue;
import org.apache.qpid.server.subscription.Subscription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QueueAdapter
extends AbstractAdapter
implements Queue,
AMQQueue.SubscriptionRegistrationListener,
AMQQueue.NotificationListener {
    static final Map<String, String> ATTRIBUTE_MAPPINGS = new HashMap<String, String>();
    private final AMQQueue _queue;
    private final Map<org.apache.qpid.server.binding.Binding, BindingAdapter> _bindingAdapters = new HashMap<org.apache.qpid.server.binding.Binding, BindingAdapter>();
    private Map<Subscription, ConsumerAdapter> _consumerAdapters = new HashMap<Subscription, ConsumerAdapter>();
    private final VirtualHostAdapter _vhost;
    private QueueStatisticsAdapter _statistics;
    private QueueNotificationListener _queueNotificationListener;

    public QueueAdapter(VirtualHostAdapter virtualHostAdapter, AMQQueue queue) {
        super(queue.getId());
        this._vhost = virtualHostAdapter;
        this.addParent(VirtualHost.class, virtualHostAdapter);
        this._queue = queue;
        this._queue.addSubscriptionRegistrationListener(this);
        this.populateConsumers();
        this._statistics = new QueueStatisticsAdapter(queue);
        this._queue.setNotificationListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateConsumers() {
        Collection<Subscription> actualSubscriptions = this._queue.getConsumers();
        Map<Subscription, ConsumerAdapter> map = this._consumerAdapters;
        synchronized (map) {
            Iterator<Subscription> iter = this._consumerAdapters.keySet().iterator();
            for (Subscription subscription : actualSubscriptions) {
                if (this._consumerAdapters.containsKey(subscription)) continue;
                this._consumerAdapters.put(subscription, new ConsumerAdapter(this, subscription));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Binding> getBindings() {
        Map<org.apache.qpid.server.binding.Binding, BindingAdapter> map = this._bindingAdapters;
        synchronized (map) {
            return new ArrayList<Binding>(this._bindingAdapters.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Consumer> getConsumers() {
        Map<Subscription, ConsumerAdapter> map = this._consumerAdapters;
        synchronized (map) {
            return new ArrayList<Consumer>(this._consumerAdapters.values());
        }
    }

    @Override
    public void visit(QueueEntryVisitor visitor) {
        this._queue.visit(visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        try {
            QueueRegistry queueRegistry;
            QueueRegistry queueRegistry2 = queueRegistry = this._queue.getVirtualHost().getQueueRegistry();
            synchronized (queueRegistry2) {
                this._queue.delete();
                if (this._queue.isDurable()) {
                    this._queue.getVirtualHost().getMessageStore().removeQueue(this._queue);
                }
            }
        }
        catch (AMQException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getName() {
        return this._queue.getName();
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        return null;
    }

    @Override
    public State getActualState() {
        return null;
    }

    @Override
    public boolean isDurable() {
        return this._queue.isDurable();
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return this._queue.isAutoDelete() ? LifetimePolicy.AUTO_DELETE : LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return null;
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return 0L;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return Queue.AVAILABLE_ATTRIBUTES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        try {
            if ("alertRepeatGap".equals(name)) {
                this._queue.setMinimumAlertRepeatGap((Long)desired);
                Object object = desired;
                return object;
            }
            if ("alertThresholdMessageAge".equals(name)) {
                this._queue.setMaximumMessageAge((Long)desired);
                Object object = desired;
                return object;
            }
            if ("alertThresholdMessageSize".equals(name)) {
                this._queue.setMaximumMessageSize((Long)desired);
                Object object = desired;
                return object;
            }
            if ("alertThresholdQueueDepthBytes".equals(name)) {
                this._queue.setMaximumQueueDepth((Long)desired);
                Object object = desired;
                return object;
            }
            if ("alertThresholdQueueDepthMessages".equals(name)) {
                this._queue.setMaximumMessageCount((Long)desired);
                Object object = desired;
                return object;
            }
            if ("alternateExchange".equals(name)) {
                ExchangeAdapter alternateExchange = (ExchangeAdapter)desired;
                this._queue.setAlternateExchange(alternateExchange == null ? null : alternateExchange.getExchange());
                Object e = desired;
                return e;
            }
            if ("exclusive".equals(name)) {
                Boolean exclusiveFlag = (Boolean)desired;
                this._queue.setExclusive(exclusiveFlag);
                Object e = desired;
                return e;
            }
            if (!("messageGroupKey".equals(name) || "messageGroupDefaultGroup".equals(name) || "messageGroupSharedGroups".equals(name) || "lvqKey".equals(name))) {
                if ("maximumDeliveryAttempts".equals(name)) {
                    this._queue.setMaximumDeliveryCount((Integer)desired);
                    Object object = desired;
                    return object;
                }
                if (!"noLocal".equals(name) && !"owner".equals(name)) {
                    if ("queueFlowControlSizeBytes".equals(name)) {
                        this._queue.setCapacity((Long)desired);
                        Object object = desired;
                        return object;
                    }
                    if ("queueFlowResumeSizeBytes".equals(name)) {
                        this._queue.setFlowResumeCapacity((Long)desired);
                        Object object = desired;
                        return object;
                    }
                    if (!"queueFlowStopped".equals(name) && !"sortKey".equals(name) && !"type".equals(name) && "description".equals(name)) {
                        this._queue.setDescription((String)desired);
                        Object object = desired;
                        return object;
                    }
                }
            }
            Object object = super.setAttribute(name, expected, desired);
            return object;
        }
        finally {
            if (this._queue.isDurable()) {
                try {
                    this._queue.getVirtualHost().getMessageStore().updateQueue(this._queue);
                }
                catch (AMQStoreException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    @Override
    public Object getAttribute(String name) {
        if ("alertRepeatGap".equals(name)) {
            return this._queue.getMinimumAlertRepeatGap();
        }
        if ("alertThresholdMessageAge".equals(name)) {
            return this._queue.getMaximumMessageAge();
        }
        if ("alertThresholdMessageSize".equals(name)) {
            return this._queue.getMaximumMessageSize();
        }
        if ("alertThresholdQueueDepthBytes".equals(name)) {
            return this._queue.getMaximumQueueDepth();
        }
        if ("alertThresholdQueueDepthMessages".equals(name)) {
            return this._queue.getMaximumMessageCount();
        }
        if ("alternateExchange".equals(name)) {
            org.apache.qpid.server.exchange.Exchange alternateExchange = this._queue.getAlternateExchange();
            return alternateExchange == null ? null : ConfiguredObjectFinder.findConfiguredObjectByName(this._vhost.getExchanges(), alternateExchange.getName());
        }
        if ("exclusive".equals(name)) {
            return this._queue.isExclusive();
        }
        if (!("messageGroupKey".equals(name) || "messageGroupDefaultGroup".equals(name) || "messageGroupSharedGroups".equals(name))) {
            if ("lvqKey".equals(name)) {
                if (this._queue instanceof ConflationQueue) {
                    return ((ConflationQueue)this._queue).getConflationKey();
                }
            } else {
                if ("maximumDeliveryAttempts".equals(name)) {
                    return this._queue.getMaximumDeliveryCount();
                }
                if (!"noLocal".equals(name)) {
                    if ("owner".equals(name)) {
                        return this._queue.getOwner() == null ? null : this._queue.getOwner().asString();
                    }
                    if ("queueFlowControlSizeBytes".equals(name)) {
                        return this._queue.getCapacity();
                    }
                    if ("queueFlowResumeSizeBytes".equals(name)) {
                        return this._queue.getFlowResumeCapacity();
                    }
                    if ("queueFlowStopped".equals(name)) {
                        return this._queue.isOverfull();
                    }
                    if ("sortKey".equals(name)) {
                        if (this._queue instanceof SortedQueue) {
                            return ((SortedQueue)this._queue).getSortedPropertyName();
                        }
                    } else {
                        if ("type".equals(name)) {
                            if (this._queue instanceof SortedQueue) {
                                return "sorted";
                            }
                            if (this._queue instanceof ConflationQueue) {
                                return "lvq";
                            }
                            if (this._queue instanceof AMQPriorityQueue) {
                                return "priority";
                            }
                            return "standard";
                        }
                        if (!"created".equals(name)) {
                            if ("durable".equals(name)) {
                                return this._queue.isDurable();
                            }
                            if ("id".equals(name)) {
                                return this.getId();
                            }
                            if ("lifetimePolicy".equals(name)) {
                                return this._queue.isAutoDelete() ? LifetimePolicy.AUTO_DELETE : LifetimePolicy.PERMANENT;
                            }
                            if ("name".equals(name)) {
                                return this._queue.getName();
                            }
                            if ("state".equals(name)) {
                                return State.ACTIVE;
                            }
                            if (!"timeToLive".equals(name) && !"updated".equals(name)) {
                                if ("description".equals(name)) {
                                    return this._queue.getDescription();
                                }
                                if ("priorities".equals(name) && this._queue instanceof AMQPriorityQueue) {
                                    return ((AMQPriorityQueue)this._queue).getPriorities();
                                }
                            }
                        }
                    }
                }
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public Statistics getStatistics() {
        return this._statistics;
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == Consumer.class) {
            return this.getConsumers();
        }
        if (clazz == Binding.class) {
            return this.getBindings();
        }
        return Collections.emptySet();
    }

    public Binding createBinding(Exchange exchange, Map<String, Object> attributes) throws AccessControlException, IllegalStateException {
        attributes = new HashMap<String, Object>(attributes);
        String bindingKey = QueueAdapter.getStringAttribute("name", attributes, "");
        Map bindingArgs = QueueAdapter.getMapAttribute("arguments", attributes, Collections.EMPTY_MAP);
        attributes.remove("name");
        attributes.remove("arguments");
        return exchange.createBinding(bindingKey, this, bindingArgs, attributes);
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == Binding.class) {
            if (otherParents != null && otherParents.length == 1 && otherParents[0] instanceof Exchange) {
                Exchange exchange = (Exchange)otherParents[0];
                if (exchange.getParent(VirtualHost.class) == this.getParent(VirtualHost.class)) {
                    return (C)this.createBinding(exchange, attributes);
                }
                throw new IllegalArgumentException("Queue and Exchange parents of a binding must be on same virtual host");
            }
            throw new IllegalArgumentException("Other parent must be an exchange");
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindingRegistered(org.apache.qpid.server.binding.Binding binding, BindingAdapter adapter) {
        Map<org.apache.qpid.server.binding.Binding, BindingAdapter> map = this._bindingAdapters;
        synchronized (map) {
            this._bindingAdapters.put(binding, adapter);
        }
        this.childAdded(adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindingUnregistered(org.apache.qpid.server.binding.Binding binding) {
        BindingAdapter adapter = null;
        Map<org.apache.qpid.server.binding.Binding, BindingAdapter> map = this._bindingAdapters;
        synchronized (map) {
            adapter = this._bindingAdapters.remove(binding);
        }
        if (adapter != null) {
            this.childRemoved(adapter);
        }
    }

    AMQQueue getAMQQueue() {
        return this._queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscriptionRegistered(AMQQueue queue, Subscription subscription) {
        ConsumerAdapter adapter = null;
        Map<Subscription, ConsumerAdapter> map = this._consumerAdapters;
        synchronized (map) {
            if (!this._consumerAdapters.containsKey(subscription)) {
                adapter = new ConsumerAdapter(this, subscription);
                this._consumerAdapters.put(subscription, adapter);
            }
        }
        if (adapter != null) {
            this.childAdded(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscriptionUnregistered(AMQQueue queue, Subscription subscription) {
        ConsumerAdapter adapter = null;
        Map<Subscription, ConsumerAdapter> map = this._consumerAdapters;
        synchronized (map) {
            adapter = this._consumerAdapters.remove(subscription);
        }
        if (adapter != null) {
            this.childRemoved(adapter);
        }
    }

    VirtualHostAdapter getVirtualHost() {
        return this._vhost;
    }

    @Override
    public void setNotificationListener(QueueNotificationListener listener) {
        this._queueNotificationListener = listener;
    }

    @Override
    public void notifyClients(NotificationCheck notification, AMQQueue queue, String notificationMsg) {
        QueueNotificationListener listener = this._queueNotificationListener;
        if (listener != null) {
            listener.notifyClients(notification, this, notificationMsg);
        }
    }

    @Override
    public State setDesiredState(State currentState, State desiredState) throws IllegalStateTransitionException, AccessControlException {
        if (desiredState == State.DELETED) {
            this.delete();
            return State.DELETED;
        }
        return super.setDesiredState(currentState, desiredState);
    }

    static {
        ATTRIBUTE_MAPPINGS.put("alertRepeatGap", "x-qpid-minimum-alert-repeat-gap");
        ATTRIBUTE_MAPPINGS.put("alertThresholdMessageAge", "x-qpid-maximum-message-age");
        ATTRIBUTE_MAPPINGS.put("alertThresholdMessageSize", "x-qpid-maximum-message-size");
        ATTRIBUTE_MAPPINGS.put("alertThresholdQueueDepthMessages", "x-qpid-maximum-message-count");
        ATTRIBUTE_MAPPINGS.put("maximumDeliveryAttempts", "x-qpid-maximum-delivery-count");
        ATTRIBUTE_MAPPINGS.put("queueFlowControlSizeBytes", "x-qpid-capacity");
        ATTRIBUTE_MAPPINGS.put("queueFlowResumeSizeBytes", "x-qpid-flow-resume-capacity");
        ATTRIBUTE_MAPPINGS.put("sortKey", "qpid.queue_sort_key");
        ATTRIBUTE_MAPPINGS.put("lvqKey", "qpid.last_value_queue_key");
        ATTRIBUTE_MAPPINGS.put("priorities", "x-qpid-priorities");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueueStatisticsAdapter
    implements Statistics {
        private final AMQQueue _queue;

        public QueueStatisticsAdapter(AMQQueue queue) {
            this._queue = queue;
        }

        @Override
        public Collection<String> getStatisticNames() {
            return Queue.AVAILABLE_STATISTICS;
        }

        @Override
        public Object getStatistic(String name) {
            if ("bindingCount".equals(name)) {
                return this._queue.getBindingCount();
            }
            if ("consumerCount".equals(name)) {
                return this._queue.getConsumerCount();
            }
            if ("consumerCountWithCredit".equals(name)) {
                return this._queue.getActiveConsumerCount();
            }
            if ("discardsTtlBytes".equals(name)) {
                return null;
            }
            if ("discardsTtlMessages".equals(name)) {
                return null;
            }
            if ("persistentDequeuedBytes".equals(name)) {
                return this._queue.getPersistentByteDequeues();
            }
            if ("persistentDequeuedMessages".equals(name)) {
                return this._queue.getPersistentMsgDequeues();
            }
            if ("persistentEnqueuedBytes".equals(name)) {
                return this._queue.getPersistentByteEnqueues();
            }
            if ("persistentEnqueuedMessages".equals(name)) {
                return this._queue.getPersistentMsgEnqueues();
            }
            if ("queueDepthBytes".equals(name)) {
                return this._queue.getQueueDepth();
            }
            if ("queueDepthMessages".equals(name)) {
                return this._queue.getMessageCount();
            }
            if ("stateChanged".equals(name)) {
                return null;
            }
            if ("totalDequeuedBytes".equals(name)) {
                return this._queue.getTotalDequeueSize();
            }
            if ("totalDequeuedMessages".equals(name)) {
                return this._queue.getTotalDequeueCount();
            }
            if ("totalEnqueuedBytes".equals(name)) {
                return this._queue.getTotalEnqueueSize();
            }
            if ("totalEnqueuedMessages".equals(name)) {
                return this._queue.getTotalEnqueueCount();
            }
            if ("unacknowledgedBytes".equals(name)) {
                return this._queue.getUnackedMessageBytes();
            }
            if ("unacknowledgedMessages".equals(name)) {
                return this._queue.getUnackedMessageCount();
            }
            return null;
        }
    }
}

