/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.model.AuthenticationMethod;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.NoStatistics;
import org.apache.qpid.server.model.adapter.VirtualHostAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualHostAliasAdapter
extends AbstractAdapter
implements VirtualHostAlias {
    private VirtualHostAdapter _vhost;
    private Port _port;

    public VirtualHostAliasAdapter(VirtualHostAdapter virtualHostAdapter, Port port) {
        super(UUIDGenerator.generateVhostAliasUUID(virtualHostAdapter.getName(), port.getName()));
        this._vhost = virtualHostAdapter;
        this._port = port;
    }

    @Override
    public Port getPort() {
        return this._port;
    }

    @Override
    public VirtualHost getVirtualHost() {
        return this._vhost;
    }

    @Override
    public Collection<AuthenticationMethod> getAuthenticationMethods() {
        return Collections.emptySet();
    }

    @Override
    public String getName() {
        return this._vhost.getName();
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        throw new IllegalStateException();
    }

    @Override
    public State getActualState() {
        return State.ACTIVE;
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Statistics getStatistics() {
        return NoStatistics.getInstance();
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        return Collections.emptySet();
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        throw new UnsupportedOperationException();
    }
}

