/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.output;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.AMQPInvalidClassException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.message.MessageTransferMessage;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageDeliveryMode;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.ReplyTo;

public class HeaderPropertiesConverter {
    private HeaderPropertiesConverter() {
    }

    public static BasicContentHeaderProperties convert(MessageTransferMessage messageTransferMessage, VirtualHost vhost) {
        BasicContentHeaderProperties props = new BasicContentHeaderProperties();
        Header header = messageTransferMessage.getHeader();
        DeliveryProperties deliveryProps = header.getDeliveryProperties();
        MessageProperties messageProps = header.getMessageProperties();
        if (deliveryProps != null) {
            if (deliveryProps.hasDeliveryMode()) {
                props.setDeliveryMode((byte)(deliveryProps.getDeliveryMode() == MessageDeliveryMode.PERSISTENT ? 2 : 1));
            }
            if (deliveryProps.hasExpiration()) {
                props.setExpiration(deliveryProps.getExpiration());
            }
            if (deliveryProps.hasPriority()) {
                props.setPriority((byte)deliveryProps.getPriority().getValue());
            }
            if (deliveryProps.hasTimestamp()) {
                props.setTimestamp(deliveryProps.getTimestamp());
            }
        }
        if (messageProps != null) {
            if (messageProps.hasAppId()) {
                props.setAppId(new AMQShortString(messageProps.getAppId()));
            }
            if (messageProps.hasContentType()) {
                props.setContentType(messageProps.getContentType());
            }
            if (messageProps.hasCorrelationId()) {
                props.setCorrelationId(new AMQShortString(messageProps.getCorrelationId()));
            }
            if (messageProps.hasContentEncoding()) {
                props.setEncoding(messageProps.getContentEncoding());
            }
            if (messageProps.hasMessageId()) {
                props.setMessageId("ID:" + messageProps.getMessageId().toString());
            }
            if (messageProps.hasReplyTo()) {
                Exchange exchange;
                ReplyTo replyTo = messageProps.getReplyTo();
                String exchangeName = replyTo.getExchange();
                String routingKey = replyTo.getRoutingKey();
                if (exchangeName == null) {
                    exchangeName = "";
                }
                String exchangeClass = (exchange = vhost.getExchangeRegistry().getExchange(exchangeName)) == null ? ExchangeDefaults.DIRECT_EXCHANGE_CLASS.asString() : exchange.getType().getName().asString();
                props.setReplyTo(exchangeClass + "://" + exchangeName + "//?routingkey='" + (routingKey == null ? "" : routingKey + "'"));
            }
            if (messageProps.hasUserId()) {
                props.setUserId(new AMQShortString(messageProps.getUserId()));
            }
            if (messageProps.hasApplicationHeaders()) {
                HashMap appHeaders = new HashMap(messageProps.getApplicationHeaders());
                if (messageProps.getApplicationHeaders().containsKey("x-jms-type")) {
                    props.setType(String.valueOf(appHeaders.remove("x-jms-type")));
                }
                FieldTable ft = new FieldTable();
                for (Map.Entry entry : appHeaders.entrySet()) {
                    try {
                        ft.put(new AMQShortString((String)entry.getKey()), entry.getValue());
                    }
                    catch (AMQPInvalidClassException e) {}
                }
                props.setHeaders(ft);
            }
        }
        return props;
    }
}

