/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultQueueRegistry
implements QueueRegistry {
    private ConcurrentMap<AMQShortString, AMQQueue> _queueMap = new ConcurrentHashMap<AMQShortString, AMQQueue>();
    private final VirtualHost _virtualHost;
    private final Collection<QueueRegistry.RegistryChangeListener> _listeners = new ArrayList<QueueRegistry.RegistryChangeListener>();

    public DefaultQueueRegistry(VirtualHost virtualHost) {
        this._virtualHost = virtualHost;
    }

    @Override
    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerQueue(AMQQueue queue) {
        this._queueMap.put(queue.getNameShortString(), queue);
        Collection<QueueRegistry.RegistryChangeListener> collection = this._listeners;
        synchronized (collection) {
            for (QueueRegistry.RegistryChangeListener listener : this._listeners) {
                listener.queueRegistered(queue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterQueue(AMQShortString name) {
        AMQQueue q = (AMQQueue)this._queueMap.remove(name);
        if (q != null) {
            Collection<QueueRegistry.RegistryChangeListener> collection = this._listeners;
            synchronized (collection) {
                for (QueueRegistry.RegistryChangeListener listener : this._listeners) {
                    listener.queueUnregistered(q);
                }
            }
        }
    }

    @Override
    public AMQQueue getQueue(AMQShortString name) {
        return (AMQQueue)this._queueMap.get(name);
    }

    @Override
    public Collection<AMQShortString> getQueueNames() {
        return this._queueMap.keySet();
    }

    @Override
    public Collection<AMQQueue> getQueues() {
        return this._queueMap.values();
    }

    @Override
    public AMQQueue getQueue(String queue) {
        return this.getQueue(new AMQShortString(queue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegistryChangeListener(QueueRegistry.RegistryChangeListener listener) {
        Collection<QueueRegistry.RegistryChangeListener> collection = this._listeners;
        synchronized (collection) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAllAndUnregisterMBeans() {
        for (AMQQueue queue : this.getQueues()) {
            queue.stop();
            Collection<QueueRegistry.RegistryChangeListener> collection = this._listeners;
            synchronized (collection) {
                for (QueueRegistry.RegistryChangeListener listener : this._listeners) {
                    listener.queueUnregistered(queue);
                }
            }
        }
        this._queueMap.clear();
    }

    @Override
    public synchronized AMQQueue getQueue(UUID queueId) {
        Collection queues = this._queueMap.values();
        for (AMQQueue queue : queues) {
            if (!queue.getId().equals(queueId)) continue;
            return queue;
        }
        return null;
    }
}

