/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.server.configuration.plugins.ConfigurationPlugin;
import org.apache.qpid.server.configuration.plugins.ConfigurationPluginFactory;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationManagerPluginFactory;
import org.apache.qpid.server.security.auth.sasl.external.ExternalSaslServer;

public class ExternalAuthenticationManager
implements AuthenticationManager {
    private static final Logger _logger = Logger.getLogger(ExternalAuthenticationManager.class);
    private static final String EXTERNAL = "EXTERNAL";
    static final ExternalAuthenticationManager INSTANCE = new ExternalAuthenticationManager();
    public static final AuthenticationManagerPluginFactory<ExternalAuthenticationManager> FACTORY = new AuthenticationManagerPluginFactory<ExternalAuthenticationManager>(){

        @Override
        public ExternalAuthenticationManager newInstance(ConfigurationPlugin config) throws ConfigurationException {
            ExternalAuthenticationManagerConfiguration configuration;
            ExternalAuthenticationManagerConfiguration externalAuthenticationManagerConfiguration = configuration = config == null ? null : (ExternalAuthenticationManagerConfiguration)config.getConfiguration(ExternalAuthenticationManagerConfiguration.class.getName());
            if (configuration == null) {
                _logger.info((Object)"No authentication-manager configuration found for ExternalAuthenticationManager");
                return null;
            }
            return INSTANCE;
        }

        @Override
        public Class<ExternalAuthenticationManager> getPluginClass() {
            return ExternalAuthenticationManager.class;
        }

        @Override
        public String getPluginName() {
            return ExternalAuthenticationManager.class.getName();
        }
    };

    private ExternalAuthenticationManager() {
    }

    public void initialise() {
    }

    public String getMechanisms() {
        return EXTERNAL;
    }

    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if (EXTERNAL.equals(mechanism)) {
            return new ExternalSaslServer(externalPrincipal);
        }
        throw new SaslException("Unknown mechanism: " + mechanism);
    }

    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            Principal principal = ((ExternalSaslServer)server).getAuthenticatedPrincipal();
            if (principal != null) {
                Subject subject = new Subject();
                subject.getPrincipals().add(principal);
                return new AuthenticationResult(subject);
            }
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    public AuthenticationResult authenticate(String username, String password) {
        return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
    }

    public void close() {
    }

    public void configure(ConfigurationPlugin config) throws ConfigurationException {
    }

    public static class ExternalAuthenticationManagerConfiguration
    extends ConfigurationPlugin {
        public static final ConfigurationPluginFactory FACTORY = new ConfigurationPluginFactory(){

            @Override
            public List<String> getParentPaths() {
                return Arrays.asList("security.external-auth-manager");
            }

            @Override
            public ConfigurationPlugin newInstance(String path, Configuration config) throws ConfigurationException {
                ExternalAuthenticationManagerConfiguration instance = new ExternalAuthenticationManagerConfiguration();
                instance.setConfiguration(path, config);
                return instance;
            }
        };

        public String[] getElementsProcessed() {
            return new String[0];
        }

        public void validateConfiguration() throws ConfigurationException {
        }
    }
}

