/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.nio.ByteBuffer;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.StoredMessage;

public class StoredMemoryMessage
implements StoredMessage {
    private final long _messageNumber;
    private ByteBuffer _content;
    private final StorableMessageMetaData _metaData;

    public StoredMemoryMessage(long messageNumber, StorableMessageMetaData metaData) {
        this._messageNumber = messageNumber;
        this._metaData = metaData;
    }

    public long getMessageNumber() {
        return this._messageNumber;
    }

    public void addContent(int offsetInMessage, ByteBuffer src) {
        if (this._content == null) {
            if (offsetInMessage == 0) {
                this._content = src.slice();
            } else {
                int contentSize = this._metaData.getContentSize();
                int size = contentSize < offsetInMessage + src.remaining() ? offsetInMessage + src.remaining() : contentSize;
                this._content = ByteBuffer.allocate(size);
                this.addContent(offsetInMessage, src);
            }
        } else if (this._content.limit() >= offsetInMessage + src.remaining()) {
            this._content.position(offsetInMessage);
            this._content.put(src);
            this._content.position(0);
        } else {
            int contentSize = this._metaData.getContentSize();
            int size = contentSize < offsetInMessage + src.remaining() ? offsetInMessage + src.remaining() : contentSize;
            ByteBuffer oldContent = this._content;
            this._content = ByteBuffer.allocate(size);
            this._content.put(oldContent);
            this._content.position(0);
            this.addContent(offsetInMessage, src);
        }
    }

    public int getContent(int offset, ByteBuffer dst) {
        if (this._content == null) {
            return 0;
        }
        ByteBuffer src = this._content.duplicate();
        int oldPosition = src.position();
        src.position(oldPosition + offset);
        int length = dst.remaining() < src.remaining() ? dst.remaining() : src.remaining();
        src.limit(oldPosition + length);
        dst.put(src);
        return length;
    }

    public ByteBuffer getContent(int offsetInMessage, int size) {
        if (this._content == null) {
            return null;
        }
        ByteBuffer buf = this._content.duplicate();
        if (offsetInMessage != 0) {
            buf.position(offsetInMessage);
            buf = buf.slice();
        }
        buf.limit(size);
        return buf;
    }

    public StoreFuture flushToStore() {
        return StoreFuture.IMMEDIATE_FUTURE;
    }

    public StorableMessageMetaData getMetaData() {
        return this._metaData;
    }

    public void remove() {
    }
}

