/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.subscription;

import org.apache.qpid.AMQException;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueEntry;

public interface Subscription {
    public LogActor getLogActor();

    public boolean isTransient();

    public long getBytesOut();

    public long getMessagesOut();

    public long getUnacknowledgedBytes();

    public long getUnacknowledgedMessages();

    public AMQQueue getQueue();

    public AMQSessionModel getSessionModel();

    public QueueEntry.SubscriptionAcquiredState getOwningState();

    public QueueEntry.SubscriptionAssignedState getAssignedState();

    public void setQueue(AMQQueue var1, boolean var2);

    public void setNoLocal(boolean var1);

    public long getSubscriptionID();

    public boolean isSuspended();

    public boolean hasInterest(QueueEntry var1);

    public boolean isClosed();

    public boolean acquires();

    public boolean seesRequeues();

    public void close();

    public void send(QueueEntry var1, boolean var2) throws AMQException;

    public void flushBatched();

    public void queueDeleted(AMQQueue var1);

    public boolean wouldSuspend(QueueEntry var1);

    public boolean trySendLock();

    public void getSendLock();

    public void releaseSendLock();

    public void releaseQueueEntry(QueueEntry var1);

    public void onDequeue(QueueEntry var1);

    public void restoreCredit(QueueEntry var1);

    public void setStateListener(StateListener var1);

    public State getState();

    public AMQQueue.Context getQueueContext();

    public void setQueueContext(AMQQueue.Context var1);

    public boolean isActive();

    public void set(String var1, Object var2);

    public Object get(String var1);

    public boolean isSessionTransactional();

    public void queueEmpty() throws AMQException;

    public String getConsumerName();

    public static interface StateListener {
        public void stateChange(Subscription var1, State var2, State var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ACTIVE,
        SUSPENDED,
        CLOSED;

    }
}

