/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.subscription;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.subscription.Subscription;

public class SubscriptionList {
    private final SubscriptionNode _head = new SubscriptionNode();
    private final AtomicReference<SubscriptionNode> _tail = new AtomicReference<SubscriptionNode>(this._head);
    private final AtomicReference<SubscriptionNode> _subNodeMarker = new AtomicReference<SubscriptionNode>(this._head);
    private final AtomicInteger _size = new AtomicInteger();

    private void insert(SubscriptionNode node, boolean count) {
        while (true) {
            SubscriptionNode tail = this._tail.get();
            SubscriptionNode next = tail.nextNode();
            if (tail != this._tail.get()) continue;
            if (next == null) {
                if (!tail.setNext(node)) continue;
                this._tail.compareAndSet(tail, node);
                if (count) {
                    this._size.incrementAndGet();
                }
                return;
            }
            this._tail.compareAndSet(tail, next);
        }
    }

    public void add(Subscription sub) {
        SubscriptionNode node = new SubscriptionNode(sub);
        this.insert(node, true);
    }

    public boolean remove(Subscription sub) {
        SubscriptionNode prevNode = this._head;
        for (SubscriptionNode node = this._head.nextNode(); node != null; node = node.findNext()) {
            if (sub.equals(node.getSubscription()) && node.delete()) {
                this._size.decrementAndGet();
                SubscriptionNode tail = this._tail.get();
                if (node == tail) {
                    this.insert(new SubscriptionNode(), false);
                }
                prevNode.findNext();
                this.nodeMarkerCleanup(node);
                return true;
            }
            prevNode = node;
        }
        return false;
    }

    private void nodeMarkerCleanup(SubscriptionNode node) {
        SubscriptionNode markedNode = this._subNodeMarker.get();
        if (node == markedNode) {
            SubscriptionNode dummy = new SubscriptionNode();
            dummy.setNext(markedNode.nextNode());
            this._subNodeMarker.compareAndSet(markedNode, dummy);
        } else if (markedNode != null && markedNode != this._head && markedNode.isDeleted()) {
            markedNode.findNext();
        }
    }

    public boolean updateMarkedNode(SubscriptionNode expected, SubscriptionNode nextNode) {
        return this._subNodeMarker.compareAndSet(expected, nextNode);
    }

    public SubscriptionNode getMarkedNode() {
        return this._subNodeMarker.get();
    }

    public SubscriptionNodeIterator iterator() {
        return new SubscriptionNodeIterator(this._head);
    }

    public SubscriptionNode getHead() {
        return this._head;
    }

    public int size() {
        return this._size.get();
    }

    public static class SubscriptionNodeIterator {
        private SubscriptionNode _lastNode;

        SubscriptionNodeIterator(SubscriptionNode startNode) {
            this._lastNode = startNode;
        }

        public SubscriptionNode getNode() {
            return this._lastNode;
        }

        public boolean advance() {
            SubscriptionNode nextNode;
            this._lastNode = nextNode = this._lastNode.findNext();
            return this._lastNode != null;
        }
    }

    public static final class SubscriptionNode {
        private final AtomicBoolean _deleted = new AtomicBoolean();
        private final AtomicReference<SubscriptionNode> _next = new AtomicReference();
        private final Subscription _sub;

        public SubscriptionNode() {
            this._sub = null;
            this._deleted.set(true);
        }

        public SubscriptionNode(Subscription sub) {
            this._sub = sub;
        }

        public SubscriptionNode findNext() {
            SubscriptionNode next = this.nextNode();
            while (next != null && next.isDeleted()) {
                SubscriptionNode newNext = next.nextNode();
                if (newNext != null) {
                    this._next.compareAndSet(next, newNext);
                    next = this.nextNode();
                    continue;
                }
                next = null;
            }
            return next;
        }

        protected SubscriptionNode nextNode() {
            return this._next.get();
        }

        private boolean setNext(SubscriptionNode node) {
            return this._next.compareAndSet(null, node);
        }

        public boolean isDeleted() {
            return this._deleted.get();
        }

        public boolean delete() {
            return this._deleted.compareAndSet(false, true);
        }

        public Subscription getSubscription() {
            return this._sub;
        }
    }
}

