/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.txn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTransaction
implements ServerTransaction {
    protected static final Logger _logger = LoggerFactory.getLogger(LocalTransaction.class);
    private final List<ServerTransaction.Action> _postTransactionActions = new ArrayList<ServerTransaction.Action>();
    private volatile Transaction _transaction;
    private MessageStore _transactionLog;
    private long _txnStartTime = 0L;

    public LocalTransaction(MessageStore transactionLog) {
        this._transactionLog = transactionLog;
    }

    public boolean inTransaction() {
        return this._transaction != null;
    }

    @Override
    public long getTransactionStartTime() {
        return this._txnStartTime;
    }

    @Override
    public void addPostTransactionAction(ServerTransaction.Action postTransactionAction) {
        this._postTransactionActions.add(postTransactionAction);
    }

    @Override
    public void dequeue(BaseQueue queue, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        this._postTransactionActions.add(postTransactionAction);
        if (message.isPersistent() && queue.isDurable()) {
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Dequeue of message number " + message.getMessageNumber() + " from transaction log. Queue : " + queue.getNameShortString());
                }
                this.beginTranIfNecessary();
                this._transaction.dequeueMessage(queue, message);
            }
            catch (AMQException e) {
                _logger.error("Error during message dequeues", (Throwable)e);
                this.tidyUpOnError((Exception)((Object)e));
            }
        }
    }

    @Override
    public void dequeue(Collection<QueueEntry> queueEntries, ServerTransaction.Action postTransactionAction) {
        this._postTransactionActions.add(postTransactionAction);
        try {
            for (QueueEntry entry : queueEntries) {
                ServerMessage message = entry.getMessage();
                AMQQueue queue = entry.getQueue();
                if (!message.isPersistent() || !queue.isDurable()) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Dequeue of message number " + message.getMessageNumber() + " from transaction log. Queue : " + queue.getNameShortString());
                }
                this.beginTranIfNecessary();
                this._transaction.dequeueMessage(queue, message);
            }
        }
        catch (AMQException e) {
            _logger.error("Error during message dequeues", (Throwable)e);
            this.tidyUpOnError((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tidyUpOnError(Exception e) {
        try {
            for (ServerTransaction.Action action : this._postTransactionActions) {
                action.onRollback();
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                block10: {
                    try {
                        if (this._transaction == null) break block10;
                        this._transaction.abortTran();
                    }
                    catch (Exception abortException) {
                        _logger.error("Abort transaction failed while trying to handle previous error", (Throwable)abortException);
                        Object var8_10 = null;
                        this.resetDetails();
                    }
                }
                Object var8_9 = null;
                this.resetDetails();
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                this.resetDetails();
                throw throwable2;
            }
            throw throwable;
        }
        try {
            block9: {
                try {
                    if (this._transaction == null) break block9;
                    this._transaction.abortTran();
                }
                catch (Exception abortException) {
                    _logger.error("Abort transaction failed while trying to handle previous error", (Throwable)abortException);
                    Object var8_7 = null;
                    this.resetDetails();
                }
            }
            Object var8_6 = null;
            this.resetDetails();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.resetDetails();
            throw throwable;
        }
        throw new RuntimeException(e);
    }

    private void beginTranIfNecessary() {
        if (this._transaction == null) {
            try {
                this._transaction = this._transactionLog.newTransaction();
            }
            catch (Exception e) {
                this.tidyUpOnError(e);
            }
        }
    }

    @Override
    public void enqueue(BaseQueue queue, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        this._postTransactionActions.add(postTransactionAction);
        if (message.isPersistent() && queue.isDurable()) {
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Enqueue of message number " + message.getMessageNumber() + " to transaction log. Queue : " + queue.getNameShortString());
                }
                this.beginTranIfNecessary();
                this._transaction.enqueueMessage(queue, message);
            }
            catch (Exception e) {
                _logger.error("Error during message enqueue", (Throwable)e);
                this.tidyUpOnError(e);
            }
        }
    }

    @Override
    public void enqueue(List<? extends BaseQueue> queues, EnqueableMessage message, ServerTransaction.Action postTransactionAction, long currentTime) {
        this._postTransactionActions.add(postTransactionAction);
        if (this._txnStartTime == 0L) {
            long l = this._txnStartTime = currentTime == 0L ? System.currentTimeMillis() : currentTime;
        }
        if (message.isPersistent()) {
            try {
                for (BaseQueue baseQueue : queues) {
                    if (!baseQueue.isDurable()) continue;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Enqueue of message number " + message.getMessageNumber() + " to transaction log. Queue : " + baseQueue.getNameShortString());
                    }
                    this.beginTranIfNecessary();
                    this._transaction.enqueueMessage(baseQueue, message);
                }
            }
            catch (Exception e) {
                _logger.error("Error during message enqueue", (Throwable)e);
                this.tidyUpOnError(e);
            }
        }
    }

    @Override
    public void commit() {
        this.commit(null);
    }

    @Override
    public void commit(Runnable immediateAction) {
        try {
            try {
                if (this._transaction != null) {
                    this._transaction.commitTran();
                }
                if (immediateAction != null) {
                    immediateAction.run();
                }
                for (int i = 0; i < this._postTransactionActions.size(); ++i) {
                    this._postTransactionActions.get(i).postCommit();
                }
                Object var6_4 = null;
                this.resetDetails();
            }
            catch (Exception e) {
                _logger.error("Failed to commit transaction", (Throwable)e);
                for (ServerTransaction.Action action : this._postTransactionActions) {
                    action.onRollback();
                }
                throw new RuntimeException("Failed to commit transaction", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.resetDetails();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void rollback() {
        Object v0;
        block10: {
            block9: {
                if (this._transaction == null) break block9;
                this._transaction.abortTran();
            }
            Object var3_1 = null;
            try {
                for (ServerTransaction.Action action : this._postTransactionActions) {
                    action.onRollback();
                }
                v0 = null;
                break block10;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            {
                break block10;
                catch (AMQException e) {
                    _logger.error("Failed to rollback transaction", (Throwable)e);
                    throw new RuntimeException("Failed to rollback transaction", e);
                }
            }
            catch (Throwable throwable) {
                Object v1;
                Object var3_2 = null;
                try {
                    for (ServerTransaction.Action action : this._postTransactionActions) {
                        action.onRollback();
                    }
                    v1 = null;
                }
                catch (Throwable throwable2) {
                    v1 = null;
                }
                Object var7_10 = v1;
                this.resetDetails();
                throw throwable;
            }
        }
        Object var7_9 = v0;
        this.resetDetails();
    }

    private void resetDetails() {
        this._transaction = null;
        this._postTransactionActions.clear();
        this._txnStartTime = 0L;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }
}

