/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingCalendar;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class QpidCompositeRollingAppender
extends FileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    static final int BY_SIZE = 1;
    static final int BY_DATE = 2;
    static final int BY_COMPOSITE = 3;
    static final String S_BY_SIZE = "Size";
    static final String S_BY_DATE = "Date";
    static final String S_BY_COMPOSITE = "Composite";
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename = null;
    private long nextCheck = System.currentTimeMillis() - 1L;
    private Date now = new Date();
    private SimpleDateFormat sdf;
    private RollingCalendar rc = new RollingCalendar();
    private long maxFileSize = 0xA00000L;
    private int maxSizeRollBackups = 0;
    private int curSizeRollBackups = 0;
    private int maxTimeRollBackups = -1;
    private int curTimeRollBackups = 0;
    private int countDirection = -1;
    private int rollingStyle = 3;
    private boolean rollDate = true;
    private boolean rollSize = true;
    private boolean staticLogFileName = true;
    private String baseFileName;
    private boolean compress = false;
    private boolean compressAsync = false;
    private boolean zeroBased = false;
    private String backupFilesToPath = null;
    private final ConcurrentLinkedQueue<CompressJob> _compress = new ConcurrentLinkedQueue();
    private AtomicBoolean _compressing = new AtomicBoolean(false);
    private static final String COMPRESS_EXTENSION = ".gz";
    private Compressor compressor = null;
    private Executor executor;

    public QpidCompositeRollingAppender() {
    }

    public QpidCompositeRollingAppender(Layout layout, String filename, String datePattern) throws IOException {
        this(layout, filename, datePattern, true);
    }

    public QpidCompositeRollingAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public QpidCompositeRollingAppender(Layout layout, String filename, String datePattern, boolean append) throws IOException {
        super(layout, filename, append);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public QpidCompositeRollingAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public int getMaxSizeRollBackups() {
        return this.maxSizeRollBackups;
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public void setMaxSizeRollBackups(int maxBackups) {
        this.maxSizeRollBackups = maxBackups;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaximumFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize((String)value, (long)(this.maxFileSize + 1L));
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    int computeCheckPeriod() {
        RollingCalendar c = new RollingCalendar();
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                String r0 = this.sdf.format(epoch);
                c.setType(i);
                Date next = new Date(c.getNextCheckMillis(epoch));
                String r1 = this.sdf.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    protected void subAppend(LoggingEvent event) {
        long n;
        if (this.rollDate && (n = System.currentTimeMillis()) >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            this.rollOverTime();
        }
        if (this.rollSize && this.fileName != null && ((CountingQuietWriter)this.qw).getCount() >= this.maxFileSize) {
            this.rollOverSize();
        }
        super.subAppend(event);
    }

    public void setFile(String file) {
        this.baseFileName = file.trim();
        this.fileName = file.trim();
    }

    public synchronized void setFile(String fileName, boolean append) throws IOException {
        if (!this.staticLogFileName) {
            this.scheduledFilename = fileName = fileName.trim() + this.sdf.format(this.now);
        }
        super.setFile(fileName, append, this.bufferedIO, this.bufferSize);
        if (append) {
            File f = new File(fileName);
            ((CountingQuietWriter)this.qw).setCount(f.length());
        }
    }

    public int getCountDirection() {
        return this.countDirection;
    }

    public void setCountDirection(int direction) {
        this.countDirection = direction;
    }

    public int getRollingStyle() {
        return this.rollingStyle;
    }

    public void setRollingStyle(int style) {
        this.rollingStyle = style;
        switch (this.rollingStyle) {
            case 1: {
                this.rollDate = false;
                this.rollSize = true;
                break;
            }
            case 2: {
                this.rollDate = true;
                this.rollSize = false;
                break;
            }
            case 3: {
                this.rollDate = true;
                this.rollSize = true;
                break;
            }
            default: {
                this.errorHandler.error("Invalid rolling Style, use 1 (by size only), 2 (by date only) or 3 (both)");
            }
        }
    }

    public boolean getStaticLogFileName() {
        return this.staticLogFileName;
    }

    public void setStaticLogFileName(boolean s) {
        this.staticLogFileName = s;
    }

    public void setStaticLogFileName(String value) {
        this.setStaticLogFileName(OptionConverter.toBoolean((String)value, (boolean)true));
    }

    public boolean getCompressBackupFiles() {
        return this.compress;
    }

    public void setCompressBackupFiles(boolean c) {
        this.compress = c;
    }

    public boolean getCompressAsync() {
        return this.compressAsync;
    }

    public void setCompressAsync(boolean c) {
        this.compressAsync = c;
        if (this.compressAsync) {
            this.executor = Executors.newFixedThreadPool(1);
            this.compressor = new Compressor();
        }
    }

    public boolean getZeroBased() {
        return this.zeroBased;
    }

    public void setZeroBased(boolean z) {
        this.zeroBased = z;
    }

    public String getBackupFilesToPath() {
        return this.backupFilesToPath;
    }

    public void setbackupFilesToPath(String path) {
        File td = new File(path);
        if (!td.exists()) {
            td.mkdirs();
        }
        this.backupFilesToPath = path;
    }

    protected void existingInit() {
        Date last;
        File old;
        this.curTimeRollBackups = 0;
        if (this.staticLogFileName && this.rollDate && (old = new File(this.baseFileName)).exists() && !this.sdf.format(last = new Date(old.lastModified())).equals(this.sdf.format(this.now))) {
            this.scheduledFilename = this.baseFileName + this.sdf.format(last);
            LogLog.debug((String)("Initial roll over to: " + this.scheduledFilename));
            this.rollOverTime();
        }
        LogLog.debug((String)("curSizeRollBackups after rollOver at: " + this.curSizeRollBackups));
    }

    public void activateOptions() {
        if (this.datePattern != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.rc.setType(type);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
        } else if (this.rollDate) {
            LogLog.error((String)("Either DatePattern or rollingStyle options are not set for [" + this.name + "]."));
        }
        this.existingInit();
        if (this.rollDate && this.fileName != null && this.scheduledFilename == null) {
            this.scheduledFilename = this.fileName + this.sdf.format(this.now);
        }
        try {
            this.setFile(this.fileName, true);
        }
        catch (IOException e) {
            this.errorHandler.error("Cannot set file name:" + this.fileName);
        }
        super.activateOptions();
    }

    protected void rollOverTime() {
        ++this.curTimeRollBackups;
        this.closeFile();
        this.rollFile();
        try {
            this.curSizeRollBackups = 0;
            this.scheduledFilename = this.fileName + this.sdf.format(this.now);
            this.setFile(this.baseFileName, false);
        }
        catch (IOException e) {
            this.errorHandler.error("setFile(" + this.fileName + ", false) call failed.");
        }
    }

    protected void rollFile(String from, String to, boolean compress) {
        if (from.equals(to)) {
            if (compress) {
                LogLog.error((String)"Attempting to compress file with same output name.");
            }
            return;
        }
        if (this.backupFilesToPath != null) {
            to = this.backupFilesToPath + System.getProperty("file.separator") + new File(to).getName();
        }
        File target = new File(to);
        File file = new File(from);
        if (!file.getPath().equals(target.getPath())) {
            file.renameTo(target);
        }
        if (compress) {
            this.compress(target);
        }
        LogLog.debug((String)(from + " -> " + to));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress(File target) {
        if (this.compressAsync) {
            ConcurrentLinkedQueue<CompressJob> concurrentLinkedQueue = this._compress;
            synchronized (concurrentLinkedQueue) {
                this._compress.offer(new CompressJob(target, target));
            }
            this.startCompression();
        } else {
            this.doCompress(target, target);
        }
    }

    private void startCompression() {
        if (this._compressing.compareAndSet(false, true)) {
            this.executor.execute(this.compressor);
        }
    }

    protected void deleteFile(String relativeFileName) {
        File file;
        String fileName = "";
        if (this.backupFilesToPath != null) {
            file = new File(relativeFileName);
            fileName = this.backupFilesToPath + System.getProperty("file.separator") + file.getName();
        }
        if (this.compress) {
            fileName = fileName + COMPRESS_EXTENSION;
        }
        if ((file = new File(fileName)).exists()) {
            file.delete();
        }
    }

    protected void rollOverSize() {
        this.closeFile();
        LogLog.debug((String)("rolling over count=" + ((CountingQuietWriter)this.qw).getCount()));
        LogLog.debug((String)("maxSizeRollBackups = " + this.maxSizeRollBackups));
        LogLog.debug((String)("curSizeRollBackups = " + this.curSizeRollBackups));
        LogLog.debug((String)("countDirection = " + this.countDirection));
        if (this.maxSizeRollBackups != 0) {
            this.rollFile();
        }
        try {
            this.setFile(this.baseFileName, false);
        }
        catch (IOException e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
    }

    private void rollFile() {
        LogLog.debug((String)("CD=" + this.countDirection + ",start"));
        if (this.countDirection < 0) {
            if (this.curSizeRollBackups == 0) {
                this.curSizeRollBackups = this.countFileIndex(this.fileName);
                --this.curSizeRollBackups;
            }
            if (this.maxSizeRollBackups > 0) {
                LogLog.debug((String)("CD=-1,curSizeRollBackups:" + this.curSizeRollBackups));
                LogLog.debug((String)("CD=-1,maxSizeRollBackups:" + this.maxSizeRollBackups));
                if (this.curSizeRollBackups - this.maxSizeRollBackups >= 0) {
                    LogLog.debug((String)("CD=-1,deleteFile:" + this.curSizeRollBackups));
                    this.deleteFile(this.fileName + '.' + this.curSizeRollBackups);
                    --this.curSizeRollBackups;
                }
            }
            for (int i = this.curSizeRollBackups; i >= 1; --i) {
                String oldName = this.fileName + "." + i;
                String newName = this.fileName + '.' + (i + 1);
                if (this.compress) {
                    this.rollFile(oldName + COMPRESS_EXTENSION, newName + COMPRESS_EXTENSION, false);
                    continue;
                }
                this.rollFile(oldName, newName, false);
            }
            ++this.curSizeRollBackups;
            this.rollFile(this.fileName, this.fileName + ".1", this.compress);
        } else if (this.countDirection == 0) {
            this.now.setTime(System.currentTimeMillis());
            String newFile = this.fileName + this.sdf.format(this.now);
            if (this.curSizeRollBackups == 0) {
                this.curSizeRollBackups = this.countFileIndex(newFile);
                --this.curSizeRollBackups;
            }
            if (this.maxSizeRollBackups > 0 && this.curSizeRollBackups - this.maxSizeRollBackups >= 0) {
                LogLog.debug((String)("CD=0,curSizeRollBackups:" + this.curSizeRollBackups));
                LogLog.debug((String)("CD=0,maxSizeRollBackups:" + this.maxSizeRollBackups));
                int oldestFileIndex = this.curSizeRollBackups - this.maxSizeRollBackups + 1;
                LogLog.debug((String)("CD=0,deleteFile:" + oldestFileIndex));
                this.deleteFile(newFile + '.' + oldestFileIndex);
            }
            String finalName = newFile;
            ++this.curSizeRollBackups;
            if (this.curSizeRollBackups > 0) {
                finalName = newFile + '.' + this.curSizeRollBackups;
            }
            this.rollFile(this.fileName, finalName, this.compress);
        } else {
            if (this.curSizeRollBackups == 0) {
                this.curSizeRollBackups = this.countFileIndex(this.fileName);
                --this.curSizeRollBackups;
            }
            if (this.maxSizeRollBackups > 0) {
                LogLog.debug((String)("CD=1,curSizeRollBackups:" + this.curSizeRollBackups));
                LogLog.debug((String)("CD=1,maxSizeRollBackups:" + this.maxSizeRollBackups));
                if (this.curSizeRollBackups - this.maxSizeRollBackups >= 0) {
                    int oldestFileIndex = this.curSizeRollBackups - this.maxSizeRollBackups + 1;
                    LogLog.debug((String)("CD=1,deleteFile:" + oldestFileIndex));
                    this.deleteFile(this.fileName + '.' + oldestFileIndex);
                }
            }
            ++this.curSizeRollBackups;
            this.rollFile(this.fileName, this.fileName + '.' + this.curSizeRollBackups, this.compress);
        }
        LogLog.debug((String)("CD=" + this.countDirection + ",done"));
    }

    private int countFileIndex(String fileName) {
        return this.countFileIndex(fileName, true);
    }

    private int countFileIndex(String fileName, boolean checkBackupLocation) {
        int index = 1;
        String testFileName = fileName + "." + index;
        if (new File(testFileName) == null || new File(testFileName + COMPRESS_EXTENSION) == null) {
            return index;
        }
        if (!new File(testFileName).exists() && !new File(testFileName + COMPRESS_EXTENSION).exists()) {
            int max = 0;
            String prunedFileName = new File(fileName).getName();
            if (new File(fileName).getParentFile() != null) {
                for (File file : new File(fileName).getParentFile().listFiles()) {
                    String name = file.getName();
                    if (!name.startsWith(prunedFileName) || name.equals(prunedFileName)) continue;
                    String parsedCount = name.substring(prunedFileName.length() + 1);
                    if (parsedCount.endsWith(COMPRESS_EXTENSION)) {
                        parsedCount = parsedCount.substring(0, parsedCount.indexOf(COMPRESS_EXTENSION));
                    }
                    try {
                        max = Integer.parseInt(parsedCount);
                        if (max <= index) continue;
                        index = max + 1;
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            testFileName = fileName + "." + index;
        }
        while (new File(testFileName).exists() || new File(testFileName + COMPRESS_EXTENSION).exists()) {
            testFileName = fileName + "." + ++index;
        }
        if (checkBackupLocation && index == 1 && this.backupFilesToPath != null) {
            LogLog.debug((String)("Trying backup location:" + this.backupFilesToPath + System.getProperty("file.separator") + fileName));
            return this.countFileIndex(this.backupFilesToPath + System.getProperty("file.separator") + new File(fileName).getName(), false);
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doCompress(File from, File to) {
        String toFile = to.getPath() + COMPRESS_EXTENSION;
        File target = new File(toFile);
        if (target.exists()) {
            LogLog.debug((String)("deleting existing target file: " + target));
            target.delete();
        }
        try {
            GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(target));
            try {
                FileInputStream in = new FileInputStream(from);
                try {
                    int len;
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                finally {
                    in.close();
                }
                out.finish();
            }
            finally {
                out.close();
            }
            from.delete();
        }
        catch (IOException e) {
            if (target.exists()) {
                target.delete();
            }
            this.rollFile(from.getPath(), to.getPath(), false);
        }
    }

    protected long getMaxFileSize() {
        return this.maxFileSize;
    }

    protected int getCurSizeRollBackups() {
        return this.curSizeRollBackups;
    }

    protected void setCurSizeRollBackups(int curSizeRollBackups) {
        this.curSizeRollBackups = curSizeRollBackups;
    }

    protected int getMaxTimeRollBackups() {
        return this.maxTimeRollBackups;
    }

    protected void setMaxTimeRollBackups(int maxTimeRollBackups) {
        this.maxTimeRollBackups = maxTimeRollBackups;
    }

    protected int getCurTimeRollBackups() {
        return this.curTimeRollBackups;
    }

    protected void setCurTimeRollBackups(int curTimeRollBackups) {
        this.curTimeRollBackups = curTimeRollBackups;
    }

    protected boolean isRollDate() {
        return this.rollDate;
    }

    protected void setRollDate(boolean rollDate) {
        this.rollDate = rollDate;
    }

    protected boolean isRollSize() {
        return this.rollSize;
    }

    protected void setRollSize(boolean rollSize) {
        this.rollSize = rollSize;
    }

    protected boolean isStaticLogFileName() {
        return this.staticLogFileName;
    }

    protected String getBaseFileName() {
        return this.baseFileName;
    }

    protected void setBaseFileName(String baseFileName) {
        this.baseFileName = baseFileName;
    }

    protected boolean isCompress() {
        return this.compress;
    }

    protected void setCompress(boolean compress) {
        this.compress = compress;
    }

    protected boolean isCompressAsync() {
        return this.compressAsync;
    }

    protected boolean isZeroBased() {
        return this.zeroBased;
    }

    protected void setBackupFilesToPath(String backupFilesToPath) {
        this.backupFilesToPath = backupFilesToPath;
    }

    private class Compressor
    implements Runnable {
        private Compressor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean running = true;
            while (running) {
                CompressJob job = (CompressJob)QpidCompositeRollingAppender.this._compress.poll();
                QpidCompositeRollingAppender.this.doCompress(job.getFrom(), job.getTo());
                ConcurrentLinkedQueue concurrentLinkedQueue = QpidCompositeRollingAppender.this._compress;
                synchronized (concurrentLinkedQueue) {
                    if (QpidCompositeRollingAppender.this._compress.isEmpty()) {
                        running = false;
                        QpidCompositeRollingAppender.this._compressing.set(false);
                    }
                }
            }
        }
    }

    private static class CompressJob {
        private File _from;
        private File _to;

        CompressJob(File from, File to) {
            this._from = from;
            this._to = to;
        }

        File getFrom() {
            return this._from;
        }

        File getTo() {
            return this._to;
        }
    }
}

