/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.server.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerOptions {
    public static final String QPID_WORK_DIR = "qpid.work_dir";
    public static final String QPID_HOME_DIR = "qpid.home_dir";
    public static final String QPID_AMQP_PORT = "qpid.amqp_port";
    public static final String QPID_HTTP_PORT = "qpid.http_port";
    public static final String QPID_RMI_PORT = "qpid.rmi_port";
    public static final String QPID_JMX_PORT = "qpid.jmx_port";
    public static final String DEFAULT_AMQP_PORT_NUMBER = "5672";
    public static final String DEFAULT_HTTP_PORT_NUMBER = "8080";
    public static final String DEFAULT_RMI_PORT_NUMBER = "8999";
    public static final String DEFAULT_JMX_PORT_NUMBER = "9099";
    public static final String DEFAULT_INITIAL_CONFIG_NAME = "initial-config.json";
    public static final String DEFAULT_STORE_TYPE = "json";
    public static final String DEFAULT_CONFIG_NAME_PREFIX = "config";
    public static final String DEFAULT_LOG_CONFIG_FILE = "etc/log4j.xml";
    public static final String DEFAULT_INITIAL_CONFIG_LOCATION = BrokerOptions.class.getClassLoader().getResource("initial-config.json").toExternalForm();
    public static final String MANAGEMENT_MODE_USER_NAME = "mm_admin";
    private static final int MANAGEMENT_MODE_PASSWORD_LENGTH = 10;
    private static final File FALLBACK_WORK_DIR = new File(System.getProperty("user.dir"), "work");
    private String _logConfigFile;
    private Integer _logWatchFrequency = 0;
    private String _configurationStoreLocation;
    private String _configurationStoreType;
    private String _initialConfigurationLocation;
    private boolean _managementMode;
    private boolean _managementModeQuiesceVhosts;
    private int _managementModeRmiPortOverride;
    private int _managementModeJmxPortOverride;
    private int _managementModeHttpPortOverride;
    private String _managementModePassword;
    private boolean _skipLoggingConfiguration;
    private boolean _overwriteConfigurationStore;
    private Map<String, String> _configProperties = new HashMap<String, String>();

    public String getManagementModePassword() {
        if (this._managementModePassword == null) {
            this._managementModePassword = new StringUtil().randomAlphaNumericString(10);
        }
        return this._managementModePassword;
    }

    public void setManagementModePassword(String managementModePassword) {
        this._managementModePassword = managementModePassword;
    }

    public int getLogWatchFrequency() {
        return this._logWatchFrequency;
    }

    public void setLogWatchFrequency(int logWatchFrequency) {
        this._logWatchFrequency = logWatchFrequency;
    }

    public boolean isManagementMode() {
        return this._managementMode;
    }

    public void setManagementMode(boolean managementMode) {
        this._managementMode = managementMode;
    }

    public boolean isManagementModeQuiesceVirtualHosts() {
        return this._managementModeQuiesceVhosts;
    }

    public void setManagementModeQuiesceVirtualHosts(boolean managementModeQuiesceVhosts) {
        this._managementModeQuiesceVhosts = managementModeQuiesceVhosts;
    }

    public int getManagementModeRmiPortOverride() {
        return this._managementModeRmiPortOverride;
    }

    public void setManagementModeRmiPortOverride(int managementModeRmiPortOverride) {
        this._managementModeRmiPortOverride = managementModeRmiPortOverride;
    }

    public int getManagementModeJmxPortOverride() {
        return this._managementModeJmxPortOverride;
    }

    public void setManagementModeJmxPortOverride(int managementModeJmxPortOverride) {
        this._managementModeJmxPortOverride = managementModeJmxPortOverride;
    }

    public int getManagementModeHttpPortOverride() {
        return this._managementModeHttpPortOverride;
    }

    public void setManagementModeHttpPortOverride(int managementModeHttpPortOverride) {
        this._managementModeHttpPortOverride = managementModeHttpPortOverride;
    }

    public String getConfigurationStoreType() {
        if (this._configurationStoreType == null) {
            return DEFAULT_STORE_TYPE;
        }
        return this._configurationStoreType;
    }

    public void setConfigurationStoreType(String cofigurationStoreType) {
        this._configurationStoreType = cofigurationStoreType;
    }

    public String getConfigurationStoreLocation() {
        if (this._configurationStoreLocation == null) {
            String workDir = this.getWorkDir();
            String storeType = this.getConfigurationStoreType();
            return new File(workDir, "config." + storeType).getAbsolutePath();
        }
        return this._configurationStoreLocation;
    }

    public void setConfigurationStoreLocation(String cofigurationStore) {
        this._configurationStoreLocation = cofigurationStore;
    }

    public boolean isOverwriteConfigurationStore() {
        return this._overwriteConfigurationStore;
    }

    public void setOverwriteConfigurationStore(boolean overwrite) {
        this._overwriteConfigurationStore = overwrite;
    }

    public String getInitialConfigurationLocation() {
        if (this._initialConfigurationLocation == null) {
            return DEFAULT_INITIAL_CONFIG_LOCATION;
        }
        return this._initialConfigurationLocation;
    }

    public void setInitialConfigurationLocation(String initialConfigurationLocation) {
        this._initialConfigurationLocation = initialConfigurationLocation;
    }

    public boolean isSkipLoggingConfiguration() {
        return this._skipLoggingConfiguration;
    }

    public void setSkipLoggingConfiguration(boolean skipLoggingConfiguration) {
        this._skipLoggingConfiguration = skipLoggingConfiguration;
    }

    public void setConfigProperty(String name, String value) {
        if (value == null) {
            this._configProperties.remove(name);
        } else {
            this._configProperties.put(name, value);
        }
    }

    public Map<String, String> getConfigProperties() {
        ConcurrentHashMap<String, String> properties = new ConcurrentHashMap<String, String>();
        properties.putAll(this._configProperties);
        properties.putIfAbsent(QPID_AMQP_PORT, String.valueOf(DEFAULT_AMQP_PORT_NUMBER));
        properties.putIfAbsent(QPID_HTTP_PORT, String.valueOf(DEFAULT_HTTP_PORT_NUMBER));
        properties.putIfAbsent(QPID_RMI_PORT, String.valueOf(DEFAULT_RMI_PORT_NUMBER));
        properties.putIfAbsent(QPID_JMX_PORT, String.valueOf(DEFAULT_JMX_PORT_NUMBER));
        properties.putIfAbsent(QPID_WORK_DIR, this.getWorkDir());
        String homeDir = this.getHomeDir();
        if (homeDir != null) {
            properties.putIfAbsent(QPID_HOME_DIR, homeDir);
        }
        return Collections.unmodifiableMap(properties);
    }

    public String getLogConfigFileLocation() {
        if (this._logConfigFile == null) {
            String homeDir = this.getHomeDir();
            return new File(homeDir, DEFAULT_LOG_CONFIG_FILE).getAbsolutePath();
        }
        return this._logConfigFile;
    }

    public void setLogConfigFileLocation(String logConfigFile) {
        this._logConfigFile = logConfigFile;
    }

    private String getWorkDir() {
        if (!this._configProperties.containsKey(QPID_WORK_DIR)) {
            String qpidWork = System.getProperty("QPID_WORK");
            if (qpidWork == null) {
                return FALLBACK_WORK_DIR.getAbsolutePath();
            }
            return qpidWork;
        }
        return this._configProperties.get(QPID_WORK_DIR);
    }

    private String getHomeDir() {
        if (!this._configProperties.containsKey(QPID_HOME_DIR)) {
            return System.getProperty("QPID_HOME");
        }
        return this._configProperties.get(QPID_HOME_DIR);
    }
}

