/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.binding;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQInternalException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.BindingMessages;
import org.apache.qpid.server.logging.subjects.BindingLogSubject;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingFactory {
    private final VirtualHost _virtualHost;
    private final ConcurrentHashMap<BindingImpl, BindingImpl> _bindings = new ConcurrentHashMap();

    public BindingFactory(VirtualHost vhost) {
        this._virtualHost = vhost;
    }

    public boolean addBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) throws AMQSecurityException, AMQInternalException {
        return this.makeBinding(null, bindingKey, queue, exchange, arguments, false, false);
    }

    public boolean replaceBinding(UUID id, String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) throws AMQSecurityException, AMQInternalException {
        return this.makeBinding(id, bindingKey, queue, exchange, arguments, false, true);
    }

    private boolean makeBinding(UUID id, String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments, boolean restore, boolean force) throws AMQSecurityException, AMQInternalException {
        BindingImpl b;
        BindingImpl existingMapping;
        assert (queue != null);
        Exchange defaultExchange = this._virtualHost.getExchangeRegistry().getDefaultExchange();
        if (bindingKey == null) {
            bindingKey = "";
        }
        if (exchange == null) {
            exchange = defaultExchange;
        }
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        if (exchange == null) {
            throw new IllegalArgumentException("exchange cannot be null");
        }
        if (exchange != defaultExchange && !this._virtualHost.getSecurityManager().authoriseBind(exchange, queue, new AMQShortString(bindingKey))) {
            throw new AMQSecurityException("Permission denied: binding " + bindingKey);
        }
        if (id == null) {
            id = UUIDGenerator.generateBindingUUID(exchange.getName(), queue.getName(), bindingKey, this._virtualHost.getName());
        }
        if ((existingMapping = this._bindings.putIfAbsent(b = new BindingImpl(id, bindingKey, queue, exchange, arguments), b)) == null || force) {
            if (existingMapping != null) {
                this.removeBinding(existingMapping);
            }
            if (b.isDurable() && !restore) {
                this._virtualHost.getMessageStore().bindQueue(b);
            }
            queue.addQueueDeleteTask(b);
            exchange.addCloseTask(b);
            queue.addBinding(b);
            exchange.addBinding(b);
            b.logCreation();
            return true;
        }
        return false;
    }

    public void restoreBinding(UUID id, String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> argumentMap) throws AMQSecurityException, AMQInternalException {
        this.makeBinding(id, bindingKey, queue, exchange, argumentMap, true, false);
    }

    public void removeBinding(Binding b) throws AMQSecurityException, AMQInternalException {
        this.removeBinding(b.getBindingKey(), b.getQueue(), b.getExchange(), b.getArguments());
    }

    public Binding removeBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) throws AMQSecurityException, AMQInternalException {
        assert (queue != null);
        Exchange defaultExchange = this._virtualHost.getExchangeRegistry().getDefaultExchange();
        if (bindingKey == null) {
            bindingKey = "";
        }
        if (exchange == null) {
            exchange = defaultExchange;
        }
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        if (exchange != defaultExchange && !this._virtualHost.getSecurityManager().authoriseUnbind(exchange, new AMQShortString(bindingKey), queue)) {
            throw new AMQSecurityException("Permission denied: unbinding " + bindingKey);
        }
        BindingImpl b = this._bindings.remove(new BindingImpl(null, bindingKey, queue, exchange, arguments));
        if (b != null) {
            exchange.removeBinding(b);
            queue.removeBinding(b);
            exchange.removeCloseTask(b);
            queue.removeQueueDeleteTask(b);
            if (b.isDurable()) {
                this._virtualHost.getMessageStore().unbindQueue(b);
            }
            b.logDestruction();
        }
        return b;
    }

    public Binding getBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) {
        assert (queue != null);
        Exchange defaultExchange = this._virtualHost.getExchangeRegistry().getDefaultExchange();
        if (bindingKey == null) {
            bindingKey = "";
        }
        if (exchange == null) {
            exchange = defaultExchange;
        }
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        BindingImpl b = new BindingImpl(null, bindingKey, queue, exchange, arguments);
        return this._bindings.get(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BindingImpl
    extends Binding
    implements AMQQueue.Task,
    Exchange.Task {
        private final BindingLogSubject _logSubject;
        private long _createTime;

        private BindingImpl(UUID id, String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) {
            super(id, bindingKey, queue, exchange, arguments);
            this._createTime = System.currentTimeMillis();
            this._logSubject = new BindingLogSubject(bindingKey, exchange, queue);
        }

        @Override
        public void doTask(AMQQueue queue) throws AMQException {
            BindingFactory.this.removeBinding(this);
        }

        @Override
        public void onClose(Exchange exchange) throws AMQSecurityException, AMQInternalException {
            BindingFactory.this.removeBinding(this);
        }

        void logCreation() {
            CurrentActor.get().message(this._logSubject, BindingMessages.CREATED(String.valueOf(this.getArguments()), this.getArguments() != null && !this.getArguments().isEmpty()));
        }

        void logDestruction() {
            CurrentActor.get().message(this._logSubject, BindingMessages.DELETED());
        }

        public String getOrigin() {
            return (String)this.getArguments().get("qpid.fed.origin");
        }

        public long getCreateTime() {
            return this._createTime;
        }

        @Override
        public boolean isDurable() {
            return this.getQueue().isDurable() && this.getExchange().isDurable();
        }
    }
}

