/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.configuration.ConfigurationEntryStore;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.store.MemoryConfigurationEntryStore;
import org.apache.qpid.server.plugin.ConfigurationStoreFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerConfigurationStoreCreator {
    private Map<String, ConfigurationStoreFactory> _factories = new HashMap<String, ConfigurationStoreFactory>();

    public BrokerConfigurationStoreCreator() {
        QpidServiceLoader<ConfigurationStoreFactory> serviceLoader = new QpidServiceLoader<ConfigurationStoreFactory>();
        Iterable<ConfigurationStoreFactory> configurationStoreFactories = serviceLoader.instancesOf(ConfigurationStoreFactory.class);
        for (ConfigurationStoreFactory storeFactory : configurationStoreFactories) {
            String type = storeFactory.getStoreType();
            ConfigurationStoreFactory factory = this._factories.put(type.toLowerCase(), storeFactory);
            if (factory == null) continue;
            throw new IllegalStateException("ConfigurationStoreFactory with type name '" + type + "' is already registered using class '" + factory.getClass().getName() + "', can not register class '" + storeFactory.getClass().getName() + "'");
        }
    }

    public ConfigurationEntryStore createStore(String storeLocation, String storeType, String initialConfigLocation, boolean overwrite, Map<String, String> configProperties) {
        MemoryConfigurationEntryStore initialStore = new MemoryConfigurationEntryStore(initialConfigLocation, null, configProperties);
        ConfigurationStoreFactory factory = this._factories.get(storeType.toLowerCase());
        if (factory == null) {
            throw new IllegalConfigurationException("Unknown store type: " + storeType);
        }
        return factory.createStore(storeLocation, initialStore, overwrite, configProperties);
    }

    public Collection<String> getStoreTypes() {
        return Collections.unmodifiableCollection(this._factories.keySet());
    }
}

