/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.server.configuration.ConfigurationEntryStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationEntry {
    public static final String ATTRIBUTE_NAME = "name";
    private final UUID _id;
    private final String _type;
    private final Map<String, Object> _attributes;
    private final Set<UUID> _childrenIds;
    private final ConfigurationEntryStore _store;

    public ConfigurationEntry(UUID id, String type, Map<String, Object> attributes, Set<UUID> childrenIds, ConfigurationEntryStore store) {
        this._id = id;
        this._type = type;
        this._attributes = attributes;
        this._childrenIds = childrenIds;
        this._store = store;
    }

    public UUID getId() {
        return this._id;
    }

    public String getType() {
        return this._type;
    }

    public Map<String, Object> getAttributes() {
        return this._attributes;
    }

    public Set<UUID> getChildrenIds() {
        return this._childrenIds;
    }

    public ConfigurationEntryStore getStore() {
        return this._store;
    }

    public Map<String, Collection<ConfigurationEntry>> getChildren() {
        Map children = null;
        if (this._childrenIds == null) {
            children = Collections.emptyMap();
        } else {
            children = new HashMap();
            for (UUID childId : this._childrenIds) {
                ConfigurationEntry entry = this._store.getEntry(childId);
                String type = entry.getType();
                ArrayList<ConfigurationEntry> childrenOfType = (ArrayList<ConfigurationEntry>)children.get(type);
                if (childrenOfType == null) {
                    childrenOfType = new ArrayList<ConfigurationEntry>();
                    children.put(type, childrenOfType);
                }
                childrenOfType.add(entry);
            }
        }
        return Collections.unmodifiableMap(children);
    }

    public boolean hasChild(UUID id) {
        return this._childrenIds.contains(id);
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationEntry other = (ConfigurationEntry)obj;
        if (this._id == null ? other._id != null : !this._id.equals(other._id)) {
            return false;
        }
        if (this._type == null ? other._type != null : !this._type.equals(other._type)) {
            return false;
        }
        if (this._store == null ? other._store != null : !this._store.equals(other._store)) {
            return false;
        }
        if (this._childrenIds == null ? other._childrenIds != null : !((Object)this._childrenIds).equals(other._childrenIds)) {
            return false;
        }
        return !(this._attributes == null ? other._attributes != null : !((Object)this._attributes).equals(other._attributes));
    }

    public String toString() {
        return "ConfigurationEntry [id=" + this._id + ", type=" + this._type + ", attributes=" + this._attributes + ", childrenIds=" + this._childrenIds + "]";
    }
}

