/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration;

import java.io.File;
import java.util.Iterator;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;

public class XmlConfigurationUtilities {
    public static Configuration parseConfig(File file) throws ConfigurationException {
        ConfigurationFactory factory = new ConfigurationFactory();
        factory.setConfigurationFileName(file.getAbsolutePath());
        Configuration conf = factory.getConfiguration();
        Iterator keys = conf.getKeys();
        if (!keys.hasNext()) {
            keys = null;
            conf = XmlConfigurationUtilities.flatConfig(file);
        }
        return conf;
    }

    public static final Configuration flatConfig(File file) throws ConfigurationException {
        final MyConfiguration conf = new MyConfiguration();
        conf.addConfiguration((Configuration)new SystemConfiguration(){

            protected String interpolate(String o) {
                return conf.interpolate(o);
            }
        });
        conf.addConfiguration((Configuration)new XMLConfiguration(file){

            protected String interpolate(String o) {
                return conf.interpolate(o);
            }
        });
        return conf;
    }

    public static String escapeTagName(String name) {
        return name.replaceAll("\\.", "\\.\\.");
    }

    public static class MyConfiguration
    extends CompositeConfiguration {
        public String interpolate(String obj) {
            return super.interpolate(obj);
        }
    }
}

