/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.startup;

import java.util.Map;
import org.apache.qpid.server.configuration.ConfigurationEntry;
import org.apache.qpid.server.configuration.ConfiguredObjectRecoverer;
import org.apache.qpid.server.configuration.RecovererProvider;
import org.apache.qpid.server.configuration.startup.RecovererHelper;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.adapter.AuthenticationProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationProviderRecoverer
implements ConfiguredObjectRecoverer<AuthenticationProvider> {
    private final AuthenticationProviderFactory _authenticationProviderFactory;

    public AuthenticationProviderRecoverer(AuthenticationProviderFactory authenticationProviderFactory) {
        this._authenticationProviderFactory = authenticationProviderFactory;
    }

    @Override
    public AuthenticationProvider create(RecovererProvider recovererProvider, ConfigurationEntry configurationEntry, ConfiguredObject ... parents) {
        Broker broker = RecovererHelper.verifyOnlyBrokerIsParent(parents);
        Map<String, Object> attributes = configurationEntry.getAttributes();
        AuthenticationProvider authenticationProvider = this._authenticationProviderFactory.recover(configurationEntry.getId(), attributes, broker);
        return authenticationProvider;
    }
}

