/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.store;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.util.FileUtils;

public class ConfigurationEntryStoreUtil {
    public void copyInitialConfigFile(String initialConfigLocation, File destinationFile) {
        URL initialStoreURL = this.toURL(initialConfigLocation);
        InputStream in = null;
        try {
            in = initialStoreURL.openStream();
            FileUtils.copy((InputStream)in, (File)destinationFile);
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Cannot create file " + destinationFile + " by copying initial config from " + initialConfigLocation, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new IllegalConfigurationException("Cannot close initial config input stream: " + initialConfigLocation, e);
                }
            }
        }
    }

    public URL toURL(String location) {
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            File locationFile = new File(location);
            url = this.fileToURL(locationFile);
        }
        return url;
    }

    protected URL fileToURL(File storeFile) {
        URL storeURL = null;
        try {
            storeURL = storeFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalConfigurationException("Cannot create URL for file " + storeFile, e);
        }
        return storeURL;
    }
}

