/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.store;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.qpid.server.configuration.ConfigurationEntry;
import org.apache.qpid.server.configuration.ConfigurationEntryStore;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.store.ConfigurationEntryStoreUtil;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.util.Strings;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.node.ArrayNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryConfigurationEntryStore
implements ConfigurationEntryStore {
    public static final String STORE_TYPE = "memory";
    private static final String DEFAULT_BROKER_NAME = "Broker";
    private static final String ID = "id";
    private static final String TYPE = "@type";
    static final int STORE_VERSION = 1;
    private final ObjectMapper _objectMapper;
    private final Map<UUID, ConfigurationEntry> _entries;
    private final Map<String, Class<? extends ConfiguredObject>> _relationshipClasses;
    private final ConfigurationEntryStoreUtil _util = new ConfigurationEntryStoreUtil();
    private String _storeLocation;
    private UUID _rootId;
    private boolean _generatedObjectIdDuringLoad;
    private Strings.ChainedResolver _resolver;

    protected MemoryConfigurationEntryStore(Map<String, String> configProperties) {
        this._objectMapper = new ObjectMapper();
        this._objectMapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        this._objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        this._entries = new HashMap<UUID, ConfigurationEntry>();
        this._relationshipClasses = this.buildRelationshipClassMap();
        this._resolver = new Strings.ChainedResolver(Strings.SYSTEM_RESOLVER, (Strings.Resolver)new Strings.MapResolver(configProperties));
    }

    MemoryConfigurationEntryStore(String json, Map<String, String> configProperties) {
        this(configProperties);
        if (json == null || "".equals(json)) {
            this.createRootEntry();
        } else {
            this.loadFromJson(json);
        }
    }

    public MemoryConfigurationEntryStore(String initialStoreLocation, ConfigurationEntryStore initialStore, Map<String, String> configProperties) {
        this(configProperties);
        if (initialStore == null && (initialStoreLocation == null || "".equals(initialStoreLocation))) {
            throw new IllegalConfigurationException("Cannot instantiate the memory broker store as neither initial store nor initial store location is provided");
        }
        if (initialStore != null) {
            if (initialStore instanceof MemoryConfigurationEntryStore) {
                this._storeLocation = initialStore.getStoreLocation();
            }
            this._rootId = initialStore.getRootEntry().getId();
            this.copyEntry(this._rootId, initialStore, this._entries);
        } else {
            this._storeLocation = initialStoreLocation;
            this.load(this._util.toURL(this._storeLocation));
        }
    }

    @Override
    public synchronized UUID[] remove(UUID ... entryIds) {
        ArrayList<UUID> removedIds = new ArrayList<UUID>();
        for (UUID uuid : entryIds) {
            if (!this._rootId.equals(uuid)) continue;
            throw new IllegalConfigurationException("Cannot remove root entry");
        }
        for (UUID uuid : entryIds) {
            if (!this.removeInternal(uuid)) continue;
            for (ConfigurationEntry entry : this._entries.values()) {
                if (!entry.hasChild(uuid)) continue;
                HashSet<UUID> children = new HashSet<UUID>(entry.getChildrenIds());
                children.remove(uuid);
                ConfigurationEntry referal = new ConfigurationEntry(entry.getId(), entry.getType(), entry.getAttributes(), children, this);
                this._entries.put(entry.getId(), referal);
            }
            removedIds.add(uuid);
        }
        return removedIds.toArray(new UUID[removedIds.size()]);
    }

    @Override
    public synchronized void save(ConfigurationEntry ... entries) {
        this.replaceEntries(entries);
    }

    @Override
    public ConfigurationEntry getRootEntry() {
        return this.getEntry(this._rootId);
    }

    @Override
    public synchronized ConfigurationEntry getEntry(UUID id) {
        return this._entries.get(id);
    }

    @Override
    public void copyTo(String copyLocation) {
        File file = new File(copyLocation);
        if (!file.exists()) {
            this.createFileIfNotExist(file);
        }
        this.saveAsTree(file);
    }

    @Override
    public String getStoreLocation() {
        return this._storeLocation;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public String getType() {
        return STORE_TYPE;
    }

    public String toString() {
        return "MemoryConfigurationEntryStore [_rootId=" + this._rootId + "]";
    }

    protected boolean replaceEntries(ConfigurationEntry ... entries) {
        boolean anySaved = false;
        for (ConfigurationEntry entry : entries) {
            ConfigurationEntry oldEntry = this._entries.put(entry.getId(), entry);
            if (entry.equals(oldEntry)) continue;
            anySaved = true;
        }
        return anySaved;
    }

    protected ObjectMapper getObjectMapper() {
        return this._objectMapper;
    }

    protected void saveAsTree(File file) {
        this.saveAsTree(this._rootId, this._entries, this._objectMapper, file, 1);
    }

    protected void saveAsTree(UUID rootId, Map<UUID, ConfigurationEntry> entries, ObjectMapper mapper, File file, int version) {
        Map<String, Object> tree = this.toTree(rootId, entries);
        tree.put("storeVersion", version);
        try {
            mapper.writeValue(file, tree);
        }
        catch (JsonGenerationException e) {
            throw new IllegalConfigurationException("Cannot generate json!", e);
        }
        catch (JsonMappingException e) {
            throw new IllegalConfigurationException("Cannot map objects for json serialization!", e);
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Cannot save configuration into " + file + "!", e);
        }
    }

    protected void load(URL url) {
        InputStream is = null;
        try {
            is = url.openStream();
            JsonNode node = this.loadJsonNodes(is, this._objectMapper);
            int storeVersion = 0;
            JsonNode storeVersionNode = node.get("storeVersion");
            if (storeVersionNode == null || storeVersionNode.isNull()) {
                throw new IllegalConfigurationException("Broker storeVersion attribute must be specified");
            }
            storeVersion = storeVersionNode.getIntValue();
            if (storeVersion != 1) {
                throw new IllegalConfigurationException("The data of version " + storeVersion + " can not be loaded by store of version " + 1);
            }
            ConfigurationEntry brokerEntry = this.toEntry(node, Broker.class, this._entries);
            this._rootId = brokerEntry.getId();
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Cannot load store from: " + url, e);
        }
        finally {
            if (is != null && is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new IllegalConfigurationException("Cannot close input stream for: " + url, e);
                }
            }
        }
    }

    protected void createFileIfNotExist(File file) {
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IllegalConfigurationException("Cannot create folders " + parent);
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Cannot create file " + file, e);
        }
    }

    protected void copyEntry(UUID entryId, ConfigurationEntryStore initialStore, Map<UUID, ConfigurationEntry> entries) {
        ConfigurationEntry entry = initialStore.getEntry(entryId);
        if (entry != null) {
            if (entries.containsKey(entryId)) {
                throw new IllegalConfigurationException("Duplicate id is found: " + entryId + "! The following configuration entries have the same id: " + entries.get(entryId) + ", " + entry);
            }
            Set<UUID> children = entry.getChildrenIds();
            HashSet<UUID> childrenCopy = children == null ? null : new HashSet<UUID>(children);
            ConfigurationEntry copy = new ConfigurationEntry(entryId, entry.getType(), new HashMap<String, Object>(entry.getAttributes()), childrenCopy, this);
            entries.put(entryId, copy);
            if (children != null) {
                for (UUID uuid : children) {
                    this.copyEntry(uuid, initialStore, entries);
                }
            }
        }
    }

    private void loadFromJson(String json) {
        ByteArrayInputStream bais = null;
        try {
            byte[] bytes = json.getBytes("UTF-8");
            bais = new ByteArrayInputStream(bytes);
            JsonNode node = this.loadJsonNodes(bais, this._objectMapper);
            ConfigurationEntry brokerEntry = this.toEntry(node, Broker.class, this._entries);
            this._rootId = brokerEntry.getId();
        }
        catch (Exception e) {
            throw new IllegalConfigurationException("Cannot create store from json:" + json);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void createRootEntry() {
        ConfigurationEntry brokerEntry = new ConfigurationEntry(UUIDGenerator.generateRandomUUID(), Broker.class.getSimpleName(), Collections.<String, Object>emptyMap(), Collections.<UUID>emptySet(), this);
        this._rootId = brokerEntry.getId();
        this._entries.put(this._rootId, brokerEntry);
    }

    private Map<String, Object> toTree(UUID rootId, Map<UUID, ConfigurationEntry> entries) {
        ConfigurationEntry entry = entries.get(rootId);
        if (entry == null || !entry.getId().equals(rootId)) {
            throw new IllegalConfigurationException("Cannot find entry with id " + rootId + "!");
        }
        TreeMap<String, Object> tree = new TreeMap<String, Object>();
        Map<String, Object> attributes = entry.getAttributes();
        if (attributes != null) {
            tree.putAll(attributes);
        }
        tree.put(ID, entry.getId());
        Set<UUID> childrenIds = entry.getChildrenIds();
        if (childrenIds != null && !childrenIds.isEmpty()) {
            for (UUID relationship : childrenIds) {
                ConfigurationEntry child = entries.get(relationship);
                if (child == null) continue;
                String relationshipName = child.getType().toLowerCase() + "s";
                ArrayList<Map<String, Object>> children = (ArrayList<Map<String, Object>>)tree.get(relationshipName);
                if (children == null) {
                    children = new ArrayList<Map<String, Object>>();
                    tree.put(relationshipName, children);
                }
                Map<String, Object> childAsMap = this.toTree(relationship, entries);
                children.add(childAsMap);
            }
        }
        return tree;
    }

    private Map<String, Class<? extends ConfiguredObject>> buildRelationshipClassMap() {
        HashMap<String, Class<? extends ConfiguredObject>> relationships = new HashMap<String, Class<? extends ConfiguredObject>>();
        Collection<Class<? extends ConfiguredObject>> children = Model.getInstance().getChildTypes(Broker.class);
        for (Class<? extends ConfiguredObject> childClass : children) {
            String name = childClass.getSimpleName().toLowerCase();
            String relationshipName = name + (name.endsWith("s") ? "es" : "s");
            relationships.put(relationshipName, childClass);
        }
        return relationships;
    }

    private boolean removeInternal(UUID entryId) {
        ConfigurationEntry oldEntry = this._entries.remove(entryId);
        if (oldEntry != null) {
            Set<UUID> children = oldEntry.getChildrenIds();
            if (children != null && !children.isEmpty()) {
                for (UUID childId : children) {
                    this.removeInternal(childId);
                }
            }
            return true;
        }
        return false;
    }

    private JsonNode loadJsonNodes(InputStream is, ObjectMapper mapper) {
        JsonNode root = null;
        try {
            root = mapper.readTree(is);
        }
        catch (JsonProcessingException e) {
            throw new IllegalConfigurationException("Cannot parse json", e);
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Cannot read json", e);
        }
        return root;
    }

    private ConfigurationEntry toEntry(JsonNode parent, Class<? extends ConfiguredObject> expectedConfiguredObjectClass, Map<UUID, ConfigurationEntry> entries) {
        HashMap<String, Object> attributes = null;
        TreeSet<UUID> childrenIds = new TreeSet<UUID>();
        Iterator fieldNames = parent.getFieldNames();
        String type = null;
        String idAsString = null;
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode fieldNode = parent.get(fieldName);
            if (fieldName.equals(ID)) {
                idAsString = fieldNode.asText();
                continue;
            }
            if (fieldName.equals(TYPE)) {
                type = fieldNode.asText();
                continue;
            }
            if (fieldNode.isArray()) {
                Iterator elements = fieldNode.getElements();
                ArrayList<Object> fieldValues = null;
                while (elements.hasNext()) {
                    JsonNode element = (JsonNode)elements.next();
                    if (element.isObject()) {
                        Class<? extends ConfiguredObject> expectedChildConfiguredObjectClass = this._relationshipClasses.get(fieldName);
                        ConfigurationEntry entry = this.toEntry(element, expectedChildConfiguredObjectClass, entries);
                        childrenIds.add(entry.getId());
                        continue;
                    }
                    if (fieldValues == null) {
                        fieldValues = new ArrayList<Object>();
                    }
                    fieldValues.add(this.toObject(element));
                }
                if (fieldValues == null) continue;
                Object[] array = fieldValues.toArray(new Object[fieldValues.size()]);
                attributes.put(fieldName, array);
                continue;
            }
            if (fieldNode.isObject()) continue;
            Object value = this.toObject(fieldNode);
            if (attributes == null) {
                attributes = new HashMap<String, Object>();
            }
            attributes.put(fieldName, value);
        }
        if (type == null) {
            if (expectedConfiguredObjectClass == null) {
                throw new IllegalConfigurationException("Type attribute is not provided for configuration entry " + parent);
            }
            type = expectedConfiguredObjectClass.getSimpleName();
        }
        String name = null;
        if (attributes != null) {
            name = (String)attributes.get("name");
        }
        if (name == null || "".equals(name)) {
            if (expectedConfiguredObjectClass == Broker.class) {
                name = DEFAULT_BROKER_NAME;
            } else {
                throw new IllegalConfigurationException("Name attribute is not provided for configuration entry " + parent);
            }
        }
        UUID id = null;
        if (idAsString == null) {
            id = UUIDGenerator.generateRandomUUID();
            this._generatedObjectIdDuringLoad = true;
        } else {
            try {
                id = UUID.fromString(idAsString);
            }
            catch (Exception e) {
                throw new IllegalConfigurationException("ID attribute value does not conform to UUID format for configuration entry " + parent);
            }
        }
        ConfigurationEntry entry = new ConfigurationEntry(id, type, (Map<String, Object>)attributes, childrenIds, this);
        if (entries.containsKey(id)) {
            throw new IllegalConfigurationException("Duplicate id is found: " + id + "! The following configuration entries have the same id: " + entries.get(id) + ", " + entry);
        }
        entries.put(id, entry);
        return entry;
    }

    private Object toObject(JsonNode node) {
        if (node.isValueNode()) {
            if (node.isBoolean()) {
                return node.asBoolean();
            }
            if (node.isDouble()) {
                return node.asDouble();
            }
            if (node.isInt()) {
                return node.asInt();
            }
            if (node.isLong()) {
                return node.asLong();
            }
            if (node.isNull()) {
                return null;
            }
            return Strings.expand((String)node.asText(), (Strings.Resolver)this._resolver);
        }
        if (node.isArray()) {
            return this.toArray(node);
        }
        if (node.isObject()) {
            return this.toMap(node);
        }
        throw new IllegalConfigurationException("Unexpected node: " + node);
    }

    private Map<String, Object> toMap(JsonNode node) {
        TreeMap<String, Object> object = new TreeMap<String, Object>();
        Iterator fieldNames = node.getFieldNames();
        while (fieldNames.hasNext()) {
            String name = (String)fieldNames.next();
            Object value = this.toObject(node.get(name));
            object.put(name, value);
        }
        return object;
    }

    private Object toArray(JsonNode node) {
        ArrayNode arrayNode = (ArrayNode)node;
        Object[] array = new Object[arrayNode.size()];
        Iterator elements = arrayNode.getElements();
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.toObject((JsonNode)elements.next());
        }
        return array;
    }

    protected boolean isGeneratedObjectIdDuringLoad() {
        return this._generatedObjectIdDuringLoad;
    }

    protected ConfigurationEntryStoreUtil getConfigurationEntryStoreUtil() {
        return this._util;
    }
}

