/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.store;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.qpid.server.configuration.ConfigurationEntry;
import org.apache.qpid.server.configuration.ConfigurationEntryStore;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreConfigurationChangeListener
implements ConfigurationChangeListener {
    private ConfigurationEntryStore _store;

    public StoreConfigurationChangeListener(ConfigurationEntryStore store) {
        this._store = store;
    }

    @Override
    public void stateChanged(ConfiguredObject object, State oldState, State newState) {
        if (newState == State.DELETED) {
            this._store.remove(object.getId());
            object.removeChangeListener(this);
        }
    }

    @Override
    public void childAdded(ConfiguredObject object, ConfiguredObject child) {
        if (!(object instanceof VirtualHost)) {
            child.addChangeListener(this);
            ConfigurationEntry parentEntry = this.toConfigurationEntry(object);
            ConfigurationEntry childEntry = this.toConfigurationEntry(child);
            this._store.save(parentEntry, childEntry);
        }
    }

    @Override
    public void childRemoved(ConfiguredObject object, ConfiguredObject child) {
        this._store.save(this.toConfigurationEntry(object));
    }

    @Override
    public void attributeSet(ConfiguredObject object, String attrinuteName, Object oldAttributeValue, Object newAttributeValue) {
        this._store.save(this.toConfigurationEntry(object));
    }

    private ConfigurationEntry toConfigurationEntry(ConfiguredObject object) {
        Class<? extends ConfiguredObject> objectType = this.getConfiguredObjectType(object);
        Set<UUID> childrenIds = this.getChildernIds(object, objectType);
        ConfigurationEntry entry = new ConfigurationEntry(object.getId(), objectType.getSimpleName(), object.getActualAttributes(), childrenIds, this._store);
        return entry;
    }

    private Set<UUID> getChildernIds(ConfiguredObject object, Class<? extends ConfiguredObject> objectType) {
        if (object instanceof VirtualHost) {
            return Collections.emptySet();
        }
        TreeSet<UUID> childrenIds = new TreeSet<UUID>();
        Collection<Class<? extends ConfiguredObject>> childClasses = Model.getInstance().getChildTypes(objectType);
        if (childClasses != null) {
            for (Class<? extends ConfiguredObject> childClass : childClasses) {
                Collection<? extends ConfiguredObject> children = object.getChildren(childClass);
                if (children == null) continue;
                for (ConfiguredObject configuredObject : children) {
                    childrenIds.add(configuredObject.getId());
                }
            }
        }
        return childrenIds;
    }

    private Class<? extends ConfiguredObject> getConfiguredObjectType(ConfiguredObject object) {
        if (object instanceof Broker) {
            return Broker.class;
        }
        if (object instanceof VirtualHost) {
            return VirtualHost.class;
        }
        if (object instanceof Port) {
            return Port.class;
        }
        if (object instanceof AuthenticationProvider) {
            return AuthenticationProvider.class;
        }
        return this.getConfiguredObjectTypeFromImplementedInterfaces(object.getClass());
    }

    private Class<? extends ConfiguredObject> getConfiguredObjectTypeFromImplementedInterfaces(Class<?> objectClass) {
        Set<Class<?>> interfaces = this.getImplementedInterfacesExtendingSuper(objectClass, ConfiguredObject.class);
        if (interfaces.size() == 0) {
            throw new RuntimeException("Can not identify the configured object type");
        }
        if (interfaces.size() == 1) {
            return interfaces.iterator().next();
        }
        HashSet superInterfaces = new HashSet();
        for (Class<?> clazz : interfaces) {
            for (Class<?> interfaceClass2 : interfaces) {
                if (clazz == interfaceClass2 || !clazz.isAssignableFrom(interfaceClass2)) continue;
                superInterfaces.add(clazz);
            }
        }
        for (Class<Object> clazz : superInterfaces) {
            interfaces.remove(clazz);
        }
        if (interfaces.size() == 1) {
            return interfaces.iterator().next();
        }
        throw new RuntimeException("Can not identify the configured object type as an it implements more than one configured object interfaces: " + interfaces);
    }

    private Set<Class<?>> getImplementedInterfacesExtendingSuper(Class<?> classInstance, Class<?> superInterface) {
        Class<?>[] classInterfaces;
        HashSet interfaces = new HashSet();
        for (Class<?> interfaceClass : classInterfaces = classInstance.getInterfaces()) {
            if (interfaceClass == superInterface || !superInterface.isAssignableFrom(interfaceClass)) continue;
            interfaces.add(interfaceClass);
        }
        Class<?> superClass = classInstance.getSuperclass();
        if (superClass != null) {
            Set<Class<?>> superClassInterfaces = this.getImplementedInterfacesExtendingSuper(superClass, superInterface);
            interfaces.addAll(superClassInterfaces);
        }
        return interfaces;
    }

    public String toString() {
        return "StoreConfigurationChangeListener [store=" + this._store + "]";
    }
}

