/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.HeadersBinding;
import org.apache.qpid.server.exchange.HeadersExchangeType;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.plugin.ExchangeType;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadersExchange
extends AbstractExchange {
    private static final Logger _logger = Logger.getLogger(HeadersExchange.class);
    private final ConcurrentHashMap<String, CopyOnWriteArraySet<Binding>> _bindingsByKey = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<HeadersBinding> _bindingHeaderMatchers = new CopyOnWriteArrayList();
    public static final ExchangeType<HeadersExchange> TYPE = new HeadersExchangeType();

    public HeadersExchange() {
        super(TYPE);
    }

    public ArrayList<BaseQueue> doRoute(InboundMessage payload) {
        AMQMessageHeader header = payload.getMessageHeader();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Exchange " + this.getNameShortString() + ": routing message with headers " + header));
        }
        LinkedHashSet<AMQQueue> queues = new LinkedHashSet<AMQQueue>();
        for (HeadersBinding hb : this._bindingHeaderMatchers) {
            if (!hb.matches(header)) continue;
            Binding b = hb.getBinding();
            b.incrementMatches();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Exchange " + this.getNameShortString() + ": delivering message with headers " + header + " to " + b.getQueue().getNameShortString()));
            }
            queues.add(b.getQueue());
        }
        return new ArrayList<BaseQueue>(queues);
    }

    @Override
    public boolean isBound(String bindingKey, Map<String, Object> arguments, AMQQueue queue) {
        CopyOnWriteArraySet<Binding> bindings = bindingKey == null ? new CopyOnWriteArraySet<Binding>(this.getBindings()) : this._bindingsByKey.get(bindingKey);
        if (bindings != null) {
            for (Binding binding : bindings) {
                if (queue != null && !binding.getQueue().equals(queue)) continue;
                return arguments == null ? binding.getArguments() == null : ((Object)binding.getArguments()).equals(arguments);
            }
        }
        return false;
    }

    @Override
    public boolean isBound(AMQShortString routingKey, FieldTable arguments, AMQQueue queue) {
        return this.isBound(routingKey, queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey, AMQQueue queue) {
        String bindingKey = routingKey == null ? "" : routingKey.toString();
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(bindingKey);
        if (bindings != null) {
            for (Binding binding : bindings) {
                if (!binding.getQueue().equals(queue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isBound(AMQShortString routingKey) {
        String bindingKey = routingKey == null ? "" : routingKey.toString();
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(bindingKey);
        return bindings != null && !bindings.isEmpty();
    }

    @Override
    public boolean isBound(AMQQueue queue) {
        for (CopyOnWriteArraySet<Binding> bindings : this._bindingsByKey.values()) {
            for (Binding binding : bindings) {
                if (!binding.getQueue().equals(queue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasBindings() {
        return !this.getBindings().isEmpty();
    }

    @Override
    protected void onBind(Binding binding) {
        CopyOnWriteArraySet<Binding> newBindings;
        String bindingKey = binding.getBindingKey();
        AMQQueue queue = binding.getQueue();
        AMQShortString routingKey = AMQShortString.valueOf((String)bindingKey);
        Map<String, Object> args = binding.getArguments();
        assert (queue != null);
        assert (routingKey != null);
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(bindingKey);
        if (bindings == null && (newBindings = this._bindingsByKey.putIfAbsent(bindingKey, bindings = new CopyOnWriteArraySet())) != null) {
            bindings = newBindings;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Exchange " + this.getNameShortString() + ": Binding " + queue.getNameShortString() + " with binding key '" + bindingKey + "' and args: " + args));
        }
        this._bindingHeaderMatchers.add(new HeadersBinding(binding));
        bindings.add(binding);
    }

    @Override
    protected void onUnbind(Binding binding) {
        assert (binding != null);
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(binding.getBindingKey());
        if (bindings != null) {
            bindings.remove(binding);
        }
        boolean removedBinding = this._bindingHeaderMatchers.remove(new HeadersBinding(binding));
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Removing Binding: " + removedBinding));
        }
    }
}

