/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQConnectionException;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQUnknownExchangeType;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeDeclareHandler
implements StateAwareMethodListener<ExchangeDeclareBody> {
    private static final Logger _logger = Logger.getLogger(ExchangeDeclareHandler.class);
    private static final ExchangeDeclareHandler _instance = new ExchangeDeclareHandler();

    public static ExchangeDeclareHandler getInstance() {
        return _instance;
    }

    private ExchangeDeclareHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void methodReceived(AMQStateManager stateManager, ExchangeDeclareBody body, int channelId) throws AMQException {
        session = stateManager.getProtocolSession();
        virtualHost = session.getVirtualHost();
        exchangeRegistry = virtualHost.getExchangeRegistry();
        exchangeFactory = virtualHost.getExchangeFactory();
        channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        exchangeName = body.getExchange();
        if (ExchangeDeclareHandler._logger.isDebugEnabled()) {
            ExchangeDeclareHandler._logger.debug((Object)("Request to declare exchange of type " + body.getType() + " with name " + exchangeName));
        }
        var10_10 = exchangeRegistry;
        synchronized (var10_10) {
            exchange = exchangeRegistry.getExchange(exchangeName);
            if (exchange == null) {
                if (body.getPassive() && (body.getType() == null || body.getType().length() == 0)) {
                    throw body.getChannelException(AMQConstant.NOT_FOUND, "Unknown exchange: " + exchangeName);
                }
                if (exchangeName.startsWith("amq.")) {
                    throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Attempt to declare exchange: " + exchangeName + " which begins with reserved prefix 'amq.'.");
                }
                if (exchangeName.startsWith("qpid.")) {
                    throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Attempt to declare exchange: " + exchangeName + " which begins with reserved prefix 'qpid.'.");
                }
                try {
                    exchange = exchangeFactory.createExchange(exchangeName == null ? null : exchangeName.intern(), body.getType() == null ? null : body.getType().intern(), body.getDurable(), body.getAutoDelete(), body.getTicket());
                    exchangeRegistry.registerExchange(exchange);
                    if (!exchange.isDurable()) ** GOTO lbl35
                    virtualHost.getMessageStore().createExchange(exchange);
                }
                catch (AMQUnknownExchangeType e) {
                    throw body.getConnectionException(AMQConstant.COMMAND_INVALID, "Unknown exchange: " + exchangeName, (Throwable)e);
                }
            } else if (!exchange.getTypeShortString().equals(body.getType()) && (body.getType() != null && body.getType().length() != 0 || !body.getPassive())) {
                throw new AMQConnectionException(AMQConstant.NOT_ALLOWED, "Attempt to redeclare exchange: " + exchangeName + " of type " + exchange.getTypeShortString() + " to " + body.getType() + ".", body.getClazz(), body.getMethod(), body.getMajor(), body.getMinor(), null);
            }
        }
lbl35:
        // 3 sources

        if (!body.getNowait()) {
            methodRegistry = session.getMethodRegistry();
            responseBody = methodRegistry.createExchangeDeclareOkBody();
            channel.sync();
            session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
        }
    }
}

