/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.actors;

import java.security.AccessController;
import javax.security.auth.Subject;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.logging.actors.AbstractActor;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;

public abstract class AbstractManagementActor
extends AbstractActor {
    protected static final String UNKNOWN_PRINCIPAL = "N/A";
    private final String _fallbackPrincipalName;

    public AbstractManagementActor(RootMessageLogger rootLogger, String fallbackPrincipalName) {
        super(rootLogger);
        this._fallbackPrincipalName = fallbackPrincipalName;
    }

    protected String getPrincipalName() {
        AuthenticatedPrincipal authenticatedPrincipal;
        String identity = this._fallbackPrincipalName;
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null && (authenticatedPrincipal = AuthenticatedPrincipal.getOptionalAuthenticatedPrincipalFromSubject(subject)) != null) {
            identity = authenticatedPrincipal.getName();
        }
        return identity;
    }
}

