/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.actors;

import java.util.EmptyStackException;
import java.util.Stack;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.LogSubject;

public class CurrentActor {
    private static final ThreadLocal<Stack<LogActor>> _currentActor = new ThreadLocal<Stack<LogActor>>(){

        @Override
        protected Stack<LogActor> initialValue() {
            return new Stack<LogActor>();
        }
    };
    private static LogActor _defaultActor;

    private CurrentActor() {
    }

    public static void set(LogActor actor) {
        Stack<LogActor> stack = _currentActor.get();
        stack.push(actor);
    }

    public static void removeAll() {
        Stack<LogActor> stack = _currentActor.get();
        stack.clear();
    }

    public static void remove() {
        Stack<LogActor> stack = _currentActor.get();
        stack.pop();
        if (stack.isEmpty()) {
            _currentActor.remove();
        }
    }

    public static LogActor get() {
        try {
            return _currentActor.get().peek();
        }
        catch (EmptyStackException ese) {
            return _defaultActor;
        }
    }

    public static void setDefault(LogActor defaultActor) {
        _defaultActor = defaultActor;
    }

    public static void message(LogSubject subject, LogMessage message) {
        CurrentActor.get().message(subject, message);
    }

    public static void message(LogMessage message) {
        CurrentActor.get().message(message);
    }
}

